/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.BlockExp;
import gnu.expr.ExitExp;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.ObjectExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.expr.SynchronizedExp;
import gnu.expr.ThisExp;
import gnu.expr.TryExp;

public class ExpWalker {
    LambdaExp currentLambda = null;
    Object exitValue = null;

    protected Expression walkExpression(Expression expression) {
        expression.walkChildren(this);
        return expression;
    }

    protected Expression walkApplyExp(ApplyExp applyExp) {
        return this.walkExpression(applyExp);
    }

    protected Expression walkIfExp(IfExp ifExp) {
        return this.walkExpression(ifExp);
    }

    protected Expression walkScopeExp(ScopeExp scopeExp) {
        return this.walkExpression(scopeExp);
    }

    protected Expression walkLetExp(LetExp letExp) {
        return this.walkScopeExp(letExp);
    }

    protected Expression walkLambdaExp(LambdaExp lambdaExp) {
        return this.walkScopeExp(lambdaExp);
    }

    protected Expression walkObjectExp(ObjectExp objectExp) {
        return this.walkLambdaExp(objectExp);
    }

    protected Expression walkModuleExp(ModuleExp moduleExp) {
        return this.walkLambdaExp(moduleExp);
    }

    protected Expression walkSetExp(SetExp setExp) {
        return this.walkExpression(setExp);
    }

    protected Expression walkTryExp(TryExp tryExp) {
        return this.walkExpression(tryExp);
    }

    protected Expression walkBeginExp(BeginExp beginExp) {
        return this.walkExpression(beginExp);
    }

    protected Expression walkQuoteExp(QuoteExp quoteExp) {
        return this.walkExpression(quoteExp);
    }

    protected Expression walkReferenceExp(ReferenceExp referenceExp) {
        return this.walkExpression(referenceExp);
    }

    protected Expression walkThisExp(ThisExp thisExp) {
        return this.walkReferenceExp(thisExp);
    }

    protected Expression walkSynchronizedExp(SynchronizedExp synchronizedExp) {
        return this.walkExpression(synchronizedExp);
    }

    protected Expression walkBlockExp(BlockExp blockExp) {
        return this.walkExpression(blockExp);
    }

    protected Expression walkExitExp(ExitExp exitExp) {
        return this.walkExpression(exitExp);
    }

    protected Expression walkFluidLetExp(FluidLetExp fluidLetExp) {
        return this.walkLetExp(fluidLetExp);
    }

    public final LambdaExp getCurrentLambda() {
        return this.currentLambda;
    }

    public Expression[] walkExps(Expression[] expressionArray) {
        return this.walkExps(expressionArray, expressionArray.length);
    }

    public Expression[] walkExps(Expression[] expressionArray, int n) {
        int n2 = 0;
        while (n2 < n && this.exitValue == null) {
            expressionArray[n2] = expressionArray[n2].walk(this);
            ++n2;
        }
        return expressionArray;
    }

    public void walkDefaultArgs(LambdaExp lambdaExp) {
        if (lambdaExp.defaultArgs != null) {
            lambdaExp.defaultArgs = this.walkExps(lambdaExp.defaultArgs);
        }
    }
}

