/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayClassLoader;
import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.Literal;
import gnu.expr.ModuleBody;
import gnu.expr.QuoteExp;
import gnu.kawa.reflect.ClassMemberConstraint;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Printable;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kawa.lang.Macro;

public class ModuleExp
extends ClassExp {
    public boolean mustCompile;
    public static boolean debugPrintExpr = false;
    public static final int EXPORT_SPECIFIED = 2048;
    public static final int STATIC_SPECIFIED = 4096;
    public static final int NONSTATIC_SPECIFIED = 8192;
    public static final int SUPERTYPE_SPECIFIED = 16384;
    public static String dumpZipPrefix;
    public static int dumpZipCounter;
    ClassType superType;
    ClassType[] interfaces;

    public Object eval(Environment environment) {
        try {
            Class clazz = this.evalToClass();
            Object t = clazz.newInstance();
            Procedure procedure = (Procedure)t;
            if (procedure.getName() == null) {
                procedure.setName(this.name);
            }
            return t;
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("class not instantiable: in lambda eval");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("class illegal access: in lambda eval");
        }
    }

    public Class evalToClass() {
        try {
            Object object2;
            Object object3;
            Object object4;
            String string = this.getJavaName();
            Compilation compilation = new Compilation(this, string, null, true);
            byte[][] byArrayArray = new byte[compilation.numClasses][];
            String[] stringArray = new String[compilation.numClasses];
            int n = 0;
            while (n < compilation.numClasses) {
                object4 = compilation.classes[n];
                stringArray[n] = ((Type)object4).getName();
                byArrayArray[n] = ((ClassType)object4).writeToArray();
                ++n;
            }
            if (dumpZipPrefix != null) {
                object4 = new StringBuffer(dumpZipPrefix);
                if (dumpZipCounter >= 0) {
                    ((StringBuffer)object4).append(++dumpZipCounter);
                }
                ((StringBuffer)object4).append(".zip");
                object3 = new FileOutputStream(((StringBuffer)object4).toString());
                object2 = new ZipOutputStream((OutputStream)object3);
                int n2 = 0;
                while (n2 < compilation.numClasses) {
                    String string2 = stringArray[n2].replace('.', '/') + ".class";
                    ZipEntry zipEntry = new ZipEntry(string2);
                    zipEntry.setSize(byArrayArray[n2].length);
                    CRC32 cRC32 = new CRC32();
                    cRC32.update(byArrayArray[n2]);
                    zipEntry.setCrc(cRC32.getValue());
                    zipEntry.setMethod(0);
                    ((ZipOutputStream)object2).putNextEntry(zipEntry);
                    ((FilterOutputStream)object2).write(byArrayArray[n2]);
                    ++n2;
                }
                ((ZipOutputStream)object2).close();
            }
            object4 = new ArrayClassLoader(stringArray, byArrayArray);
            object3 = ((ArrayClassLoader)object4).loadClass(string, true);
            object2 = compilation.literalsChain;
            while (object2 != null) {
                try {
                    ((Class)object3).getDeclaredField(((Literal)object2).field.getName()).set(null, ((Literal)object2).value);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new Error("internal error - " + noSuchFieldException);
                }
                object2 = ((Literal)object2).next;
            }
            return object3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(OutPort.errDefault());
            throw new RuntimeException("I/O error in lambda eval: " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("class not found in lambda eval");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("class illegal access: in lambda eval");
        }
    }

    public final Object evalModule(Environment environment) {
        CallContext callContext = new CallContext();
        callContext.values = Values.noArgs;
        this.evalModule(environment, callContext);
        return Values.make(callContext.vstack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void evalModule(Environment environment, CallContext callContext) {
        Environment environment2 = Environment.getCurrent();
        try {
            Printable printable;
            if (environment != environment2) {
                Environment.setCurrent(environment);
            }
            if (debugPrintExpr) {
                printable = OutPort.outDefault();
                ((PrintWriter)((Object)printable)).println("[Evaluating module \"" + this.getName() + "\" mustCompile=" + this.mustCompile + ':');
                this.print((OutPort)printable);
                ((PrintWriter)((Object)printable)).println(']');
                ((PrintWriter)((Object)printable)).flush();
            }
            if (!this.mustCompile) {
                this.body.eval(environment, callContext);
            } else {
                printable = (ModuleBody)this.eval(environment);
                ClassMemberConstraint.defineAll(printable, environment);
                callContext.proc = printable;
                callContext.run();
            }
            Object var6_5 = null;
            if (environment == environment2) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (environment == environment2) throw throwable;
            Environment.setCurrent(environment2);
            throw throwable;
        }
        Environment.setCurrent(environment2);
    }

    public final ClassType getSuperType() {
        return this.superType;
    }

    public final void setSuperType(ClassType classType) {
        this.superType = classType;
    }

    public final ClassType[] getInterfaces() {
        return this.interfaces;
    }

    public final void setInterfaces(ClassType[] classTypeArray) {
        this.interfaces = classTypeArray;
    }

    public final boolean isStatic() {
        return this.getFlag(4096) || Compilation.moduleStatic > 0 && !this.getFlag(16384) && !this.getFlag(8192);
    }

    void allocFields(Compilation compilation) {
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            if (!(declaration.isSimple() && !declaration.isPublic() || declaration.field != null || declaration.getFlag(32768) && ((Macro)declaration.getConstantValue()).expander instanceof LambdaExp && !declaration.isPrivate())) {
                Expression expression = declaration.getValue();
                if (expression instanceof LambdaExp) {
                    ((LambdaExp)expression).allocFieldFor(compilation);
                } else {
                    if (!(expression instanceof QuoteExp) || !declaration.getFlag(16384) || compilation.immediate) {
                        expression = null;
                    }
                    declaration.makeField(compilation, expression);
                }
            }
            declaration = declaration.nextDecl();
        }
    }

    public void compileToFiles(String string, String string2, String string3) throws IOException {
        if (string2 == null || string2.length() == 0) {
            string2 = "";
        } else if (string2.charAt(string2.length() - 1) != '/') {
            string2 = string2 + '/';
        }
        String string4 = this.getName();
        if (string4 != null) {
            int n;
            string = string4;
            if (string3 == null && (n = string4.lastIndexOf(46)) >= 0) {
                string3 = string4.substring(0, n + 1);
            }
        }
        if (debugPrintExpr) {
            OutPort outPort = OutPort.outDefault();
            outPort.println("[Compiling module-name:" + this.getName() + " top:" + string + " prefix=" + string3 + " :");
            this.print(outPort);
            outPort.println(']');
            outPort.flush();
        }
        Compilation compilation = new Compilation(this, string, string3, false);
        int n = 0;
        while (n < compilation.numClasses) {
            ClassType classType = compilation.classes[n];
            String string5 = string2 + classType.getName().replace('.', File.separatorChar) + ".class";
            String string6 = new File(string5).getParent();
            if (string6 != null) {
                new File(string6).mkdirs();
            }
            classType.writeToFile(string5);
            ++n;
        }
    }

    public void compileToArchive(String string) throws IOException {
        boolean bl = false;
        if (string.endsWith(".zip")) {
            bl = false;
        } else if (string.endsWith(".jar")) {
            bl = true;
        } else {
            string = string + ".zip";
            bl = false;
        }
        Compilation compilation = new Compilation(this, LambdaExp.fileFunctionName, null, false);
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        zipOutputStream.setMethod(0);
        byte[][] byArrayArray = new byte[compilation.numClasses][];
        CRC32 cRC32 = new CRC32();
        int n = 0;
        while (n < compilation.numClasses) {
            ClassType classType = compilation.classes[n];
            byArrayArray[n] = classType.writeToArray();
            ZipEntry zipEntry = new ZipEntry(classType.getName().replace('.', '/') + ".class");
            zipEntry.setSize(byArrayArray[n].length);
            cRC32.reset();
            cRC32.update(byArrayArray[n], 0, byArrayArray[n].length);
            zipEntry.setCrc(cRC32.getValue());
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(byArrayArray[n]);
            ++n;
        }
        zipOutputStream.close();
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkModuleExp(this);
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Module/", ")", 2);
        if (this.name != null) {
            outPort.print(this.name);
            outPort.print('/');
        }
        outPort.print(this.id);
        outPort.print('/');
        outPort.writeSpaceFill();
        outPort.startLogicalBlock("(", false, ")");
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            outPort.print(declaration);
            outPort.writeSpaceFill();
            declaration = declaration.nextDecl();
        }
        outPort.endLogicalBlock(")");
        outPort.writeSpaceLinear();
        if (this.body == null) {
            outPort.print("<null body>");
        } else {
            this.body.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }
}

