/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Array;
import gnu.lists.FVector;
import gnu.lists.SimpleVector;

public class GeneralArray
implements Array {
    SimpleVector base;
    int rank;
    int[] dimensions;
    int[] stride;
    int offset;

    public GeneralArray(int[] nArray) {
        int n = 1;
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        int n3 = n2;
        while (--n3 >= 0) {
            nArray2[n3] = n;
            n *= nArray[n3];
        }
        this.base = new FVector(n);
        this.dimensions = nArray;
        this.rank = n2;
        this.offset = 0;
    }

    public int rank() {
        return this.rank;
    }

    public int getEffectiveIndex(int[] nArray) {
        int n = this.offset;
        int n2 = this.rank;
        while (--n2 >= 0) {
            int n3 = nArray[n2];
            if (n3 < 0 || n3 >= this.dimensions[n2]) {
                throw new IndexOutOfBoundsException();
            }
            n += this.stride[n2] * n3;
        }
        return n;
    }

    public Object get(int[] nArray) {
        return this.base.get(this.getEffectiveIndex(nArray));
    }

    public Object set(int[] nArray, Object object2) {
        return this.base.set(this.getEffectiveIndex(nArray), object2);
    }

    public int size() {
        int n = 1;
        int n2 = this.rank;
        while (--n2 >= 0) {
            n *= this.dimensions[n2];
        }
        return n;
    }
}

