/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.expr.Interpreter;
import gnu.expr.ModuleExp;
import gnu.kawa.lispexpr.LispReader;
import gnu.lists.FormatToConsumer;
import gnu.lists.LList;
import gnu.lists.PairWithPosition;
import gnu.lists.Sequence;
import gnu.lists.VoidConsumer;
import gnu.mapping.Binding;
import gnu.mapping.CallContext;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.TtyInPort;
import gnu.mapping.WrongArguments;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.FileNotFoundException;
import kawa.lang.Translator;
import kawa.standard.Scheme;
import kawa.standard.load;

public class Shell {
    public static void run(Interpreter interpreter) {
        Shell.run(interpreter, interpreter.getEnvironment());
    }

    public static void run(Interpreter interpreter, Environment environment) {
        Binding binding;
        InPort inPort = InPort.inDefault();
        if (inPort instanceof TtyInPort && (binding = Environment.getCurrentBinding("default-prompter")) != null) {
            Procedure procedure = binding.getProcedure();
            ((TtyInPort)inPort).setPrompter(procedure);
        }
        Shell.run(interpreter, environment, inPort, OutPort.outDefault(), OutPort.errDefault());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void run(Interpreter interpreter, Environment environment, InPort inPort, OutPort outPort, OutPort outPort2) {
        SourceMessages sourceMessages = new SourceMessages();
        Translator translator = new Translator(environment, sourceMessages);
        translator.immediate = true;
        Lexer lexer = interpreter.getLexer(inPort, sourceMessages);
        CallContext callContext = new CallContext();
        FormatToConsumer formatToConsumer = null;
        if (outPort == null) {
            callContext.consumer = new VoidConsumer();
        } else {
            formatToConsumer = outPort.objectFormat;
            outPort.objectFormat = interpreter.getFormat(false);
            callContext.consumer = outPort;
        }
        try {
            block14: {
                block7: while (true) {
                    try {
                        while (true) {
                            int n;
                            lexer.clearErrors();
                            PairWithPosition pairWithPosition = PairWithPosition.make(null, LList.Empty, inPort.getName(), inPort.getLineNumber() + 1, inPort.getColumnNumber() + 1);
                            Object object2 = ((LispReader)lexer).readObject();
                            if (object2 == Sequence.eofValue) {
                                Object var15_18 = null;
                                if (outPort == null) return;
                                break block7;
                            }
                            while ((n = inPort.read()) >= 0 && n != 13 && n != 10) {
                                if (n == 32 || n == 9) continue;
                                inPort.unread();
                                break;
                            }
                            pairWithPosition.car = object2;
                            ModuleExp moduleExp = Scheme.makeModuleExp(pairWithPosition, translator);
                            moduleExp.setName("atInteractiveLevel");
                            if (lexer.checkErrors(outPort2, 20)) continue;
                            moduleExp.evalModule(environment, callContext);
                            callContext.run();
                            if (n < 0) break;
                        }
                        break block14;
                    }
                    catch (WrongArguments wrongArguments) {
                        if (wrongArguments.usage != null) {
                            outPort2.println("usage: " + wrongArguments.usage);
                        }
                        wrongArguments.printStackTrace(outPort2);
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        outPort2.println("Invalid parameter, was: " + classCastException.getMessage());
                        classCastException.printStackTrace(outPort2);
                        continue;
                    }
                    catch (SyntaxException syntaxException) {
                        syntaxException.printAll(outPort2, 20);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(outPort2);
                        continue;
                    }
                    break;
                }
                outPort.objectFormat = formatToConsumer;
                return;
            }
            Object var15_19 = null;
            if (outPort == null) return;
            outPort.objectFormat = formatToConsumer;
            return;
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            if (outPort == null) throw throwable;
            outPort.objectFormat = formatToConsumer;
            throw throwable;
        }
    }

    public static void runString(String string, Interpreter interpreter, Environment environment) {
        Shell.run(interpreter, environment, new CharArrayInPort(string), null, OutPort.errDefault());
    }

    public static void runFile(String string) {
        Environment environment = Environment.user();
        try {
            if (string.equals("-")) {
                load.loadSource(InPort.inDefault(), environment);
            } else {
                load.apply(string, environment);
            }
        }
        catch (SyntaxException syntaxException) {
            syntaxException.printAll(OutPort.errDefault(), 20);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Cannot open file " + string);
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

