/*
 * Decompiled with CFR 0.152.
 */
package kawa.lib;

import gnu.expr.Interpreter;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleMethod;
import gnu.kawa.functions.AddOp;
import gnu.lists.FString;
import gnu.lists.Sequence;
import gnu.mapping.Binding;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.CharArrayOutPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.TtyInPort;
import gnu.mapping.WrongType;
import gnu.math.IntNum;
import gnu.text.Char;
import gnu.text.LineBufferedReader;
import java.io.Writer;
import kawa.lib.characters;

public class ports
extends ModuleBody {
    static final ports $instance = new ports();
    public static final ModuleMethod isInputPort;
    public static final ModuleMethod isOutputPort;
    public static final ModuleMethod currentInputPort;
    public static final ModuleMethod currentOutputPort;
    public static final ModuleMethod writeChar;
    public static final ModuleMethod openInputString;
    public static final ModuleMethod openOutputString;
    public static final ModuleMethod getOutputString;
    public static final ModuleMethod callWithInputString;
    public static final ModuleMethod forceOutput;
    public static final ModuleMethod newline;
    public static final ModuleMethod isEofObject;
    public static final ModuleMethod inputPortReadState;
    public static final ModuleMethod portLine;
    public static final ModuleMethod inputPortLineNumber;
    public static final ModuleMethod setPortLine$Ex;
    public static final ModuleMethod setInputPortLineNumber$Ex;
    public static final ModuleMethod portColumn;
    public static final ModuleMethod inputPortColumnNumber;
    public static final ModuleMethod defaultPrompter;
    public static final ModuleMethod inputPortPrompter;
    public static final ModuleMethod setInputPortPrompter$Ex;
    public static final ModuleMethod closeInputPort;
    public static final ModuleMethod closeOutputPort;
    public static final ModuleMethod transcriptOn;
    public static final ModuleMethod transcriptOff;
    static final Binding id$$LsInputPort$Gr;
    static final Binding id$$LsOutputPort$Gr;
    static final Binding id$$LsGnu$DtMapping$DtCharArrayInPort$Gr;
    static final Binding id$$LsStringOutputPort$Gr;
    static final Binding id$setPortLine;
    static final Binding id$stringAppend;
    static final Binding id$makeString;
    static final Binding id$number$To$String;
    static final IntNum Lit0;
    static final Char Lit1;
    static final FString Lit2;
    static final Char Lit3;
    static final FString Lit4;
    static final FString Lit5;
    static final FString Lit6;
    static final FString Lit7;

    /*
     * Enabled aggressive block sorting
     */
    static {
        Lit7 = new FString("|# ");
        Lit6 = new FString("---:");
        Lit5 = new FString("#|");
        Lit4 = new FString("#|kawa:");
        Lit3 = Char.make(32);
        Lit2 = new FString("");
        Lit1 = Char.make(10);
        Lit0 = IntNum.make(1);
        isInputPort = new ModuleMethod($instance, 22, "input-port?", 4097);
        isOutputPort = new ModuleMethod($instance, 21, "output-port?", 4097);
        currentInputPort = new ModuleMethod($instance, 6, "current-input-port", 0);
        currentOutputPort = new ModuleMethod($instance, 5, "current-output-port", 0);
        writeChar = new ModuleMethod($instance, 20, "write-char", 8193);
        openInputString = new ModuleMethod($instance, 19, "open-input-string", 4097);
        openOutputString = new ModuleMethod($instance, 4, "open-output-string", 0);
        getOutputString = new ModuleMethod($instance, 18, "get-output-string", 4097);
        callWithInputString = new ModuleMethod($instance, 26, "call-with-input-string", 8194);
        forceOutput = new ModuleMethod($instance, 3, "force-output", 4096);
        newline = new ModuleMethod($instance, 2, "newline", 4096);
        isEofObject = new ModuleMethod($instance, 17, "eof-object?", 4097);
        inputPortReadState = new ModuleMethod($instance, 16, "input-port-read-state", 4097);
        portLine = new ModuleMethod($instance, 15, "port-line", 4097);
        inputPortLineNumber = new ModuleMethod($instance, 14, "input-port-line-number", 4097);
        setPortLine$Ex = new ModuleMethod($instance, 25, "set-port-line!", 8194);
        setInputPortLineNumber$Ex = new ModuleMethod($instance, 24, "set-input-port-line-number!", 8194);
        portColumn = new ModuleMethod($instance, 13, "port-column", 4097);
        inputPortColumnNumber = new ModuleMethod($instance, 12, "input-port-column-number", 4097);
        defaultPrompter = new ModuleMethod($instance, 11, "default-prompter", 4097);
        inputPortPrompter = new ModuleMethod($instance, 10, "input-port-prompter", 4097);
        setInputPortPrompter$Ex = new ModuleMethod($instance, 23, "set-input-port-prompter!", 8194);
        closeInputPort = new ModuleMethod($instance, 9, "close-input-port", 4097);
        closeOutputPort = new ModuleMethod($instance, 8, "close-output-port", 4097);
        transcriptOn = new ModuleMethod($instance, 7, "transcript-on", 4097);
        transcriptOff = new ModuleMethod($instance, 1, "transcript-off", 0);
        Environment env$ = Environment.getCurrent();
        id$$LsInputPort$Gr = env$.getBinding("<input-port>");
        id$stringAppend = env$.getBinding("string-append");
        id$$LsGnu$DtMapping$DtCharArrayInPort$Gr = env$.getBinding("<gnu.mapping.CharArrayInPort>");
        id$number$To$String = env$.getBinding("number->string");
        id$$LsStringOutputPort$Gr = env$.getBinding("<string-output-port>");
        id$makeString = env$.getBinding("make-string");
        id$setPortLine = env$.getBinding("set-port-line");
        id$$LsOutputPort$Gr = env$.getBinding("<output-port>");
        Object object2 = Interpreter.voidObject;
    }

    public static boolean isInputPort(Object x) {
        return x instanceof InPort;
    }

    public static boolean isOutputPort(Object x) {
        return x instanceof OutPort;
    }

    public static InPort currentInputPort() {
        return InPort.inDefault();
    }

    public static OutPort currentOutputPort() {
        return OutPort.outDefault();
    }

    public static void writeChar(Object object2) {
        ports.writeChar(object2, OutPort.outDefault());
    }

    public static void writeChar(Object ch, OutPort port) {
        port.writeSchemeObject(ch, false);
    }

    public static InPort openInputString(FString str) {
        return new CharArrayInPort(str.data, str.size);
    }

    public static CharArrayOutPort openOutputString() {
        return new CharArrayOutPort();
    }

    public static FString getOutputString(CharArrayOutPort outputPort) {
        return new FString(outputPort.toCharArray());
    }

    /*
     * WARNING - void declaration
     */
    public static Object callWithInputString(FString str, Object proc) {
        CharArrayInPort port = new CharArrayInPort(str.data, str.size);
        Object result = ((Procedure)proc).apply1(port);
        try {
            void var3_3;
            ports.closeInputPort(port);
            return var3_3;
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "close-input-port", 0);
        }
    }

    public static void forceOutput() {
        ports.forceOutput(ports.currentOutputPort());
    }

    public static void forceOutput(Object port) {
        try {
            ((Writer)port).flush();
            return;
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "java.io.Writer.flush()", 0);
        }
    }

    public static void newline() {
        ports.newline(ports.currentOutputPort());
    }

    public static void newline(Object port) {
        try {
            ((OutPort)port).println();
            return;
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "gnu.mapping.OutPort.println()", 0);
        }
    }

    public static boolean isEofObject(Object obj) {
        return obj == Sequence.eofValue;
    }

    public static char inputPortReadState(Object port) {
        try {
            return ((InPort)port).getReadState();
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "gnu.mapping.InPort.getReadState()", 0);
        }
    }

    public static int portLine(Object port) {
        try {
            return ((LineBufferedReader)port).getLineNumber();
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "gnu.text.LineBufferedReader.getLineNumber()", 0);
        }
    }

    public static Object inputPortLineNumber(Object port) {
        return AddOp.$Pl(Lit0, IntNum.make(ports.portLine(port)));
    }

    public static void setPortLine$Ex(Object port, Object line) {
        LineBufferedReader lineBufferedReader;
        try {
            lineBufferedReader = (LineBufferedReader)port;
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "gnu.text.LineBufferedReader.setLineNumber(int)", 0);
        }
        try {
            lineBufferedReader.setLineNumber(((Number)line).intValue());
            return;
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "gnu.text.LineBufferedReader.setLineNumber(int)", 1);
        }
    }

    public static Object setInputPortLineNumber$Ex(Object port, Object num) {
        return id$setPortLine.getProcedure().apply2(port, AddOp.$Mn(num, Lit0));
    }

    public static int portColumn(Object port) {
        try {
            return ((LineBufferedReader)port).getColumnNumber();
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "gnu.text.LineBufferedReader.getColumnNumber()", 0);
        }
    }

    public static Object inputPortColumnNumber(Object port) {
        return AddOp.$Pl(Lit0, IntNum.make(ports.portColumn(port)));
    }

    public static Object defaultPrompter(Object port) {
        Object object2;
        block5: {
            Char state;
            block4: {
                state = Char.make(ports.inputPortReadState(port));
                try {
                    if (!characters.isChar$Eq(state, Lit1)) break block4;
                    object2 = Lit2;
                    break block5;
                }
                catch (ClassCastException classCastException) {
                    throw WrongType.make(classCastException, "char=?", 0);
                }
            }
            try {
                object2 = id$stringAppend.getProcedure().apply3(characters.isChar$Eq(state, Lit3) ? Lit4 : id$stringAppend.getProcedure().apply3(Lit5, id$makeString.getProcedure().apply2(Lit0, state), Lit6), id$number$To$String.getProcedure().apply1(ports.inputPortLineNumber(port)), Lit7);
            }
            catch (ClassCastException classCastException) {
                throw WrongType.make(classCastException, "char=?", 0);
            }
        }
        return object2;
    }

    public static Procedure inputPortPrompter(Object port) {
        try {
            return ((TtyInPort)port).getPrompter();
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "gnu.mapping.TtyInPort.getPrompter()", 0);
        }
    }

    public static void setInputPortPrompter$Ex(Object port, Object prompter) {
        TtyInPort ttyInPort;
        try {
            ttyInPort = (TtyInPort)port;
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "gnu.mapping.TtyInPort.setPrompter(gnu.mapping.Procedure)", 0);
        }
        try {
            ttyInPort.setPrompter((Procedure)prompter);
            return;
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "gnu.mapping.TtyInPort.setPrompter(gnu.mapping.Procedure)", 1);
        }
    }

    public static void closeInputPort(InPort port) {
        port.close();
    }

    public static Object closeOutputPort(OutPort port) {
        port.close();
        return Interpreter.voidObject;
    }

    public static void transcriptOn(Object filename) {
        try {
            OutPort.setLogFile(filename.toString());
            return;
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "gnu.mapping.OutPort.setLogFile(java.lang.String)", 0);
        }
    }

    public static void transcriptOff() {
        OutPort.closeLogFile();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object apply0(ModuleMethod moduleMethod) {
        switch (moduleMethod.selector) {
            case 1: {
                ports.transcriptOff();
                return Interpreter.voidObject;
            }
            case 2: {
                ports.newline();
                return Interpreter.voidObject;
            }
            case 3: {
                ports.forceOutput();
                return Interpreter.voidObject;
            }
            case 4: {
                return ports.openOutputString();
            }
            case 5: {
                return ports.currentOutputPort();
            }
            case 6: {
                return ports.currentInputPort();
            }
        }
        return super.apply0(moduleMethod);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object apply1(ModuleMethod moduleMethod, Object object2) {
        switch (moduleMethod.selector) {
            case 7: {
                ports.transcriptOn(object2);
                return Interpreter.voidObject;
            }
            case 8: {
                return ports.closeOutputPort((OutPort)object2);
            }
            case 9: {
                ports.closeInputPort((InPort)object2);
                return Interpreter.voidObject;
            }
            case 10: {
                return ports.inputPortPrompter(object2);
            }
            case 11: {
                return ports.defaultPrompter(object2);
            }
            case 12: {
                return ports.inputPortColumnNumber(object2);
            }
            case 13: {
                return IntNum.make(ports.portColumn(object2));
            }
            case 14: {
                return ports.inputPortLineNumber(object2);
            }
            case 15: {
                return IntNum.make(ports.portLine(object2));
            }
            case 16: {
                return Char.make(ports.inputPortReadState(object2));
            }
            case 17: {
                Boolean bl;
                if (ports.isEofObject(object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 2: {
                ports.newline(object2);
                return Interpreter.voidObject;
            }
            case 3: {
                ports.forceOutput(object2);
                return Interpreter.voidObject;
            }
            case 18: {
                return ports.getOutputString((CharArrayOutPort)object2);
            }
            case 19: {
                return ports.openInputString((FString)object2);
            }
            case 20: {
                ports.writeChar(object2);
                return Interpreter.voidObject;
            }
            case 21: {
                Boolean bl;
                if (ports.isOutputPort(object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 22: {
                Boolean bl;
                if (ports.isInputPort(object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
        }
        return super.apply1(moduleMethod, object2);
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "open-input-string", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "get-output-string", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "close-input-port", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "close-output-port", 0);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object apply2(ModuleMethod moduleMethod, Object object2, Object object3) {
        switch (moduleMethod.selector) {
            case 23: {
                ports.setInputPortPrompter$Ex(object2, object3);
                return Interpreter.voidObject;
            }
            case 24: {
                return ports.setInputPortLineNumber$Ex(object2, object3);
            }
            case 25: {
                ports.setPortLine$Ex(object2, object3);
                return Interpreter.voidObject;
            }
            case 26: {
                return ports.callWithInputString((FString)object2, object3);
            }
            case 20: {
                ports.writeChar(object2, (OutPort)object3);
                return Interpreter.voidObject;
            }
        }
        return super.apply2(moduleMethod, object2, object3);
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "write-char", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "call-with-input-string", 0);
        }
    }
}

