/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class ColumnInfoRecord
extends Record {
    public static final short sid = 125;
    private short field_1_first_col;
    private short field_2_last_col;
    private short field_3_col_width;
    private short field_4_xf_index;
    private short field_5_options;
    private static final BitField hidden = new BitField(1);
    private static final BitField outlevel = new BitField(1792);
    private static final BitField collapsed = new BitField(4096);
    private short field_6_reserved;

    public ColumnInfoRecord() {
    }

    public ColumnInfoRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public ColumnInfoRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data);
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_first_col = LittleEndian.getShort(data, 0 + offset);
        this.field_2_last_col = LittleEndian.getShort(data, 2 + offset);
        this.field_3_col_width = LittleEndian.getShort(data, 4 + offset);
        this.field_4_xf_index = LittleEndian.getShort(data, 6 + offset);
        this.field_5_options = LittleEndian.getShort(data, 8 + offset);
        this.field_6_reserved = data[10 + offset];
    }

    protected void validateSid(short id) {
        if (id != 125) {
            throw new RecordFormatException("NOT A COLINFO RECORD!!");
        }
    }

    public void setFirstColumn(short fc) {
        this.field_1_first_col = fc;
    }

    public void setLastColumn(short lc) {
        this.field_2_last_col = lc;
    }

    public void setColumnWidth(short cw) {
        this.field_3_col_width = cw;
    }

    public void setXFIndex(short xfi) {
        this.field_4_xf_index = xfi;
    }

    public void setOptions(short options) {
        this.field_5_options = options;
    }

    public void setHidden(boolean ishidden) {
        this.field_5_options = hidden.setShortBoolean(this.field_5_options, ishidden);
    }

    public void setOutlineLevel(short olevel) {
        this.field_5_options = outlevel.setShortValue(this.field_5_options, olevel);
    }

    public void setCollapsed(boolean iscollapsed) {
        this.field_5_options = collapsed.setShortBoolean(this.field_5_options, iscollapsed);
    }

    public short getFirstColumn() {
        return this.field_1_first_col;
    }

    public short getLastColumn() {
        return this.field_2_last_col;
    }

    public short getColumnWidth() {
        return this.field_3_col_width;
    }

    public short getXFIndex() {
        return this.field_4_xf_index;
    }

    public short getOptions() {
        return this.field_5_options;
    }

    public boolean getHidden() {
        return hidden.isSet(this.field_5_options);
    }

    public short getOutlineLevel() {
        return outlevel.getShortValue(this.field_5_options);
    }

    public boolean getCollapsed() {
        return collapsed.isSet(this.field_5_options);
    }

    public short getSid() {
        return 125;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)125);
        LittleEndian.putShort(data, 2 + offset, (short)12);
        LittleEndian.putShort(data, 4 + offset, this.getFirstColumn());
        LittleEndian.putShort(data, 6 + offset, this.getLastColumn());
        LittleEndian.putShort(data, 8 + offset, this.getColumnWidth());
        LittleEndian.putShort(data, 10 + offset, this.getXFIndex());
        LittleEndian.putShort(data, 12 + offset, this.getOptions());
        LittleEndian.putShort(data, 14 + offset, (short)0);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 16;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[COLINFO]\n");
        buffer.append("colfirst       = ").append(this.getFirstColumn()).append("\n");
        buffer.append("collast        = ").append(this.getLastColumn()).append("\n");
        buffer.append("colwidth       = ").append(this.getColumnWidth()).append("\n");
        buffer.append("xfindex        = ").append(this.getXFIndex()).append("\n");
        buffer.append("options        = ").append(this.getOptions()).append("\n");
        buffer.append("  hidden       = ").append(this.getHidden()).append("\n");
        buffer.append("  olevel       = ").append(this.getOutlineLevel()).append("\n");
        buffer.append("  collapsed    = ").append(this.getCollapsed()).append("\n");
        buffer.append("[/COLINFO]\n");
        return buffer.toString();
    }

    public Object clone() {
        ColumnInfoRecord rec = new ColumnInfoRecord();
        rec.field_1_first_col = this.field_1_first_col;
        rec.field_2_last_col = this.field_2_last_col;
        rec.field_3_col_width = this.field_3_col_width;
        rec.field_4_xf_index = this.field_4_xf_index;
        rec.field_5_options = this.field_5_options;
        rec.field_6_reserved = this.field_6_reserved;
        return rec;
    }
}

