/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FieldDocSortedHitQueue;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.MultiSearcherThread;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;

public class ParallelMultiSearcher
extends MultiSearcher {
    private Searchable[] searchables;
    private int[] starts;

    public ParallelMultiSearcher(Searchable[] searchables) throws IOException {
        super(searchables);
        this.searchables = searchables;
        this.starts = this.getStarts();
    }

    public int docFreq(Term term) throws IOException {
        return super.docFreq(term);
    }

    public TopDocs search(Weight weight, Filter filter, int nDocs) throws IOException {
        HitQueue hq = new HitQueue(nDocs);
        int totalHits = 0;
        MultiSearcherThread[] msta = new MultiSearcherThread[this.searchables.length];
        int i = 0;
        while (i < this.searchables.length) {
            msta[i] = new MultiSearcherThread(this.searchables[i], weight, filter, nDocs, hq, i, this.starts, "MultiSearcher thread #" + (i + 1));
            msta[i].start();
            ++i;
        }
        i = 0;
        while (i < this.searchables.length) {
            try {
                msta[i].join();
            }
            catch (InterruptedException interruptedException) {}
            IOException ioe = msta[i].getIOException();
            if (ioe == null) {
                totalHits += msta[i].hits();
            } else {
                throw ioe;
            }
            ++i;
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        int i2 = hq.size() - 1;
        while (i2 >= 0) {
            scoreDocs[i2] = (ScoreDoc)hq.pop();
            --i2;
        }
        float maxScore = totalHits == 0 ? Float.NEGATIVE_INFINITY : scoreDocs[0].score;
        return new TopDocs(totalHits, scoreDocs, maxScore);
    }

    public TopFieldDocs search(Weight weight, Filter filter, int nDocs, Sort sort) throws IOException {
        FieldDocSortedHitQueue hq = new FieldDocSortedHitQueue(null, nDocs);
        int totalHits = 0;
        MultiSearcherThread[] msta = new MultiSearcherThread[this.searchables.length];
        int i = 0;
        while (i < this.searchables.length) {
            msta[i] = new MultiSearcherThread(this.searchables[i], weight, filter, nDocs, hq, sort, i, this.starts, "MultiSearcher thread #" + (i + 1));
            msta[i].start();
            ++i;
        }
        float maxScore = Float.NEGATIVE_INFINITY;
        int i2 = 0;
        while (i2 < this.searchables.length) {
            try {
                msta[i2].join();
            }
            catch (InterruptedException interruptedException) {}
            IOException ioe = msta[i2].getIOException();
            if (ioe == null) {
                totalHits += msta[i2].hits();
            } else {
                throw ioe;
            }
            maxScore = Math.max(maxScore, msta[i2].getMaxScore());
            ++i2;
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        int i3 = hq.size() - 1;
        while (i3 >= 0) {
            scoreDocs[i3] = (ScoreDoc)hq.pop();
            --i3;
        }
        return new TopFieldDocs(totalHits, scoreDocs, hq.getFields(), maxScore);
    }

    public void search(Weight weight, Filter filter, final HitCollector results) throws IOException {
        int i = 0;
        while (i < this.searchables.length) {
            final int start = this.starts[i];
            this.searchables[i].search(weight, filter, new HitCollector(){

                public void collect(int doc, float score) {
                    results.collect(doc + start, score);
                }
            });
            ++i;
        }
    }

    public Query rewrite(Query original) throws IOException {
        return super.rewrite(original);
    }
}

