/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSIndexInput;
import org.apache.lucene.store.FSIndexOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;

public class FSDirectory
extends Directory {
    private static final Hashtable DIRECTORIES = new Hashtable();
    private static boolean disableLocks = false;
    public static final String LOCK_DIR = System.getProperty("org.apache.lucene.lockDir", System.getProperty("java.io.tmpdir"));
    private static Class IMPL;
    private static MessageDigest DIGESTER;
    private byte[] buffer = null;
    private File directory = null;
    private int refCount;
    private File lockDir;
    private static final char[] HEX_DIGITS;
    static /* synthetic */ Class class$0;

    static {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.lucene.store.FSDirectory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String name = System.getProperty("org.apache.lucene.FSDirectory.class", clazz.getName());
            IMPL = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot load FSDirectory class: " + e.toString());
        }
        catch (SecurityException securityException) {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.apache.lucene.store.FSDirectory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IMPL = Class.forName(clazz.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("cannot load default FSDirectory class: " + e.toString());
            }
        }
        try {
            DIGESTER = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.toString());
        }
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    public static void setDisableLocks(boolean doDisableLocks) {
        disableLocks = doDisableLocks;
    }

    public static boolean getDisableLocks() {
        return disableLocks;
    }

    public static FSDirectory getDirectory(String path, boolean create) throws IOException {
        return FSDirectory.getDirectory(new File(path), create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSDirectory getDirectory(File file, boolean create) throws IOException {
        FSDirectory dir;
        file = new File(file.getCanonicalPath());
        Object object = DIRECTORIES;
        synchronized (object) {
            dir = (FSDirectory)DIRECTORIES.get(file);
            if (dir == null) {
                try {
                    dir = (FSDirectory)IMPL.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("cannot load FSDirectory class: " + e.toString());
                }
                dir.init(file, create);
                DIRECTORIES.put(file, dir);
            } else if (create) {
                dir.create();
            }
        }
        object = dir;
        synchronized (object) {
            ++dir.refCount;
        }
        return dir;
    }

    protected FSDirectory() {
    }

    private void init(File path, boolean create) throws IOException {
        this.directory = path;
        this.lockDir = LOCK_DIR == null ? this.directory : new File(LOCK_DIR);
        if (!this.lockDir.exists()) {
            if (!this.lockDir.mkdirs()) {
                throw new IOException("Cannot create directory: " + this.lockDir);
            }
        } else if (!this.lockDir.isDirectory()) {
            throw new IOException("Found regular file where directory expected: " + this.lockDir);
        }
        if (create) {
            this.create();
        }
        if (!this.directory.isDirectory()) {
            throw new IOException(path + " not a directory");
        }
    }

    private synchronized void create() throws IOException {
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new IOException("Cannot create directory: " + this.directory);
        }
        if (!this.directory.isDirectory()) {
            throw new IOException(this.directory + " not a directory");
        }
        String[] files = this.directory.list(new IndexFileNameFilter());
        int i = 0;
        while (i < files.length) {
            File file = new File(this.directory, files[i]);
            if (!file.delete()) {
                throw new IOException("Cannot delete " + files[i]);
            }
            ++i;
        }
        String lockPrefix = this.getLockPrefix().toString();
        files = this.lockDir.list();
        if (files == null) {
            throw new IOException("Cannot read lock directory " + this.lockDir.getAbsolutePath());
        }
        int i2 = 0;
        while (i2 < files.length) {
            File lockFile;
            if (files[i2].startsWith(lockPrefix) && !(lockFile = new File(this.lockDir, files[i2])).delete()) {
                throw new IOException("Cannot delete " + files[i2]);
            }
            ++i2;
        }
    }

    public String[] list() {
        return this.directory.list();
    }

    public boolean fileExists(String name) {
        File file = new File(this.directory, name);
        return file.exists();
    }

    public long fileModified(String name) {
        File file = new File(this.directory, name);
        return file.lastModified();
    }

    public static long fileModified(File directory, String name) {
        File file = new File(directory, name);
        return file.lastModified();
    }

    public void touchFile(String name) {
        File file = new File(this.directory, name);
        file.setLastModified(System.currentTimeMillis());
    }

    public long fileLength(String name) {
        File file = new File(this.directory, name);
        return file.length();
    }

    public void deleteFile(String name) throws IOException {
        File file = new File(this.directory, name);
        if (!file.delete()) {
            throw new IOException("Cannot delete " + file);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void renameFile(String from, String to) throws IOException {
        FileOutputStream out;
        block16: {
            File old = new File(this.directory, from);
            File nu = new File(this.directory, to);
            if (nu.exists() && !nu.delete()) {
                throw new IOException("Cannot delete " + nu);
            }
            if (old.renameTo(nu)) return;
            FileInputStream in = null;
            out = null;
            try {
                try {
                    in = new FileInputStream(old);
                    out = new FileOutputStream(nu);
                    if (this.buffer == null) {
                        this.buffer = new byte[1024];
                    }
                    while (true) {
                        int len;
                        block17: {
                            if ((len = ((InputStream)in).read(this.buffer)) >= 0) break block17;
                            old.delete();
                            break;
                        }
                        ((OutputStream)out).write(this.buffer, 0, len);
                    }
                }
                catch (IOException iOException) {
                    throw new IOException("Cannot rename " + old + " to " + nu);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Cannot close input stream: " + e.toString());
                    }
                }
                if (out == null) throw throwable;
                try {
                    ((OutputStream)out).close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot close output stream: " + e.toString());
                }
            }
            {
                Object var8_10 = null;
                if (in == null) break block16;
            }
            try {}
            catch (IOException e) {
                throw new RuntimeException("Cannot close input stream: " + e.toString());
            }
            ((InputStream)in).close();
        }
        if (out == null) return;
        try {}
        catch (IOException e) {
            throw new RuntimeException("Cannot close output stream: " + e.toString());
        }
        ((OutputStream)out).close();
    }

    public IndexOutput createOutput(String name) throws IOException {
        File file = new File(this.directory, name);
        if (file.exists() && !file.delete()) {
            throw new IOException("Cannot overwrite: " + file);
        }
        return new FSIndexOutput(file);
    }

    public IndexInput openInput(String name) throws IOException {
        return new FSIndexInput(new File(this.directory, name));
    }

    public Lock makeLock(String name) {
        StringBuffer buf = this.getLockPrefix();
        buf.append("-");
        buf.append(name);
        final File lockFile = new File(this.lockDir, buf.toString());
        return new Lock(){

            public boolean obtain() throws IOException {
                if (disableLocks) {
                    return true;
                }
                if (!FSDirectory.this.lockDir.exists() && !FSDirectory.this.lockDir.mkdirs()) {
                    throw new IOException("Cannot create lock directory: " + FSDirectory.this.lockDir);
                }
                return lockFile.createNewFile();
            }

            public void release() {
                if (disableLocks) {
                    return;
                }
                lockFile.delete();
            }

            public boolean isLocked() {
                if (disableLocks) {
                    return false;
                }
                return lockFile.exists();
            }

            public String toString() {
                return "Lock@" + lockFile;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getLockPrefix() {
        byte[] digest;
        String dirName;
        try {
            dirName = this.directory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        MessageDigest messageDigest = DIGESTER;
        synchronized (messageDigest) {
            digest = DIGESTER.digest(dirName.getBytes());
        }
        StringBuffer buf = new StringBuffer();
        buf.append("lucene-");
        int i = 0;
        while (i < digest.length) {
            byte b = digest[i];
            buf.append(HEX_DIGITS[b >> 4 & 0xF]);
            buf.append(HEX_DIGITS[b & 0xF]);
            ++i;
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (--this.refCount <= 0) {
            Hashtable hashtable = DIRECTORIES;
            synchronized (hashtable) {
                DIRECTORIES.remove(this.directory);
            }
        }
    }

    public File getFile() {
        return this.directory;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "@" + this.directory;
    }
}

