/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.CharStream;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.QueryParserTokenManager;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;

public class MultiFieldQueryParser
extends QueryParser {
    private String[] fields;
    public static final int NORMAL_FIELD = 0;
    public static final int REQUIRED_FIELD = 1;
    public static final int PROHIBITED_FIELD = 2;

    public MultiFieldQueryParser(String[] fields, Analyzer analyzer) {
        super(null, analyzer);
        this.fields = fields;
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        if (field == null) {
            Vector<BooleanClause> clauses = new Vector<BooleanClause>();
            int i = 0;
            while (i < this.fields.length) {
                Query q = super.getFieldQuery(this.fields[i], queryText);
                if (q != null) {
                    if (q instanceof PhraseQuery) {
                        ((PhraseQuery)q).setSlop(slop);
                    }
                    if (q instanceof MultiPhraseQuery) {
                        ((MultiPhraseQuery)q).setSlop(slop);
                    }
                    clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
                }
                ++i;
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getFieldQuery(field, queryText);
    }

    protected Query getFieldQuery(String field, String queryText) throws ParseException {
        return this.getFieldQuery(field, queryText, 0);
    }

    protected Query getFieldQuery(String field, Analyzer analyzer, String queryText) throws ParseException {
        return this.getFieldQuery(field, queryText);
    }

    protected Query getFuzzyQuery(String field, String termStr) throws ParseException {
        return this.getFuzzyQuery(field, termStr, this.fuzzyMinSim);
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        if (field == null) {
            Vector<BooleanClause> clauses = new Vector<BooleanClause>();
            int i = 0;
            while (i < this.fields.length) {
                clauses.add(new BooleanClause(super.getFuzzyQuery(this.fields[i], termStr, minSimilarity), BooleanClause.Occur.SHOULD));
                ++i;
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getFuzzyQuery(field, termStr, minSimilarity);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            Vector<BooleanClause> clauses = new Vector<BooleanClause>();
            int i = 0;
            while (i < this.fields.length) {
                clauses.add(new BooleanClause(super.getPrefixQuery(this.fields[i], termStr), BooleanClause.Occur.SHOULD));
                ++i;
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getPrefixQuery(field, termStr);
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            Vector<BooleanClause> clauses = new Vector<BooleanClause>();
            int i = 0;
            while (i < this.fields.length) {
                clauses.add(new BooleanClause(super.getWildcardQuery(this.fields[i], termStr), BooleanClause.Occur.SHOULD));
                ++i;
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getWildcardQuery(field, termStr);
    }

    protected Query getRangeQuery(String field, Analyzer analyzer, String part1, String part2, boolean inclusive) throws ParseException {
        return this.getRangeQuery(field, part1, part2, inclusive);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        if (field == null) {
            Vector<BooleanClause> clauses = new Vector<BooleanClause>();
            int i = 0;
            while (i < this.fields.length) {
                clauses.add(new BooleanClause(super.getRangeQuery(this.fields[i], part1, part2, inclusive), BooleanClause.Occur.SHOULD));
                ++i;
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getRangeQuery(field, part1, part2, inclusive);
    }

    public MultiFieldQueryParser(QueryParserTokenManager tm) {
        super(tm);
    }

    public MultiFieldQueryParser(CharStream stream) {
        super(stream);
    }

    public MultiFieldQueryParser(String f, Analyzer a) {
        super(f, a);
    }

    public static Query parse(String query, String[] fields, Analyzer analyzer) throws ParseException {
        BooleanQuery bQuery = new BooleanQuery();
        int i = 0;
        while (i < fields.length) {
            Query q = MultiFieldQueryParser.parse(query, fields[i], analyzer);
            bQuery.add(q, BooleanClause.Occur.SHOULD);
            ++i;
        }
        return bQuery;
    }

    public static Query parse(String[] queries, String[] fields, Analyzer analyzer) throws ParseException {
        if (queries.length != fields.length) {
            throw new IllegalArgumentException("queries.length != fields.length");
        }
        BooleanQuery bQuery = new BooleanQuery();
        int i = 0;
        while (i < fields.length) {
            QueryParser qp = new QueryParser(fields[i], analyzer);
            Query q = qp.parse(queries[i]);
            bQuery.add(q, BooleanClause.Occur.SHOULD);
            ++i;
        }
        return bQuery;
    }

    public static Query parse(String query, String[] fields, int[] flags, Analyzer analyzer) throws ParseException {
        if (fields.length != flags.length) {
            throw new IllegalArgumentException("fields.length != flags.length");
        }
        BooleanQuery bQuery = new BooleanQuery();
        int i = 0;
        while (i < fields.length) {
            QueryParser qp = new QueryParser(fields[i], analyzer);
            Query q = qp.parse(query);
            int flag = flags[i];
            switch (flag) {
                case 1: {
                    bQuery.add(q, BooleanClause.Occur.MUST);
                    break;
                }
                case 2: {
                    bQuery.add(q, BooleanClause.Occur.MUST_NOT);
                    break;
                }
                default: {
                    bQuery.add(q, BooleanClause.Occur.SHOULD);
                }
            }
            ++i;
        }
        return bQuery;
    }

    public static Query parse(String query, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        if (fields.length != flags.length) {
            throw new IllegalArgumentException("fields.length != flags.length");
        }
        BooleanQuery bQuery = new BooleanQuery();
        int i = 0;
        while (i < fields.length) {
            QueryParser qp = new QueryParser(fields[i], analyzer);
            Query q = qp.parse(query);
            bQuery.add(q, flags[i]);
            ++i;
        }
        return bQuery;
    }

    public static Query parse(String[] queries, String[] fields, int[] flags, Analyzer analyzer) throws ParseException {
        if (queries.length != fields.length || queries.length != flags.length) {
            throw new IllegalArgumentException("queries, fields, and flags array have have different length");
        }
        BooleanQuery bQuery = new BooleanQuery();
        int i = 0;
        while (i < fields.length) {
            QueryParser qp = new QueryParser(fields[i], analyzer);
            Query q = qp.parse(queries[i]);
            int flag = flags[i];
            switch (flag) {
                case 1: {
                    bQuery.add(q, BooleanClause.Occur.MUST);
                    break;
                }
                case 2: {
                    bQuery.add(q, BooleanClause.Occur.MUST_NOT);
                    break;
                }
                default: {
                    bQuery.add(q, BooleanClause.Occur.SHOULD);
                }
            }
            ++i;
        }
        return bQuery;
    }

    public static Query parse(String[] queries, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        if (queries.length != fields.length || queries.length != flags.length) {
            throw new IllegalArgumentException("queries, fields, and flags array have have different length");
        }
        BooleanQuery bQuery = new BooleanQuery();
        int i = 0;
        while (i < fields.length) {
            QueryParser qp = new QueryParser(fields[i], analyzer);
            Query q = qp.parse(queries[i]);
            bQuery.add(q, flags[i]);
            ++i;
        }
        return bQuery;
    }
}

