/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.PriorityQueue;

public class TopDocCollector
extends HitCollector {
    private int numHits;
    private float minScore = 0.0f;
    int totalHits;
    PriorityQueue hq;

    public TopDocCollector(int numHits) {
        this(numHits, new HitQueue(numHits));
    }

    TopDocCollector(int numHits, PriorityQueue hq) {
        this.numHits = numHits;
        this.hq = hq;
    }

    public void collect(int doc, float score) {
        if (score > 0.0f) {
            ++this.totalHits;
            if (this.hq.size() < this.numHits || score >= this.minScore) {
                this.hq.insert(new ScoreDoc(doc, score));
                this.minScore = ((ScoreDoc)this.hq.top()).score;
            }
        }
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public TopDocs topDocs() {
        ScoreDoc[] scoreDocs = new ScoreDoc[this.hq.size()];
        int i = this.hq.size() - 1;
        while (i >= 0) {
            scoreDocs[i] = (ScoreDoc)this.hq.pop();
            --i;
        }
        float maxScore = this.totalHits == 0 ? Float.NEGATIVE_INFINITY : scoreDocs[0].score;
        return new TopDocs(this.totalHits, scoreDocs, maxScore);
    }
}

