/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfListItem;
import com.lowagie.text.rtf.list.RtfListTable;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfFontList;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] LIST_LEVEL = "\\listlevel".getBytes();
    private static final byte[] LIST_LEVEL_TYPE = "\\levelnfc".getBytes();
    private static final byte[] LIST_LEVEL_TYPE_NEW = "\\levelnfcn".getBytes();
    private static final byte[] LIST_LEVEL_ALIGNMENT = "\\leveljc".getBytes();
    private static final byte[] LIST_LEVEL_ALIGNMENT_NEW = "\\leveljcn".getBytes();
    private static final byte[] LIST_LEVEL_START_AT = "\\levelstartat".getBytes();
    private static final byte[] LIST_LEVEL_TEXT = "\\leveltext".getBytes();
    private static final byte[] LIST_LEVEL_STYLE_NUMBERED_BEGIN = "\\'02\\'".getBytes();
    private static final byte[] LIST_LEVEL_STYLE_NUMBERED_END = ".;".getBytes();
    private static final byte[] LIST_LEVEL_STYLE_BULLETED = "\\'01\\u-3913 ?;".getBytes();
    private static final byte[] LIST_LEVEL_NUMBERS_BEGIN = "\\levelnumbers".getBytes();
    private static final byte[] LIST_LEVEL_NUMBERS_NUMBERED = "\\'01".getBytes();
    private static final byte[] LIST_LEVEL_NUMBERS_END = ";".getBytes();
    private static final byte[] LIST_LEVEL_FIRST_INDENT = "\\fi".getBytes();
    private static final byte[] LIST_LEVEL_SYMBOL_INDENT = "\\tx".getBytes();
    private static final byte[] LIST_LEVEL_NUMBER = "\\ilvl".getBytes();
    private static final byte[] TAB = "\\tab".getBytes();
    private static final byte[] LIST_TEXT = "\\listtext".getBytes();
    private static final byte[] LIST_NUMBER_END = ".".getBytes();
    private static final byte[] LIST_BULLET = "\\'b7".getBytes();
    private ArrayList items;
    private int listLevel = 0;
    private int firstIndent = 0;
    private int leftIndent = 0;
    private int rightIndent = 0;
    private int symbolIndent = 0;
    private int listNumber = this.document.getDocumentHeader().getListNumber(this);
    private boolean numbered = true;
    private RtfFont fontNumber;
    private RtfFont fontBullet;

    public RtfList(RtfDocument rtfDocument, List list) {
        super(rtfDocument);
        this.items = new ArrayList();
        this.firstIndent = (int)((double)(list.symbolIndent() - list.indentationLeft()) * 20.0 * -1.0);
        this.leftIndent = (int)((double)(list.indentationLeft() + list.symbolIndent()) * 20.0);
        this.rightIndent = (int)((double)list.indentationRight() * 20.0);
        this.symbolIndent = (int)((double)list.symbolIndent() * 20.0);
        this.numbered = list.isNumbered();
        int n = 0;
        while (n < list.getItems().size()) {
            try {
                RtfBasicElement rtfBasicElement;
                Element element = (Element)list.getItems().get(n);
                if (element.type() == 10) {
                    element = new ListItem((Chunk)element);
                }
                if ((rtfBasicElement = rtfDocument.getMapper().mapElement(element)) instanceof RtfList) {
                    ((RtfList)rtfBasicElement).setListNumber(this.listNumber);
                    ((RtfList)rtfBasicElement).setListLevel(this.listLevel + 1);
                }
                this.items.add(rtfBasicElement);
            }
            catch (DocumentException documentException) {
                documentException.printStackTrace();
            }
            ++n;
        }
        this.fontNumber = new RtfFont(this.document, new Font(2, 10.0f, 0, new Color(0, 0, 0)), 0.0f);
        this.fontBullet = new RtfFont(this.document, new Font(3, 10.0f, 0, new Color(0, 0, 0)), 0.0f);
    }

    private byte[] writeIndentations() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(LIST_LEVEL_FIRST_INDENT);
            byteArrayOutputStream.write(this.intToByteArray(this.firstIndent));
            byteArrayOutputStream.write(RtfParagraph.INDENT_LEFT);
            byteArrayOutputStream.write(this.intToByteArray(this.leftIndent));
            byteArrayOutputStream.write(RtfParagraph.INDENT_RIGHT);
            byteArrayOutputStream.write(this.intToByteArray(this.rightIndent));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(OPEN_GROUP);
            byteArrayOutputStream.write(LIST_LEVEL);
            byteArrayOutputStream.write(LIST_LEVEL_TYPE);
            if (this.numbered) {
                byteArrayOutputStream.write(this.intToByteArray(0));
            } else {
                byteArrayOutputStream.write(this.intToByteArray(23));
            }
            byteArrayOutputStream.write(LIST_LEVEL_TYPE_NEW);
            if (this.numbered) {
                byteArrayOutputStream.write(this.intToByteArray(0));
            } else {
                byteArrayOutputStream.write(this.intToByteArray(23));
            }
            byteArrayOutputStream.write(LIST_LEVEL_ALIGNMENT);
            byteArrayOutputStream.write(this.intToByteArray(0));
            byteArrayOutputStream.write(LIST_LEVEL_ALIGNMENT_NEW);
            byteArrayOutputStream.write(this.intToByteArray(0));
            byteArrayOutputStream.write(LIST_LEVEL_START_AT);
            byteArrayOutputStream.write(this.intToByteArray(1));
            byteArrayOutputStream.write(OPEN_GROUP);
            byteArrayOutputStream.write(LIST_LEVEL_TEXT);
            if (this.numbered) {
                byteArrayOutputStream.write(LIST_LEVEL_STYLE_NUMBERED_BEGIN);
                if (this.listLevel < 10) {
                    byteArrayOutputStream.write(this.intToByteArray(0));
                }
                byteArrayOutputStream.write(this.intToByteArray(this.listLevel));
                byteArrayOutputStream.write(LIST_LEVEL_STYLE_NUMBERED_END);
            } else {
                byteArrayOutputStream.write(LIST_LEVEL_STYLE_BULLETED);
            }
            byteArrayOutputStream.write(CLOSE_GROUP);
            byteArrayOutputStream.write(OPEN_GROUP);
            byteArrayOutputStream.write(LIST_LEVEL_NUMBERS_BEGIN);
            if (this.numbered) {
                byteArrayOutputStream.write(LIST_LEVEL_NUMBERS_NUMBERED);
            }
            byteArrayOutputStream.write(LIST_LEVEL_NUMBERS_END);
            byteArrayOutputStream.write(CLOSE_GROUP);
            byteArrayOutputStream.write(RtfFontList.FONT_NUMBER);
            if (this.numbered) {
                byteArrayOutputStream.write(this.intToByteArray(this.fontNumber.getFontNumber()));
            } else {
                byteArrayOutputStream.write(this.intToByteArray(this.fontBullet.getFontNumber()));
            }
            byteArrayOutputStream.write(this.writeIndentations());
            byteArrayOutputStream.write(LIST_LEVEL_SYMBOL_INDENT);
            byteArrayOutputStream.write(this.intToByteArray(this.symbolIndent));
            byteArrayOutputStream.write(CLOSE_GROUP);
            byteArrayOutputStream.write("\n".getBytes());
            int n = 0;
            while (n < this.items.size()) {
                RtfElement rtfElement = (RtfElement)this.items.get(n);
                if (rtfElement instanceof RtfList) {
                    byteArrayOutputStream.write(((RtfList)rtfElement).writeDefinition());
                    break;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] writeListBeginning() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
            byteArrayOutputStream.write(RtfParagraph.ALIGN_LEFT);
            byteArrayOutputStream.write(this.writeIndentations());
            byteArrayOutputStream.write(RtfFont.FONT_SIZE);
            byteArrayOutputStream.write(this.intToByteArray(this.fontNumber.getFontSize() * 2));
            byteArrayOutputStream.write(RtfListTable.LIST_NUMBER);
            byteArrayOutputStream.write(this.intToByteArray(this.listNumber));
            if (this.listLevel > 0) {
                byteArrayOutputStream.write(LIST_LEVEL_NUMBER);
                byteArrayOutputStream.write(this.intToByteArray(this.listLevel));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this.writeListBeginning());
            byteArrayOutputStream.write(OPEN_GROUP);
            int n = 0;
            int n2 = 0;
            while (n2 < this.items.size()) {
                RtfElement rtfElement = (RtfElement)this.items.get(n2);
                if (rtfElement instanceof RtfListItem) {
                    ++n;
                    byteArrayOutputStream.write(OPEN_GROUP);
                    byteArrayOutputStream.write(LIST_TEXT);
                    byteArrayOutputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
                    byteArrayOutputStream.write(RtfFontList.FONT_NUMBER);
                    if (this.numbered) {
                        byteArrayOutputStream.write(this.intToByteArray(this.fontNumber.getFontNumber()));
                    } else {
                        byteArrayOutputStream.write(this.intToByteArray(this.fontBullet.getFontNumber()));
                    }
                    byteArrayOutputStream.write(this.writeIndentations());
                    byteArrayOutputStream.write(DELIMITER);
                    if (this.numbered) {
                        byteArrayOutputStream.write(this.intToByteArray(n));
                        byteArrayOutputStream.write(LIST_NUMBER_END);
                    } else {
                        byteArrayOutputStream.write(LIST_BULLET);
                    }
                    byteArrayOutputStream.write(TAB);
                    byteArrayOutputStream.write(CLOSE_GROUP);
                    byteArrayOutputStream.write(rtfElement.write());
                    byteArrayOutputStream.write("\n".getBytes());
                } else if (rtfElement instanceof RtfList) {
                    byteArrayOutputStream.write(rtfElement.write());
                    byteArrayOutputStream.write(this.writeListBeginning());
                    byteArrayOutputStream.write("\n".getBytes());
                }
                ++n2;
            }
            byteArrayOutputStream.write(CLOSE_GROUP);
            byteArrayOutputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int getListLevel() {
        return this.listLevel;
    }

    public void setListLevel(int n) {
        this.listLevel = n;
        if (this.listLevel != 0) {
            this.document.getDocumentHeader().freeListNumber(this);
        } else {
            this.listNumber = this.document.getDocumentHeader().getListNumber(this);
        }
    }

    public int getListNumber() {
        return this.listNumber;
    }

    public void setListNumber(int n) {
        this.listNumber = n;
    }

    public void setInTable(boolean bl) {
        super.setInTable(bl);
        int n = 0;
        while (n < this.items.size()) {
            ((RtfBasicElement)this.items.get(n)).setInTable(bl);
            ++n;
        }
    }

    public void setInHeader(boolean bl) {
        super.setInHeader(bl);
        int n = 0;
        while (n < this.items.size()) {
            ((RtfBasicElement)this.items.get(n)).setInHeader(bl);
            ++n;
        }
    }
}

