/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.odi.IResultObject;

class DataFileReader {
    private File file;
    private boolean isOpen;
    private FileInputStream fis;
    private BufferedInputStream bis;
    private ResultObjectUtil resultObjectUtil;

    static DataFileReader newInstance(File file, ResultObjectUtil resultObjectUtil) {
        return new DataFileReader(file, resultObjectUtil);
    }

    private DataFileReader(File file, ResultObjectUtil resultObjectUtil) {
        this.resultObjectUtil = resultObjectUtil;
        this.setReadFile(file);
    }

    void setReadFile(File file) {
        if (this.isOpen) {
            this.close();
        }
        this.file = file;
        this.isOpen = false;
    }

    IResultObject[] read(int length) throws IOException {
        if (!this.isOpen) {
            try {
                this.fis = new FileInputStream(this.file);
            }
            catch (FileNotFoundException fileNotFoundException) {}
            this.bis = new BufferedInputStream(this.fis);
            this.isOpen = true;
        }
        return this.resultObjectUtil.readData(this.bis, length);
    }

    void close() {
        if (this.isOpen) {
            try {
                this.bis.close();
                this.fis.close();
                this.isOpen = false;
            }
            catch (IOException iOException) {}
        }
    }
}

