/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.pass;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.aggregation.AggregationFactory;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.aggregation.AggrDefnManager;
import org.eclipse.birt.data.engine.executor.aggregation.AggrInfo;
import org.eclipse.birt.data.engine.executor.aggregation.AggregationHelper;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.pass.AggrComputedColumnHelper;
import org.eclipse.birt.data.engine.executor.transform.pass.ComputedColumnCalculator;
import org.eclipse.birt.data.engine.executor.transform.pass.ComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.pass.PassStatusController;
import org.eclipse.birt.data.engine.executor.transform.pass.PassUtil;
import org.eclipse.birt.data.engine.executor.transform.pass.RowProcessUtil;
import org.eclipse.birt.data.engine.expression.ExpressionCompiler;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.FilterByRow;
import org.mozilla.javascript.Context;

class DataSetProcessUtil
extends RowProcessUtil {
    private DataSetProcessUtil(ResultSetPopulator populator, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, FilterByRow filterByRow, PassStatusController psController, DataEngineSession session) {
        super(populator, iccState, computedColumnHelper, filterByRow, psController, session);
    }

    public static void doPopulate(ResultSetPopulator populator, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, FilterByRow filterByRow, PassStatusController psController, DataEngineSession session) throws DataException {
        DataSetProcessUtil instance = new DataSetProcessUtil(populator, iccState, computedColumnHelper, filterByRow, psController, session);
        instance.populateDataSet();
    }

    private void populateDataSet() throws DataException {
        boolean changeMaxRows;
        int originalMaxRows = this.populator.getQuery().getMaxRows();
        boolean bl = this.filterByRow == null ? false : (changeMaxRows = this.filterByRow.getFilterList(2).size() + this.filterByRow.getFilterList(5).size() > 0);
        if (changeMaxRows) {
            this.populator.getQuery().setMaxRows(0);
        }
        if (this.computedColumnHelper != null) {
            this.computedColumnHelper.setModel(4);
        }
        this.doDataSetFilter(changeMaxRows);
        List aggCCList = this.prepareComputedColumns(0);
        this.populateAggrCCs(this.getAggrComputedColumns(aggCCList, true));
        this.removeAvailableComputedColumns();
        this.populateComputedColumns(this.getAggrComputedColumns(aggCCList, false));
        this.populator.getQuery().setMaxRows(originalMaxRows);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void populateAggrCCs(List aggrComputedColumns) throws DataException {
        if (aggrComputedColumns.size() == 0) {
            return;
        }
        ExpressionCompiler compiler = new ExpressionCompiler();
        compiler.setDataSetMode(true);
        try {
            Context cx = Context.enter();
            ArrayList<AggrInfo> aggrInfos = new ArrayList<AggrInfo>();
            ArrayList<String> aggrNames = new ArrayList<String>();
            int i = 0;
            block3: while (true) {
                block13: {
                    if (i < aggrComputedColumns.size()) break block13;
                    if (!this.psController.needDoOperation(1)) {
                        PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), false, this.session);
                    }
                    AggregationHelper helper = new AggregationHelper(new AggrDefnManager(aggrInfos), this.populator);
                    AggrComputedColumnHelper ccHelper = new AggrComputedColumnHelper(helper, aggrNames);
                    this.populator.getQuery().getFetchEvents().add(0, ccHelper);
                    PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), false, this.session);
                    this.populator.getQuery().getFetchEvents().remove(0);
                    break;
                }
                ComputedColumn cc = (ComputedColumn)aggrComputedColumns.get(i);
                List args = cc.getAggregateArgument();
                IBaseExpression[] exprs = null;
                int offset = 0;
                if (cc.getExpression() != null) {
                    exprs = new IBaseExpression[args.size() + 1];
                    offset = 1;
                    exprs[0] = cc.getExpression();
                } else {
                    exprs = new IBaseExpression[args.size()];
                }
                int j = offset;
                while (true) {
                    if (j >= args.size() + offset) break;
                    exprs[j] = (IBaseExpression)args.get(j - offset);
                    ++j;
                }
                j = 0;
                while (true) {
                    IScriptExpression scriptExpr;
                    if (j >= exprs.length) {
                        if (cc.getAggregateFilter() != null) {
                            compiler.compile(cc.getAggregateFilter(), cx);
                        }
                        IAggregation aggrFunction = AggregationFactory.getInstance().getAggregation(cc.getAggregateFunction());
                        AggrInfo aggrInfo = new AggrInfo(cc.getName(), 0, aggrFunction, exprs, cc.getAggregateFilter());
                        aggrInfos.add(aggrInfo);
                        aggrNames.add(cc.getName());
                        ++i;
                        continue block3;
                    }
                    if (!(exprs[j] instanceof IScriptExpression) || (scriptExpr = (IScriptExpression)exprs[j]).getText() != null) {
                        compiler.compile(exprs[j], cx);
                    }
                    ++j;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            Context.exit();
            throw throwable;
        }
        {
            Object var13_17 = null;
        }
        Context.exit();
    }

    private void doDataSetFilter(boolean changeMaxRows) throws DataException {
        if (!this.psController.needDoOperation(1)) {
            return;
        }
        this.applyFilters(1, changeMaxRows);
    }

    private void populateComputedColumns(List aggCCList) throws DataException {
        if (!this.psController.needDoOperation(2)) {
            return;
        }
        if (!this.psController.needDoOperation(1)) {
            PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), false, this.session);
        }
        this.computedColumnHelper.getComputedColumnList().clear();
        this.computedColumnHelper.getComputedColumnList().addAll(aggCCList);
        this.computedColumnHelper.setModel(0);
        this.iccState.setModel(0);
        if (this.iccState.getCount() > 0) {
            ComputedColumnCalculator.populateComputedColumns(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), this.iccState, this.computedColumnHelper, this.session);
        }
        this.computedColumnHelper.setModel(4);
    }

    private void removeAvailableComputedColumns() {
        if (this.iccState != null) {
            int i = 0;
            while (i < this.iccState.getCount()) {
                if (this.iccState.isValueAvailable(i)) {
                    int k = 0;
                    while (k < this.populator.getQuery().getFetchEvents().size()) {
                        if (this.populator.getQuery().getFetchEvents().get(k) instanceof ComputedColumnHelper) {
                            ComputedColumnHelper helper = (ComputedColumnHelper)this.populator.getQuery().getFetchEvents().get(k);
                            helper.getComputedColumnList().remove(this.iccState.getComputedColumn(i));
                            break;
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
    }
}

