/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.impl.CacheResultIterator;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.IQueryService;
import org.eclipse.birt.data.engine.impl.IServiceForQueryResults;
import org.eclipse.birt.data.engine.impl.IServiceForResultSet;
import org.eclipse.birt.data.engine.impl.PreparedDummyQuery;
import org.eclipse.birt.data.engine.impl.ResultIterator;
import org.eclipse.birt.data.engine.impl.ResultIterator2;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.StreamWrapper;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.mozilla.javascript.Scriptable;

public class QueryResults
implements IQueryResults,
IQueryService {
    private IServiceForQueryResults queryService;
    private DataEngineContext context;
    private Scriptable queryScope;
    private int nestedLevel;
    private String rootQueryResultID;
    private String selfQueryResultID;
    private IResultIterator iterator;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.QueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.QueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    QueryResults(IServiceForQueryResults queryService) throws DataException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.QueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "QueryResults", queryService);
        if (!$assertionsDisabled && queryService == null) {
            throw new AssertionError();
        }
        this.queryService = queryService;
        this.context = queryService.getContext();
        this.queryScope = queryService.getScope();
        this.nestedLevel = queryService.getNestedLevel();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.QueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "QueryResults");
    }

    public String getID() {
        if (this.selfQueryResultID == null) {
            this.selfQueryResultID = QueryResultIDUtil.nextID();
        }
        return QueryResultIDUtil.buildID(this.rootQueryResultID, this.selfQueryResultID);
    }

    public IPreparedQuery getPreparedQuery() {
        return this.queryService.getPreparedQuery();
    }

    public IResultMetaData getResultMetaData() throws DataException {
        if (this.queryService == null) {
            throw new DataException("data.engine.ResultClosed");
        }
        return this.queryService.getResultMetaData();
    }

    public IResultIterator getResultIterator() throws DataException {
        Class<?> clazz;
        if (this.queryService == null) {
            throw new DataException("data.engine.ResultClosed");
        }
        try {
            if (this.iterator == null) {
                this.queryService.initAutoBinding();
                this.queryService.validateQuery();
                org.eclipse.birt.data.engine.odi.IResultIterator odiIterator = this.queryService.executeQuery();
                if (this.isDummyQuery(odiIterator)) {
                    this.iterator = new DummyResultIterator(new ResultService(this.context, this), odiIterator, this.queryScope);
                } else if (this.queryService.getQueryDefn().usesDetails()) {
                    if (this.queryService.getQueryDefn().cacheQueryResults()) {
                        new ResultIterator(new ResultService(this.context, this), odiIterator, this.queryScope).close();
                        this.iterator = new CacheResultIterator(this.context, this);
                    } else {
                        this.iterator = new ResultIterator(new ResultService(this.context, this), odiIterator, this.queryScope);
                    }
                } else if (this.queryService.getQueryDefn().cacheQueryResults()) {
                    new ResultIterator(new ResultService(this.context, this), odiIterator, this.queryScope).close();
                    this.iterator = new CacheResultIterator(this.context, this);
                } else {
                    this.iterator = new ResultIterator2(new ResultService(this.context, this), odiIterator, this.queryScope);
                }
            }
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.QueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "getResultIterator", "finished");
        return this.iterator;
    }

    private boolean isDummyQuery(org.eclipse.birt.data.engine.odi.IResultIterator odiIterator) throws DataException {
        return this.queryService.getQueryDefn() instanceof IQueryDefinition && ((IQueryDefinition)this.queryService.getQueryDefn()).getDataSetName() == null && odiIterator.getResultClass().getFieldCount() == 0;
    }

    public void close() throws BirtException {
        if (this.queryService == null) {
            return;
        }
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
        this.queryService.close();
        this.queryService = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.QueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "close", "QueryResults is closed");
    }

    void setID(String rootQueryResultID, String selfQueryResultID) {
        this.rootQueryResultID = rootQueryResultID;
        this.selfQueryResultID = selfQueryResultID;
    }

    void setID(String selfQueryResultID) {
        this.setID(null, selfQueryResultID);
    }

    int getGroupLevel() {
        return this.queryService.getGroupLevel();
    }

    public boolean isClosed() {
        return this.queryService == null;
    }

    public int getNestedLevel() {
        return this.nestedLevel;
    }

    public Scriptable getQueryScope() {
        return this.queryScope;
    }

    public IExecutorHelper getExecutorHelper() throws DataException {
        if (this.getResultIterator() instanceof ResultIterator) {
            return ((ResultIterator)this.getResultIterator()).getOdiResult().getExecutorHelper();
        }
        return null;
    }

    public DataSetRuntime[] getDataSetRuntime(int count) {
        return this.queryService.getDataSetRuntimes(count);
    }

    private class DummyOdiResultIterator
    extends CachedResultSet {
        private boolean isFirstRowFetched = false;
        private org.eclipse.birt.data.engine.odi.IResultIterator prototype = null;

        DummyOdiResultIterator(org.eclipse.birt.data.engine.odi.IResultIterator result) {
            this.prototype = result;
        }

        public void close() {
        }

        public void doSave(StreamWrapper streamsWrapper, boolean isSubQuery) throws DataException {
            try {
                if (streamsWrapper.getStreamForResultClass() != null) {
                    IOUtil.writeInt((OutputStream)streamsWrapper.getStreamForResultClass(), (int)0);
                    streamsWrapper.getStreamForResultClass().close();
                    if (streamsWrapper.getStreamForDataSet() != null) {
                        IOUtil.writeInt((OutputStream)streamsWrapper.getStreamForDataSet(), (int)0);
                        streamsWrapper.getStreamForDataSet().close();
                    }
                    if (streamsWrapper.getStreamForDataSetRowLens() != null) {
                        IOUtil.writeLong((DataOutputStream)streamsWrapper.getStreamForDataSetRowLens(), (long)0L);
                        streamsWrapper.getStreamForDataSetRowLens().close();
                    }
                }
                IOUtil.writeInt((OutputStream)streamsWrapper.getStreamForGroupInfo(), (int)0);
            }
            catch (IOException e) {
                throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Class");
            }
        }

        public void first(int groupingLevel) throws DataException {
            this.prototype.first(groupingLevel);
        }

        public int getCurrentGroupIndex(int groupLevel) throws DataException {
            return 0;
        }

        public IResultObject getCurrentResult() throws DataException {
            return this.prototype.getCurrentResult();
        }

        public int getCurrentResultIndex() throws DataException {
            return this.prototype.getCurrentResultIndex();
        }

        public int getEndingGroupLevel() throws DataException {
            return 0;
        }

        public IExecutorHelper getExecutorHelper() {
            return this.prototype.getExecutorHelper();
        }

        public int[] getGroupStartAndEndIndex(int groupLevel) throws DataException {
            return this.prototype.getGroupStartAndEndIndex(groupLevel);
        }

        public IResultClass getResultClass() throws DataException {
            return this.prototype.getResultClass();
        }

        public ResultSetCache getResultSetCache() {
            return this.prototype.getResultSetCache();
        }

        public int getRowCount() throws DataException {
            return 1;
        }

        public int getStartingGroupLevel() throws DataException {
            return 0;
        }

        public void last(int groupingLevel) throws DataException {
            this.prototype.last(groupingLevel);
        }

        public boolean next() throws DataException {
            if (!this.isFirstRowFetched) {
                this.isFirstRowFetched = true;
                return true;
            }
            return false;
        }
    }

    private class DummyResultIterator
    extends ResultIterator {
        DummyResultIterator(IServiceForResultSet rService, org.eclipse.birt.data.engine.odi.IResultIterator odiResult, Scriptable scope) throws DataException {
            super(rService, new DummyOdiResultIterator(odiResult), scope);
        }

        public boolean next() throws DataException {
            return this.getOdiResult().next();
        }

        public IResultIterator getSecondaryIterator(String subQueryName, Scriptable subScope) throws DataException {
            Collection subQueries = this.getQueryResults().getPreparedQuery().getReportQueryDefn().getSubqueries();
            Iterator subIt = subQueries.iterator();
            HashMap<String, ISubqueryDefinition> subQueryMap = new HashMap<String, ISubqueryDefinition>();
            while (subIt.hasNext()) {
                ISubqueryDefinition subquery = (ISubqueryDefinition)subIt.next();
                subQueryMap.put(subquery.getName(), subquery);
            }
            PreparedDummyQuery preparedQuery = new PreparedDummyQuery(QueryResults.this.context, (ISubqueryDefinition)subQueryMap.get(subQueryName), subScope);
            try {
                IQueryResults queryResults = preparedQuery.executeQuery(subScope, subScope);
                return queryResults.getResultIterator();
            }
            catch (BirtException e) {
                throw new DataException(e.getMessage());
            }
        }

        public void close() throws BirtException {
            super.close();
        }
    }

    private static class ResultService
    implements IServiceForResultSet {
        private DataEngineContext context;
        private QueryResults queryResults;

        public ResultService(DataEngineContext context, QueryResults queryResults) {
            this.context = context;
            this.queryResults = queryResults;
        }

        public DataEngineContext getContext() {
            return this.context;
        }

        public IQueryResults getQueryResults() {
            return this.queryResults;
        }

        public IBaseQueryDefinition getQueryDefn() {
            return this.queryResults.queryService.getQueryDefn();
        }

        public IQueryResults execSubquery(org.eclipse.birt.data.engine.odi.IResultIterator iterator, String subQueryName, Scriptable subScope) throws DataException {
            return this.queryResults.queryService.execSubquery(iterator, subQueryName, subScope);
        }

        public IBaseExpression getBindingExpr(String exprName) throws DataException {
            return this.queryResults.queryService.getBindingExpr(exprName);
        }

        public IScriptExpression getAutoBindingExpr(String exprName) {
            return this.queryResults.queryService.getAutoBindingExpr(exprName);
        }

        public List getAllBindingExprs() {
            return this.queryResults.queryService.getAllBindingExprs();
        }

        public Map getAllAutoBindingExprs() {
            return this.queryResults.queryService.getAllAutoBindingExprs();
        }
    }
}

