/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.aggregation;

import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.expression.AggregateExpression;
import org.eclipse.birt.data.engine.expression.AggregationConstantsUtil;
import org.eclipse.birt.data.engine.expression.BytecodeExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ConstantExpression;
import org.eclipse.birt.data.engine.impl.aggregation.AggrExprInfo;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateRegistry;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

final class AggrRegistry
implements AggregateRegistry {
    private int groupLevel;
    private boolean isDetailedRow;
    private int calculationLevel;
    private Context cx;
    private BaseQuery baseQuery;
    private List groupDefns;
    private int groupCount;
    private Scriptable scope;
    private int runStates;
    private List aggrExprInfoList;
    private static int PREPARED_QUERY;
    private static int BASE_QUERY;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.aggregation.AggrRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        PREPARED_QUERY = 1;
        BASE_QUERY = 2;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.aggregation.AggrRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    AggrRegistry(int groupLevel, int calculationLevel, boolean isDetailedRow, Context cx) throws DataException {
        Object[] params = new Object[]{new Integer(groupLevel), new Integer(calculationLevel), new Boolean(isDetailedRow), cx};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.aggregation.AggrRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "AggrRegistry", params);
        this.groupLevel = groupLevel;
        this.isDetailedRow = isDetailedRow;
        this.calculationLevel = calculationLevel;
        this.cx = cx;
        if (this.calculationLevel < this.groupLevel && this.calculationLevel > 0) {
            throw new DataException("data.engine.InvalidTotalFunc");
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.aggregation.AggrRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "AggrRegistry");
    }

    void prepare(List groupDefns, Scriptable scope, BaseQuery baseQuery, List aggrExprInfoList) {
        this.groupDefns = groupDefns;
        this.scope = scope;
        this.baseQuery = baseQuery;
        this.aggrExprInfoList = aggrExprInfoList;
        this.runStates = baseQuery == null ? PREPARED_QUERY : BASE_QUERY;
        if (groupDefns != null) {
            this.groupCount = groupDefns.size();
        }
    }

    public int register(AggregateExpression expr) throws DataException {
        return this.registerExpression(expr, this.groupLevel, this.calculationLevel, this.isDetailedRow, this.cx);
    }

    private int registerExpression(AggregateExpression expr, int groupLevel, int calculationLevel, boolean isDetailedRow, Context cx) throws DataException {
        AggrExprInfo info = this.newAggrExprInfo(expr, groupLevel, calculationLevel, isDetailedRow, cx);
        int id = 0;
        while (id < this.aggrExprInfoList.size()) {
            if (info.equals(this.aggrExprInfoList.get(id))) break;
            ++id;
        }
        if (id == this.aggrExprInfoList.size()) {
            this.aggrExprInfoList.add(info);
        }
        expr.setRegId(id);
        return id;
    }

    private AggrExprInfo newAggrExprInfo(AggregateExpression expr, int currentGroupLevel, int calculationLevel, boolean isDetailedRow, Context cx) throws DataException {
        int nArgs;
        int nFixedArgs;
        List exprArgs;
        AggrExprInfo aggr;
        block25: {
            block26: {
                aggr = new AggrExprInfo();
                if (!$assertionsDisabled && expr == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && currentGroupLevel < 0) {
                    throw new AssertionError();
                }
                aggr.aggregation = expr.getAggregation();
                aggr.calculateLevel = calculationLevel;
                exprArgs = expr.getArguments();
                nFixedArgs = aggr.aggregation.getParameterDefn().length;
                nArgs = exprArgs.size();
                if (nArgs < nFixedArgs || nArgs > nFixedArgs + 2) {
                    DataException e = new DataException("data.engine.WrongNumAggrArgs", aggr.aggregation.getName());
                    throw e;
                }
                aggr.groupLevel = currentGroupLevel;
                if (nArgs != nFixedArgs + 2) break block25;
                CompiledExpression groupExpr = (CompiledExpression)exprArgs.get(nArgs - 1);
                if (!(groupExpr instanceof ConstantExpression)) {
                    DataException e = new DataException("data.engine.InvalidAggrGroupExpression", aggr.aggregation.getName());
                    throw e;
                }
                Object groupLevelObj = groupExpr.evaluate(cx, (Scriptable)(this.runStates == BASE_QUERY ? cx.initStandardObjects() : this.scope));
                if (groupLevelObj != null) {
                    if (groupLevelObj instanceof String) {
                        int innerMostGroup = 0;
                        innerMostGroup = this.runStates == PREPARED_QUERY ? this.groupCount : (this.baseQuery.getGrouping() != null ? this.baseQuery.getGrouping().length : 0);
                        int groupLevel = AggregationConstantsUtil.getGroupLevel((String)groupLevelObj, currentGroupLevel, innerMostGroup, isDetailedRow);
                        aggr.groupLevel = groupLevel != -1 ? groupLevel : (this.runStates == BASE_QUERY ? this.getGroupIndex(groupLevelObj.toString()) : this.getGroupIndexFromPreparedQuery((String)groupLevelObj));
                    } else if (groupLevelObj instanceof Number) {
                        int offset = ((Number)groupLevelObj).intValue();
                        aggr.groupLevel = offset < 0 ? currentGroupLevel + offset : offset;
                    }
                }
                if (aggr.groupLevel < 0) break block26;
                if (aggr.groupLevel <= (this.runStates == BASE_QUERY ? (this.baseQuery.getGrouping() == null ? 0 : this.baseQuery.getGrouping().length) : this.groupCount)) break block25;
            }
            DataException e = new DataException("data.engine.InvalidGroupLevel", aggr.aggregation.getName());
            throw e;
        }
        if (nArgs > nFixedArgs) {
            aggr.filter = (CompiledExpression)exprArgs.get(nFixedArgs);
            if (aggr.filter instanceof ConstantExpression && ((ConstantExpression)aggr.filter).getValue() == null) {
                aggr.filter = null;
            } else if (aggr.filter instanceof BytecodeExpression) {
                boolean isValid = false;
                int groupLevel = ((BytecodeExpression)aggr.filter).getGroupLevel();
                if (aggr.calculateLevel == -1) {
                    if (groupLevel == 0 || groupLevel == -1) {
                        isValid = true;
                    }
                } else if (groupLevel == -1) {
                    if (aggr.calculateLevel == 0) {
                        isValid = true;
                    }
                } else if (aggr.calculateLevel == groupLevel) {
                    isValid = true;
                }
                if (!isValid) {
                    throw new DataException("data.engine.InvalidTotalFunc");
                }
            }
        }
        aggr.args = new CompiledExpression[nFixedArgs];
        if (nFixedArgs > 0) {
            exprArgs.subList(0, nFixedArgs).toArray(aggr.args);
        }
        return aggr;
    }

    private int getGroupIndexFromPreparedQuery(String groupText) {
        if (!$assertionsDisabled && groupText == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.groupDefns == null) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < this.groupDefns.size()) {
            IGroupDefinition group = (IGroupDefinition)this.groupDefns.get(i);
            if (groupText.equals(group.getName()) || groupText.equals(group.getKeyColumn()) || groupText.equals(group.getKeyExpression())) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    private int getGroupIndex(String groupText) {
        if (!$assertionsDisabled && groupText == null) {
            throw new AssertionError();
        }
        IQuery.GroupSpec[] groups = this.baseQuery.getGrouping();
        int i = 0;
        while (i < groups.length) {
            IQuery.GroupSpec group = groups[i];
            if (groupText.equals(group.getName()) || groupText.equals(group.getKeyColumn())) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }
}

