/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.i18n;

import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.core.i18n.ResourceHandle;

public class ThreadResources {
    private static Map resourceMap;
    private static ThreadLocal resources;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.core.i18n.ThreadResources");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        resourceMap = new HashMap();
        resources = new ThreadLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocale(ULocale locale) {
        ResourceHandle resourceHandle = null;
        if (locale != null) {
            Map map = resourceMap;
            synchronized (map) {
                resourceHandle = (ResourceHandle)resourceMap.get(locale);
                if (resourceHandle == null) {
                    resourceHandle = new ResourceHandle(locale);
                    resourceMap.put(locale, resourceHandle);
                }
            }
        }
        resources.set(resourceHandle);
    }

    public static void setLocale(Locale locale) {
        ThreadResources.setLocale(ULocale.forLocale((Locale)locale));
    }

    public static ULocale getULocale() {
        ResourceHandle handle = (ResourceHandle)resources.get();
        if (!$assertionsDisabled && handle == null) {
            throw new AssertionError();
        }
        return handle.getUResourceBundle().getULocale();
    }

    public static Locale getLocale() {
        return ThreadResources.getULocale().toLocale();
    }

    public static String getMessage(String key) {
        ResourceHandle handle = (ResourceHandle)resources.get();
        if (!$assertionsDisabled && handle == null) {
            throw new AssertionError();
        }
        return handle.getMessage(key);
    }

    public static String getMessage(String key, Object[] arguments) {
        ResourceHandle handle = (ResourceHandle)resources.get();
        if (!$assertionsDisabled && handle == null) {
            throw new AssertionError();
        }
        return handle.getMessage(key, arguments);
    }
}

