/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.util.logging.Logger;
import org.eclipse.birt.core.script.Finance;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;

public class NativeFinance
extends ScriptableObject {
    private static final long serialVersionUID = -5653141543095782014L;
    protected static Logger logger;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.core.script.NativeFinance");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public String getClassName() {
        return "Finance";
    }

    protected static double toDouble(Object value) {
        return Context.toNumber((Object)value);
    }

    protected static boolean toBoolean(Object value) {
        return Context.toBoolean((Object)value);
    }

    protected static int toInt(Object value) {
        return (int)Context.toNumber((Object)value);
    }

    protected static double[] toDoubleArray(Object value) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[D");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (double[])Context.toType((Object)value, (Class)clazz);
    }

    protected static Object wrap_double(double x) {
        return new Double(x);
    }

    public static double jsStaticFunction_ddb(double cost, double salvage, double life, int period) {
        return Finance.ddb(cost, salvage, life, period);
    }

    public static double jsStaticFunction_fv(double rage, int nPer, double pmt, double pv, int due) {
        return Finance.fv(rage, nPer, pmt, pv, due);
    }

    public static double jsStaticFunction_ipmt(double rate, int per, int nPer, double pv, double fv, int due) {
        return Finance.ipmt(rate, per, nPer, pv, fv, due);
    }

    public static double jsStaticFunction_irr(Object cashObj, double intrate) {
        double[] cash = NativeFinance.toDoubleArray(cashObj);
        return Finance.irr(cash, intrate);
    }

    public static double jsStaticFunction_mirr(Object arptrObj, double frate, double rrate) {
        double[] arptr = NativeFinance.toDoubleArray(arptrObj);
        return Finance.mirr(arptr, frate, rrate);
    }

    public static double jsStaticFunction_nper(double rate, double pmt, double pv, double fv, int due) {
        return Finance.nper(rate, pmt, pv, fv, due);
    }

    public static double jsStaticFunction_npv(double rate, Object arptrObj) {
        double[] arptr = NativeFinance.toDoubleArray(arptrObj);
        return Finance.npv(rate, arptr);
    }

    public static double jsStaticFunction_percent(double denom, double num, double valueIfZero) {
        if (Double.isNaN(valueIfZero)) {
            valueIfZero = 0.0;
        }
        return Finance.percent(denom, num, valueIfZero);
    }

    public static double jsStaticFunction_pmt(double rate, int nper, double pv, double fv, int due) {
        return Finance.pmt(rate, nper, pv, fv, due);
    }

    public static double jsStaticFunction_ppmt(double rate, int per, int nPer, double pv, double fv, int due) {
        return Finance.ppmt(rate, per, nPer, pv, fv, due);
    }

    public static double jsStaticFunction_pv(double rate, int nPer, double pmt, double fv, int due) {
        return Finance.pv(rate, nPer, pmt, fv, due);
    }

    public static double jsStaticFunction_rate(int nPer, double pmt, double pv, double fv, int due, double guess) {
        return Finance.rate(nPer, pmt, pv, fv, due, guess);
    }

    public static double jsStaticFunction_sln(double cost, double salvage, double life) {
        return Finance.sln(cost, salvage, life);
    }

    public static double jsStaticFunction_syd(double cost, double salvage, double life, int period) {
        return Finance.syd(cost, salvage, life, period);
    }
}

