/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.api.script;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.eclipse.birt.report.data.adapter.api.script.DummyParameterAttribute;
import org.eclipse.birt.report.data.adapter.api.script.ReportContextObject;
import org.eclipse.birt.report.data.adapter.api.script.ReportParameters;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;

public class DataAdapterTopLevelScope
extends ImporterTopLevel {
    private static final long serialVersionUID = 4230948829384L;
    private static final String PROP_PARAMS = "params";
    private static final String PROP_REPORTCONTEXT = "reportContext";
    private ModuleHandle designModule;
    private Scriptable paramsProp;
    private Object reportContextProp;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.adapter.api.script.DataAdapterTopLevelScope");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DataAdapterTopLevelScope(Context cx, ModuleHandle module) {
        super(cx);
        new CoreJavaScriptInitializer().initialize(cx, (Scriptable)this);
        this.designModule = module;
    }

    public boolean has(String name, Scriptable start) {
        if (super.has(name, start)) {
            return true;
        }
        if (this.designModule != null && PROP_PARAMS.equals(name)) {
            return true;
        }
        return PROP_REPORTCONTEXT.equals(name);
    }

    public Object get(String name, Scriptable start) {
        Object result = super.get(name, start);
        if (result != NOT_FOUND) {
            return result;
        }
        if (this.designModule != null && PROP_PARAMS.equals(name)) {
            return this.getParamsScriptable();
        }
        if (PROP_REPORTCONTEXT.equals(name)) {
            return this.getReportContext();
        }
        return NOT_FOUND;
    }

    private Object getReportContext() {
        if (this.reportContextProp != null) {
            return this.reportContextProp;
        }
        if (!$assertionsDisabled && this.designModule == null) {
            throw new AssertionError();
        }
        this.reportContextProp = new ReportContextObject(this.designModule);
        return this.reportContextProp;
    }

    private Scriptable getParamsScriptable() {
        if (this.paramsProp != null) {
            return this.paramsProp;
        }
        if (!$assertionsDisabled && this.designModule == null) {
            throw new AssertionError();
        }
        HashMap<String, DummyParameterAttribute> parameters = new HashMap<String, DummyParameterAttribute>();
        List paramsList = this.designModule.getAllParameters();
        int i = 0;
        while (i < paramsList.size()) {
            Object parameterObject = paramsList.get(i);
            if (parameterObject instanceof ScalarParameterHandle) {
                Object value = this.getParamDefaultValue(parameterObject);
                parameters.put(((ScalarParameterHandle)parameterObject).getQualifiedName(), new DummyParameterAttribute(value, ""));
            }
            ++i;
        }
        this.paramsProp = new ReportParameters(parameters, (Scriptable)this);
        return this.paramsProp;
    }

    private Object getParamDefaultValue(Object params) {
        if (!(params instanceof ScalarParameterHandle)) {
            return null;
        }
        ScalarParameterHandle sp = (ScalarParameterHandle)params;
        String defaultValue = sp.getDefaultValue();
        String type = sp.getDataType();
        if (defaultValue == null) {
            if (sp.allowNull()) {
                return null;
            }
            if ("string".equals(type)) {
                if (sp.allowBlank()) {
                    return "";
                }
                return "null";
            }
            if ("float".equals(type)) {
                return new Double(0.0);
            }
            if ("decimal".equals(type)) {
                return new BigDecimal(0.0);
            }
            if ("dateTime".equals(type)) {
                return new java.util.Date(0L);
            }
            if ("date".equals(type)) {
                return new Date(0L);
            }
            if ("time".equals(type)) {
                return new Time(0L);
            }
            if ("boolean".equals(type)) {
                return Boolean.FALSE;
            }
            if ("integer".equals(type)) {
                return new Integer(0);
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
        int typeNum = 0;
        if ("string".equals(type)) {
            typeNum = 5;
        } else if ("float".equals(type)) {
            typeNum = 3;
        } else if ("decimal".equals(type)) {
            typeNum = 4;
        } else if ("dateTime".equals(type)) {
            typeNum = 6;
        } else if ("boolean".equals(type)) {
            typeNum = 1;
        } else if ("integer".equals(type)) {
            typeNum = 2;
        }
        try {
            return DataTypeUtil.convert((Object)defaultValue, (int)typeNum);
        }
        catch (BirtException birtException) {
            return null;
        }
    }
}

