/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.impl.ReportPart;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.util.FileUtil;

public class Image
extends ReportPart
implements IImage {
    protected static Logger logger;
    protected String id = null;
    protected String extension = null;
    protected int source = -1;
    protected byte[] data = null;
    protected String mimeType;
    protected String imageMap;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.impl.Image");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.engine.api.impl.Image");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public Image(String uri) {
        if (uri == null || uri.length() == 0) {
            return;
        }
        this.id = uri;
        if (!FileUtil.isLocalResource(uri)) {
            this.extension = FileUtil.getExtFromFileName(uri);
            this.source = 2;
            return;
        }
        this.source = 3;
        try {
            new URL(uri);
            this.extension = FileUtil.getExtFromFileName(uri);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.extension = FileUtil.getExtFromFileName(uri);
            return;
        }
    }

    public Image(byte[] data, String name) {
        if (data == null) {
            return;
        }
        this.id = name;
        this.data = data;
        this.source = 4;
    }

    public Image(IImageContent content) {
        String imgUri = content.getURI();
        byte[] imgData = content.getData();
        this.imageMap = (String)content.getImageMap();
        this.mimeType = content.getMIMEType();
        this.extension = content.getExtension();
        if (this.extension == null && this.mimeType != null) {
            this.extension = FileUtil.getExtFromType(this.mimeType);
        }
        switch (content.getImageSource()) {
            case 0: {
                if (imgUri == null) break;
                this.id = imgUri;
                this.source = 3;
                break;
            }
            case 1: {
                if (imgData == null) break;
                this.data = imgData;
                this.source = 0;
                this.id = imgUri;
                break;
            }
            case 2: {
                if (imgData == null) break;
                this.data = imgData;
                this.source = 4;
                this.id = content.getInstanceID().toUniqueString();
                break;
            }
            case 3: {
                if (imgUri == null) break;
                this.id = imgUri;
                this.source = 2;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    public String getID() {
        return this.id;
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public byte[] getImageData() throws OutOfMemoryError {
        return this.data;
    }

    public InputStream getImageStream() {
        switch (this.source) {
            case 3: {
                try {
                    URL url = new URL(this.id);
                    return new BufferedInputStream(url.openStream());
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {}
                try {
                    return new BufferedInputStream(new FileInputStream(new File(this.id)));
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    return null;
                }
            }
            case 4: {
                return new ByteArrayInputStream(this.data);
            }
            case 0: {
                return new ByteArrayInputStream(this.data);
            }
            case 2: {
                try {
                    URL url = new URL(this.id);
                    return new BufferedInputStream(url.openStream());
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {}
                return null;
            }
            case -1: {
                return null;
            }
        }
        return null;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getImageMap() {
        return this.imageMap;
    }

    public void setImageMap(String imageMap) {
        this.imageMap = imageMap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeImage(File dest) throws IOException {
        block16: {
            if (this.source == -1) {
                Image.logger.log(Level.SEVERE, "image source {0} is not valid!", this.id);
                return;
            }
            input = this.getImageStream();
            if (input == null) {
                Image.logger.log(Level.SEVERE, "image source {0} is not found!", this.id);
                return;
            }
            parent = new File(dest.getAbsolutePath()).getParent();
            parentDir = new File(parent);
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            output = null;
            try {
                try {
                    output = new BufferedOutputStream(new FileOutputStream(dest));
                    this.copyStream(input, output);
                }
                catch (IOException ex) {
                    Image.logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            catch (Throwable var8_7) {
                var7_8 = null;
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        Image.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                if (output == null) throw var8_7;
                try {
                    output.close();
                    throw var8_7;
                }
                catch (IOException e) {
                    Image.logger.log(Level.SEVERE, e.getMessage(), e);
                }
                throw var8_7;
            }
            {
                var7_9 = null;
                if (input == null) break block16;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 153->160)] { 
lbl42:
            // 1 sources

            input.close();
            break block16;
lbl44:
            // 1 sources

            catch (IOException e) {
                Image.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (output == null) return;
        try {}
        catch (IOException e) {
            Image.logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        output.close();
    }

    protected void copyStream(InputStream src, OutputStream tgt) throws IOException {
        byte[] buffer = new byte[1024];
        int size = 0;
        do {
            if ((size = src.read(buffer)) <= 0) continue;
            tgt.write(buffer, 0, size);
        } while (size > 0);
    }

    public String getExtension() {
        return this.extension;
    }
}

