/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.CSSContext;
import org.eclipse.birt.report.engine.css.engine.CSSStylableElement;
import org.eclipse.birt.report.engine.css.engine.PropertyManagerFactory;
import org.eclipse.birt.report.engine.css.engine.ValueManager;
import org.eclipse.birt.report.engine.css.engine.value.InheritValue;
import org.eclipse.birt.report.engine.css.engine.value.StringValue;
import org.eclipse.birt.report.engine.css.engine.value.URIValue;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSConstants;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.css.engine.value.css.StringManager;
import org.eclipse.birt.report.engine.css.engine.value.css.URIManager;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public abstract class CSSEngine
implements CSSConstants,
CSSValueConstants {
    protected CSSContext cssContext;
    protected Parser parser;
    protected PropertyManagerFactory pm;
    protected StyleDeclarationBuilder styleDeclarationBuilder = new StyleDeclarationBuilder();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.css.engine.CSSEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected CSSEngine(Parser p, PropertyManagerFactory pm, CSSContext ctx) {
        this.parser = p;
        this.cssContext = ctx;
        this.pm = pm;
    }

    public CSSContext getCSSContext() {
        return this.cssContext;
    }

    public int getNumberOfProperties() {
        return this.pm.getNumberOfProperties();
    }

    public int getPropertyIndex(String name) {
        return this.pm.getPropertyIndex(name);
    }

    public String getPropertyName(int idx) {
        return this.pm.getPropertyName(idx);
    }

    public CSSValue parsePropertyValue(int idx, String value) {
        if (!($assertionsDisabled || idx >= 0 && idx < this.pm.getNumberOfProperties())) {
            throw new AssertionError();
        }
        ValueManager vm = this.pm.getValueManager(idx);
        if (vm instanceof StringManager) {
            return new StringValue(19, value);
        }
        if (vm instanceof URIManager) {
            return new URIValue(value);
        }
        try {
            LexicalUnit lu = this.parser.parsePropertyValue(new InputSource((Reader)new StringReader(value)));
            return vm.createValue(lu, this);
        }
        catch (Exception exception) {
            return vm.getDefaultValue();
        }
    }

    public CSSStyleDeclaration parseStyleDeclaration(String value) {
        this.styleDeclarationBuilder.styleDeclaration = new StyleDeclaration(this);
        try {
            this.parser.setDocumentHandler((DocumentHandler)this.styleDeclarationBuilder);
            this.parser.parseStyleDeclaration(new InputSource((Reader)new StringReader(value)));
        }
        catch (Exception exception) {}
        return this.styleDeclarationBuilder.styleDeclaration;
    }

    public boolean isInheritedProperty(int propidx) {
        ValueManager vm = this.pm.getValueManager(propidx);
        return vm.isInheritedProperty();
    }

    public Value resolveStyle(CSSStylableElement elt, int propidx, Value sv, IStyle pcs) {
        ValueManager vm = this.pm.getValueManager(propidx);
        sv = sv != null && sv != InheritValue.INSTANCE ? vm.computeValue(elt, this, propidx, sv) : ((sv == InheritValue.INSTANCE || vm.isInheritedProperty()) && pcs != null ? (Value)pcs.getProperty(propidx) : vm.computeValue(elt, this, propidx, vm.getDefaultValue()));
        return sv;
    }

    protected static class DocumentAdapter
    implements DocumentHandler {
        protected DocumentAdapter() {
        }

        public void startDocument(InputSource source) throws CSSException {
            throw new InternalError();
        }

        public void endDocument(InputSource source) throws CSSException {
            throw new InternalError();
        }

        public void comment(String text) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
            throw new InternalError();
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
            throw new InternalError();
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
            throw new InternalError();
        }

        public void startMedia(SACMediaList media) throws CSSException {
            throw new InternalError();
        }

        public void endMedia(SACMediaList media) throws CSSException {
            throw new InternalError();
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
            throw new InternalError();
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
            throw new InternalError();
        }

        public void startFontFace() throws CSSException {
            throw new InternalError();
        }

        public void endFontFace() throws CSSException {
            throw new InternalError();
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            throw new InternalError();
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            throw new InternalError();
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            throw new InternalError();
        }
    }

    protected class StyleDeclarationBuilder
    extends DocumentAdapter {
        StyleDeclaration styleDeclaration;

        protected StyleDeclarationBuilder() {
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            int i = CSSEngine.this.pm.getPropertyIndex(name);
            if (i == -1) {
                return;
            }
            ValueManager vm = CSSEngine.this.pm.getValueManager(i);
            Value v = vm.createValue(value, CSSEngine.this);
            this.styleDeclaration.setProperty(i, v);
        }
    }
}

