/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.engine.adapter.CubeUtil;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;

public class CubeResultSet
implements ICubeResultSet {
    protected IBaseResultSet parent;
    protected DataSetID id;
    protected String cellId;
    protected IDataEngine dataEngine = null;
    private ExecutionContext context;
    private ICubeQueryDefinition queryDefn;
    private CubeCursor cube;
    private ICubeQueryResults queryResults;
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.data.dte.CubeResultSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.engine.data.dte.CubeResultSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public CubeResultSet(IDataEngine dataEngine, ExecutionContext context, ICubeQueryDefinition queryDefn, ICubeQueryResults rsets) throws BirtException {
        this.parent = null;
        this.context = context;
        this.dataEngine = dataEngine;
        this.queryDefn = queryDefn;
        this.id = rsets.getID() != null ? new DataSetID(rsets.getID()) : new DataSetID("cube");
        this.cube = rsets.getCubeCursor();
        this.queryResults = rsets;
    }

    public CubeResultSet(IDataEngine dataEngine, ExecutionContext context, IBaseResultSet parent, ICubeQueryDefinition queryDefn, ICubeQueryResults rsets) throws BirtException {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        this.parent = parent;
        this.id = rsets.getID() != null ? new DataSetID(rsets.getID()) : new DataSetID("cube");
        this.context = context;
        this.dataEngine = dataEngine;
        this.queryDefn = queryDefn;
        this.cube = rsets.getCubeCursor();
        this.queryResults = rsets;
    }

    public CubeCursor getCubeCursor() {
        return this.cube;
    }

    public String getCellIndex() {
        try {
            this.cellId = CubeUtil.getPositionID(this.cube);
        }
        catch (OLAPException e) {
            this.context.addException(new EngineException("Get cube position error.", e));
        }
        return this.cellId;
    }

    public void close() {
        this.dataEngine.close(this);
        try {
            if (this.queryResults != null) {
                this.queryResults.close();
            }
            if (this.cube != null) {
                this.cube.close();
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public Object evaluate(String expr) throws BirtException {
        return this.context.evaluate(expr);
    }

    public Object evaluate(IBaseExpression expr) throws BirtException {
        if (expr instanceof IScriptExpression) {
            return this.context.evaluate(((IScriptExpression)expr).getText());
        }
        if (expr instanceof IConditionalExpression) {
            return this.context.evaluateCondExpr((IConditionalExpression)expr);
        }
        return null;
    }

    public DataSetID getID() {
        return this.id;
    }

    public IBaseResultSet getParent() {
        return this.parent;
    }

    public IBaseQueryResults getQueryResults() {
        return this.queryResults;
    }

    public String getRawID() {
        return this.getCellIndex();
    }

    public int getType() {
        return 1;
    }

    public void skipTo(String cellIndex) {
        try {
            CubeUtil.positionCursor(this.cube, cellIndex);
        }
        catch (Exception exception) {
            this.context.addException(new EngineException("Error happened in skipping"));
        }
    }
}

