/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.engine.data.dte.AbstractDataEngine;
import org.eclipse.birt.report.engine.data.dte.CubeResultSet;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.ir.Report;
import org.mozilla.javascript.Scriptable;

public class DteDataEngine
extends AbstractDataEngine {
    protected HashMap queryMap = new HashMap();

    public DteDataEngine(ExecutionContext context) {
        super(context);
        try {
            DataSessionContext dteSessionContext = new DataSessionContext(3, null, context.getSharedScope());
            DataEngineContext dteEngineContext = dteSessionContext.getDataEngineContext();
            dteEngineContext.setLocale(context.getLocale());
            String tempDir = this.getTempDir(context);
            if (tempDir != null) {
                dteEngineContext.setTmpdir(tempDir);
            }
            this.dteSession = DataRequestSession.newSession((DataSessionContext)dteSessionContext);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "can't create the DTE data engine", ex);
        }
    }

    protected void doPrepareQuery(Report report, Map appContext) {
        this.appContext = appContext;
        ArrayList queries = report.getQueries();
        int i = 0;
        while (i < queries.size()) {
            IDataQueryDefinition query = (IDataQueryDefinition)queries.get(i);
            try {
                IBasePreparedQuery preparedQuery = this.dteSession.prepare(query, appContext);
                this.queryMap.put(query, preparedQuery);
            }
            catch (BirtException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                this.context.addException(e);
            }
            ++i;
        }
    }

    protected IBaseResultSet doExecuteQuery(IBaseResultSet resultSet, IDataQueryDefinition query, boolean useCache) {
        if (query instanceof IQueryDefinition) {
            return this.doExecuteQuery(resultSet, (IQueryDefinition)query, useCache);
        }
        if (query instanceof ICubeQueryDefinition) {
            return this.doExecuteCube(resultSet, (ICubeQueryDefinition)query, useCache);
        }
        return null;
    }

    protected IBaseResultSet doExecuteQuery(IBaseResultSet resultSet, IQueryDefinition query, boolean useCache) {
        IPreparedQuery pQuery = (IPreparedQuery)this.queryMap.get(query);
        if (pQuery == null) {
            return null;
        }
        try {
            Scriptable scope = this.context.getSharedScope();
            IBaseQueryResults dteResults = null;
            if (resultSet == null) {
                if (useCache) {
                    dteResults = this.getCachedQueryResult((IDataQueryDefinition)query);
                }
                if (dteResults == null) {
                    dteResults = this.dteSession.execute((IBasePreparedQuery)pQuery, null, scope);
                    if (query.cacheQueryResults()) {
                        this.cachedQueryIdMap.put(query, dteResults.getID());
                    }
                }
                resultSet = new QueryResultSet(this, this.context, query, (IQueryResults)dteResults);
            } else {
                if (useCache) {
                    dteResults = this.getCachedQueryResult((IDataQueryDefinition)query);
                }
                if (dteResults == null) {
                    dteResults = this.dteSession.execute((IBasePreparedQuery)pQuery, resultSet.getQueryResults(), scope);
                    if (query.cacheQueryResults()) {
                        this.cachedQueryIdMap.put(query, dteResults.getID());
                    }
                }
                resultSet = new QueryResultSet(this, this.context, resultSet, query, (IQueryResults)dteResults);
            }
            return resultSet;
        }
        catch (BirtException be) {
            logger.log(Level.SEVERE, be.getMessage());
            this.context.addException(be);
            return null;
        }
    }

    protected IBaseResultSet doExecuteCube(IBaseResultSet resultSet, ICubeQueryDefinition query, boolean useCache) {
        if (useCache) {
            String rsetId = String.valueOf(this.cachedQueryIdMap.get(query));
            query.setQueryResultsID(rsetId);
        } else {
            query.setQueryResultsID(null);
        }
        IPreparedCubeQuery pQuery = null;
        try {
            pQuery = this.dteSession.prepare(query, this.appContext);
        }
        catch (BirtException be) {
            logger.log(Level.SEVERE, be.getMessage());
            this.context.addException(be);
        }
        if (pQuery == null) {
            return null;
        }
        try {
            ICubeQueryResults dteResults;
            Scriptable scope = this.context.getSharedScope();
            if (resultSet == null) {
                dteResults = (ICubeQueryResults)this.dteSession.execute((IBasePreparedQuery)pQuery, null, scope);
                resultSet = new CubeResultSet(this, this.context, query, dteResults);
            } else {
                dteResults = (ICubeQueryResults)this.dteSession.execute((IBasePreparedQuery)pQuery, resultSet.getQueryResults(), scope);
                resultSet = new CubeResultSet(this, this.context, resultSet, query, dteResults);
            }
            if (query.cacheQueryResults()) {
                this.cachedQueryIdMap.put(query, dteResults.getID());
            }
            return resultSet;
        }
        catch (BirtException be) {
            logger.log(Level.SEVERE, be.getMessage());
            this.context.addException(be);
            return null;
        }
    }
}

