/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import com.ibm.icu.text.DecimalFormat;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.ir.ActionDesign;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.DrillThroughActionDesign;
import org.eclipse.birt.report.engine.ir.DynamicTextItemDesign;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.HighlightDesign;
import org.eclipse.birt.report.engine.ir.HighlightRuleDesign;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.MapRuleDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.ir.VisibilityDesign;
import org.eclipse.birt.report.engine.ir.VisibilityRuleDesign;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ReportDesignWriter {
    static /* synthetic */ Class class$0;

    public void write(OutputStream out, Report report) throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        new ReportDumpVisitor(document).createDocument(report);
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("indent", "yes");
        tr.setOutputProperty("method", "xml");
        tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        tr.transform(new DOMSource(document), new StreamResult(out));
    }

    private class ReportDumpVisitor
    extends DefaultReportItemVisitorImpl {
        Document document;
        Element element;
        protected DecimalFormat doubleFmt = new DecimalFormat("##.##");
        protected Stack elements = new Stack();
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.parser.ReportDesignWriter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        ReportDumpVisitor(Document document) {
            this.document = document;
        }

        private void writeReportItem(ReportItemDesign item) {
            this.writeStyledElement(item);
            this.attribute("x", item.getX());
            this.attribute("y", item.getY());
            this.attribute("width", item.getWidth());
            this.attribute("height", item.getHeight());
            this.attribute("bookmark", item.getBookmark());
            this.attribute("toc", item.getTOC());
            this.attribute("onCreate", item.getOnCreate());
            this.attribute("onRender", item.getOnRender());
            this.attribute("onPageBreak", item.getOnPageBreak());
            this.writeAction(item.getAction());
            this.writeVisibility(item.getVisibility());
        }

        private void writeStyledElement(StyledElementDesign item) {
            this.writeReportElement(item);
            this.attribute("style", item.getStyleName());
            this.writeMap(item.getMap());
            this.writeHighlight(item.getHighlight());
        }

        protected void writeAction(ActionDesign action) {
            if (action == null) {
                return;
            }
            this.pushTag("action");
            this.attribute("target-window", action.getTargetWindow());
            switch (action.getActionType()) {
                case 2: {
                    this.pushTag("bookmark-link");
                    this.text(action.getBookmark());
                    this.popTag();
                    break;
                }
                case 1: {
                    this.pushTag("hyperlink");
                    this.text(action.getHyperlink());
                    this.popTag();
                    break;
                }
                case 3: {
                    this.pushTag("drill-though");
                    DrillThroughActionDesign drillThrough = action.getDrillThrough();
                    this.attribute("report-name", drillThrough.getReportName());
                    this.attribute("bookmark", drillThrough.getBookmark());
                    this.attribute("bookmark-type", drillThrough.isBookmark());
                    this.attribute("paramters", drillThrough.getParameters());
                    this.attribute("search", drillThrough.getSearch());
                    this.attribute("format", drillThrough.getFormat());
                    this.popTag();
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            this.popTag();
        }

        void writeVisibility(VisibilityDesign visibility) {
            if (visibility == null) {
                return;
            }
            this.pushTag("visibility");
            int i = 0;
            while (i < visibility.count()) {
                VisibilityRuleDesign rule = visibility.getRule(i);
                this.pushTag("rule");
                this.attribute("format", rule.getExpression());
                this.text(rule.getExpression());
                this.popTag();
                ++i;
            }
            this.popTag();
        }

        void writeMap(MapDesign map) {
            if (map == null) {
                return;
            }
            this.pushTag("map");
            int i = 0;
            while (i < map.getRuleCount()) {
                MapRuleDesign rule = map.getRule(i);
                this.pushTag("rule");
                this.attribute("expression", rule.getTestExpression());
                this.attribute("operator", rule.getOperator());
                this.attribute("value1", rule.getValue1());
                this.attribute("value2", rule.getValue2());
                this.text(rule.getDisplayText());
                this.popTag();
                ++i;
            }
            this.popTag();
        }

        void writeHighlight(HighlightDesign highlight) {
            if (highlight == null) {
                return;
            }
            this.pushTag("map");
            int i = 0;
            while (i < highlight.getRuleCount()) {
                HighlightRuleDesign rule = highlight.getRule(i);
                this.pushTag("rule");
                this.attribute("expression", rule.getTestExpression());
                this.attribute("operator", rule.getOperator());
                this.attribute("value1", rule.getValue1());
                this.attribute("value2", rule.getValue2());
                this.text(rule.getStyle().getCssText());
                this.popTag();
                ++i;
            }
            this.popTag();
        }

        private void writeReportElement(ReportElementDesign elem) {
            if (elem.getID() > 0L) {
                this.attribute("id", elem.getID());
            }
            this.attribute("name", elem.getName());
            this.attribute("extends", elem.getExtends());
            this.attribute("javaClass", elem.getJavaClass());
            this.attribute("properties", elem.getCustomProperties());
            this.attribute("expressions", elem.getNamedExpressions());
        }

        public void createDocument(Report report) {
            this.pushTag("report");
            Map styles = report.getStyles();
            if (styles.size() > 0) {
                Iterator iter = styles.entrySet().iterator();
                this.pushTag("styles");
                while (iter.hasNext()) {
                    this.pushTag("style");
                    Map.Entry entry = iter.next();
                    String styleName = (String)entry.getKey();
                    IStyle style = (IStyle)entry.getValue();
                    this.attribute("name", styleName);
                    this.attribute("css-text", style.getCssText());
                    this.popTag();
                }
                this.popTag();
            }
            this.pushTag("page-setup");
            PageSetupDesign pageSetup = report.getPageSetup();
            int i = 0;
            while (i < pageSetup.getMasterPageCount()) {
                this.writeSimpleMasterPage((SimpleMasterPageDesign)pageSetup.getMasterPage(i));
                ++i;
            }
            this.popTag();
            if (report.getContentCount() > 0) {
                this.pushTag("body");
                i = 0;
                while (i < report.getContentCount()) {
                    report.getContent(i).accept(this, null);
                    ++i;
                }
                this.popTag();
            }
            this.popTag();
        }

        public Object visitBand(BandDesign band, Object value) {
            this.pushTag("band");
            this.writeReportItem(band);
            int i = 0;
            while (i < band.getContentCount()) {
                band.getContent(i).accept(this, value);
                ++i;
            }
            this.popTag();
            return value;
        }

        private void writeMasterPage(MasterPageDesign page) {
            this.writeStyledElement(page);
            this.attribute("type", page.getPageType());
            this.attribute("width", page.getPageWidth());
            this.attribute("height", page.getPageHeight());
            this.attribute("orientation", page.getOrientation());
            this.attribute("top-margin", page.getTopMargin());
            this.attribute("bottom-margin", page.getBottomMargin());
            this.attribute("left-margin", page.getLeftMargin());
            this.attribute("right-margin", page.getRightMargin());
        }

        private void writeSimpleMasterPage(SimpleMasterPageDesign page) {
            this.pushTag("simple-master-page");
            this.writeMasterPage(page);
            this.attribute("show-header-on-first", page.isShowHeaderOnFirst());
            this.attribute("show-footer-on-last", page.isShowFooterOnLast());
            this.attribute("floating-footer", page.isFloatingFooter());
            this.pushTag("header");
            int i = 0;
            while (i < page.getHeaderCount()) {
                page.getHeader(i).accept(this, null);
                ++i;
            }
            this.popTag();
            this.pushTag("footer");
            i = 0;
            while (i < page.getFooterCount()) {
                page.getFooter(i).accept(this, null);
                ++i;
            }
            this.popTag();
            this.popTag();
        }

        protected void writeListing(ListingDesign listing) {
            BandDesign footer;
            this.attribute("repeat-header", listing.isRepeatHeader());
            this.attribute("page-break-interval", listing.getPageBreakInterval());
            BandDesign header = listing.getHeader();
            if (header != null) {
                header.accept(this, null);
            }
            int i = 0;
            while (i < listing.getGroupCount()) {
                listing.getGroup(i).accept(this, null);
                ++i;
            }
            BandDesign detail = listing.getDetail();
            if (detail != null) {
                detail.accept(this, null);
            }
            if ((footer = listing.getFooter()) != null) {
                footer.accept(this, null);
            }
        }

        public Object visitGroup(GroupDesign group, Object value) {
            this.pushTag("group");
            this.writeReportItem(group);
            if (group.getHeader() != null) {
                group.getHeader().accept(this, value);
            }
            if (group.getFooter() != null) {
                group.getFooter().accept(this, value);
            }
            this.popTag();
            return value;
        }

        public Object visitTextItem(TextItemDesign text, Object value) {
            this.pushTag("text");
            this.writeReportItem(text);
            this.attribute("type", text.getTextType());
            this.attribute("text-key", text.getTextKey());
            this.text(text.getText());
            this.popTag();
            return value;
        }

        public Object visitDynamicTextItem(DynamicTextItemDesign dynamicText, Object value) {
            this.pushTag("dynamic-text");
            this.writeReportItem(dynamicText);
            this.attribute("content-type", dynamicText.getContentType());
            this.text(dynamicText.getContent());
            this.popTag();
            return value;
        }

        public Object visitListItem(ListItemDesign list, Object value) {
            this.pushTag("list");
            this.writeListing(list);
            this.popTag();
            return value;
        }

        public Object visitDataItem(DataItemDesign data, Object value) {
            this.pushTag("data");
            this.writeReportItem(data);
            this.attribute("supress-duplicate", data.getSuppressDuplicate());
            this.attribute("help-text", data.getHelpText());
            this.attribute("help-text-key", data.getHelpTextKey());
            this.text(data.getBindingColumn());
            this.popTag();
            return value;
        }

        public Object visitLabelItem(LabelItemDesign label, Object value) {
            this.pushTag("label");
            this.writeReportItem(label);
            this.attribute("help-text", label.getHelpText());
            this.attribute("help-text-key", label.getHelpTextKey());
            this.attribute("text-key", label.getTextKey());
            this.text(label.getText());
            this.popTag();
            return value;
        }

        public Object visitGridItem(GridItemDesign grid, Object value) {
            this.pushTag("grid");
            this.writeReportItem(grid);
            this.pushTag("columns");
            int i = 0;
            while (i < grid.getColumnCount()) {
                this.writeColumn(grid.getColumn(i));
                ++i;
            }
            this.popTag();
            i = 0;
            while (i < grid.getRowCount()) {
                grid.getRow(i).accept(this, value);
                ++i;
            }
            this.popTag();
            return value;
        }

        protected void writeColumn(ColumnDesign column) {
            this.pushTag("column");
            this.writeStyledElement(column);
            this.attribute("width", column.getWidth());
            this.attribute("supress-duplicate", column.getSuppressDuplicate());
            this.attribute("has-data-in-detail", column.hasDataItemsInDetail());
            this.attribute("visibility", column.getVisibility());
            this.popTag();
        }

        public Object visitRow(RowDesign row, Object value) {
            this.pushTag("row");
            this.writeReportItem(row);
            this.attribute("start-of-group", row.isStartOfGroup());
            int i = 0;
            while (i < row.getCellCount()) {
                row.getCell(i).accept(this, value);
                ++i;
            }
            this.popTag();
            return value;
        }

        public Object visitCell(CellDesign cell, Object value) {
            this.pushTag("cell");
            this.writeReportItem(cell);
            this.attribute("column", cell.getColumn());
            this.attribute("col-span", cell.getColSpan(), 1.0);
            this.attribute("row-span", cell.getRowSpan(), 1.0);
            this.attribute("drop", cell.getDrop());
            int i = 0;
            while (i < cell.getContentCount()) {
                cell.getContent(i).accept(this, null);
                ++i;
            }
            this.popTag();
            return value;
        }

        public Object visitTableItem(TableItemDesign table, Object value) {
            this.pushTag("table");
            this.pushTag("columns");
            int i = 0;
            while (i < table.getColumnCount()) {
                this.writeColumn(table.getColumn(i));
                ++i;
            }
            this.popTag();
            this.writeListing(table);
            this.attribute("caption", table.getCaption());
            this.attribute("caption-key", table.getCaptionKey());
            this.popTag();
            return value;
        }

        public Object visitImageItem(ImageItemDesign image, Object value) {
            this.pushTag("image");
            this.writeReportItem(image);
            switch (image.getImageSource()) {
                case 1: {
                    this.attribute("image-name", image.getImageName());
                    break;
                }
                case 0: {
                    this.attribute("image-uri", image.getImageUri());
                    break;
                }
                case 3: {
                    this.attribute("image-file", image.getImageUri());
                    this.popTag();
                    break;
                }
                case 2: {
                    this.attribute("image-type", image.getImageFormat());
                    this.attribute("image-expr", image.getImageExpression());
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            this.attribute("help-text", image.getHelpText());
            this.attribute("help-text-key", image.getHelpTextKey());
            this.attribute("alt-text", image.getAltText());
            this.attribute("alt-text-key", image.getAltTextKey());
            this.popTag();
            return value;
        }

        public Object visitFreeFormItem(FreeFormItemDesign free, Object value) {
            this.pushTag("free-form");
            this.writeReportItem(free);
            int i = 0;
            while (i < free.getItemCount()) {
                free.getItem(i).accept(this, null);
                ++i;
            }
            this.popTag();
            return value;
        }

        protected void attribute(String name, String value) {
            if (value != null && !"".equals(value)) {
                this.element.setAttribute(name, value);
            }
        }

        protected void attribute(String name, Map map) {
            if (map != null && !map.isEmpty()) {
                StringBuffer buffer = new StringBuffer();
                Iterator iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    buffer.append(entry.getKey());
                    buffer.append(":");
                    buffer.append(entry.getValue());
                    buffer.append(";");
                }
                if (buffer.length() != 0) {
                    buffer.setLength(buffer.length() - 1);
                }
                this.attribute(name, buffer.toString());
            }
        }

        protected void attribute(String name, double value) {
            this.attribute(name, value, 0.0);
        }

        protected void attribute(String name, double value, double omitValue) {
            if (value != omitValue) {
                this.attribute(name, this.doubleFmt.format(value));
            }
        }

        protected void attribute(String name, boolean value) {
            this.attribute(name, value ? "true" : "false");
        }

        protected void attribute(String name, Object value) {
            if (value != null) {
                this.attribute(name, value.toString());
            }
        }

        protected void pushTag(String tag) {
            this.elements.push(this.element);
            Element child = this.document.createElement(tag);
            if (this.element != null) {
                this.element.appendChild(child);
            } else {
                this.document.appendChild(child);
            }
            this.element = child;
        }

        protected void text(String text) {
            if (text == null || "".equals(text.trim())) {
                return;
            }
            Text textNode = this.document.createTextNode(text);
            this.element.appendChild(textNode);
        }

        protected void popTag() {
            this.element = (Element)this.elements.pop();
        }
    }
}

