/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

public class PageHint
implements IPageHint {
    ArrayList sections = new ArrayList();
    protected long pageNumber;
    protected long offset;
    ArrayList hints = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.presentation.PageHint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PageHint() {
        this.pageNumber = 0L;
        this.offset = -1L;
    }

    public PageHint(long pageNumber, long pageOffset) {
        this.pageNumber = pageNumber;
        this.offset = pageOffset;
    }

    public PageHint(long pageNumber, long pageOffset, long pageStart, long pageEnd) {
        this.pageNumber = pageNumber;
        this.offset = pageOffset;
        this.addSection(pageStart, pageEnd);
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public int getSectionCount() {
        return this.sections.size();
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSectionStart(int i) {
        PageSection section = (PageSection)this.sections.get(i);
        return section.startOffset;
    }

    public long getSectionEnd(int i) {
        PageSection section = (PageSection)this.sections.get(i);
        return section.endOffset;
    }

    public void addSection(long start, long end) {
        PageSection section = new PageSection();
        section.startOffset = start;
        section.endOffset = end;
        this.sections.add(section);
    }

    public PageSection getSection(int i) {
        return (PageSection)this.sections.get(i);
    }

    public void addSection(PageSection section) {
        this.sections.add(section);
    }

    public void addUnresolvedRowHints(Collection hints) {
        this.hints.addAll(hints);
    }

    public int getUnresolvedRowCount() {
        return this.hints.size();
    }

    public UnresolvedRowHint getUnresolvedRowHint(int index) {
        if (!($assertionsDisabled || index >= 0 && index < this.hints.size())) {
            throw new AssertionError();
        }
        return (UnresolvedRowHint)this.hints.get(index);
    }

    public void addUnresolvedRowHint(UnresolvedRowHint hint) {
        this.hints.add(hint);
    }
}

