/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.report.engine.api.IPageHandler;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.emitter.CompositeContentEmitter;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ContextPageBreakHandler;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.OnPageBreakLayoutPageHandle;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.IPageHintWriter;
import org.eclipse.birt.report.engine.internal.document.IReportContentWriter;
import org.eclipse.birt.report.engine.internal.document.v3.PageHintWriterV3;
import org.eclipse.birt.report.engine.internal.document.v3.ReportContentWriterV3;
import org.eclipse.birt.report.engine.internal.presentation.ReportDocumentInfo;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.layout.CompositeLayoutPageHandler;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.LayoutEngineFactory;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;
import org.eclipse.birt.report.engine.presentation.PageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.toc.TOCTree;

public class ReportDocumentBuilder {
    protected static Logger logger;
    protected ExecutionContext executionContext;
    protected long pageNumber;
    protected long pageOffset;
    protected HashMap bookmarks = new HashMap();
    protected HashMap reportletsIndexById = new HashMap();
    protected HashMap reportletsIndexByBookmark = new HashMap();
    protected ReportDocumentWriter document;
    protected IContentEmitter contentEmitter;
    protected CompositeContentEmitter outputEmitters;
    protected IPageHintWriter pageHintWriter;
    protected IPageHandler pageHandler;
    protected IReportLayoutEngine engine;
    protected CompositeLayoutPageHandler layoutPageHandler;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.presentation.ReportDocumentBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public ReportDocumentBuilder(ExecutionContext context, ReportDocumentWriter document) {
        this.executionContext = context;
        this.document = document;
        OnPageBreakLayoutPageHandle onPageBreakHandler = new OnPageBreakLayoutPageHandle(context);
        this.outputEmitters = new CompositeContentEmitter();
        this.outputEmitters.addEmitter(new PageEmitter());
        this.outputEmitters.addEmitter(onPageBreakHandler.getEmitter());
        this.layoutPageHandler = new CompositeLayoutPageHandler();
        this.layoutPageHandler.addPageHandler(new LayoutPageHandler());
        this.layoutPageHandler.addPageHandler(onPageBreakHandler);
        this.layoutPageHandler.addPageHandler(new ContextPageBreakHandler(this.executionContext));
        this.contentEmitter = new ContentEmitter();
    }

    public IContentEmitter getContentEmitter() {
        return this.contentEmitter;
    }

    public void build() {
        IReportExecutor executor = this.executionContext.getExecutor();
        this.engine = LayoutEngineFactory.createLayoutEngine("page-break-pagination");
        this.engine.setOption("task_type", new Integer(1));
        this.engine.setPageHandler(this.layoutPageHandler);
        IReportContent report = executor.execute();
        this.outputEmitters.start(report);
        this.engine.layout(executor, report, this.outputEmitters, true);
        this.outputEmitters.end(report);
        this.engine = null;
    }

    public void cancel() {
        if (this.engine != null) {
            this.engine.cancel();
        }
    }

    public void setPageHandler(IPageHandler handler) {
        this.pageHandler = handler;
    }

    protected void ensureContentSaved(IReportContentWriter writer, IContent content) throws IOException {
        DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
        if (docExt == null) {
            IContent parent = (IContent)content.getParent();
            if (parent != null && parent != parent.getReportContent().getRoot()) {
                this.ensureContentSaved(writer, parent);
            }
            writer.writeContent(content);
        }
    }

    long writeContent(IReportContentWriter writer, IContent content) throws IOException {
        IContent parent = (IContent)content.getParent();
        if (parent != null && parent != parent.getReportContent().getRoot()) {
            this.ensureContentSaved(writer, parent);
        }
        return writer.writeContent(content);
    }

    long writeFullContent(IReportContentWriter writer, IContent content) throws IOException {
        long offset = this.writeContent(writer, content);
        Iterator iter = content.getChildren().iterator();
        while (iter.hasNext()) {
            IContent child = (IContent)iter.next();
            this.writeFullContent(writer, child);
        }
        return offset;
    }

    private boolean needSave(IContent content) {
        InstanceID pid;
        InstanceID id = content.getInstanceID();
        if (id == null || id.getComponentID() == -1L) {
            return true;
        }
        IContent parent = (IContent)content.getParent();
        if (parent != null && ((pid = parent.getInstanceID()) == null || pid.getComponentID() == -1L)) {
            return true;
        }
        if (content instanceof AbstractContent) {
            return ((AbstractContent)content).needSave();
        }
        return true;
    }

    class ContentEmitter
    extends ContentEmitterAdapter {
        IReportContentWriter writer;

        ContentEmitter() {
        }

        protected void open() {
            try {
                this.writer = new ReportContentWriterV3(ReportDocumentBuilder.this.document);
                this.writer.open("/content/content.dat");
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "failed to open the content writers", ex);
                this.close();
            }
        }

        protected void close() {
            if (this.writer != null) {
                this.writer.close();
            }
            this.writer = null;
        }

        public void start(IReportContent report) {
            this.open();
        }

        public void end(IReportContent report) {
            this.close();
            ITOCTree tocTree = report.getTOCTree(null, null);
            if (tocTree instanceof TOCTree) {
                ReportDocumentBuilder.this.document.saveTOC((TOCTree)report.getTOCTree(null, null));
            }
            ReportDocumentBuilder.this.document.saveReportletsIdIndex(ReportDocumentBuilder.this.reportletsIndexById);
            ReportDocumentBuilder.this.document.saveReprotletsBookmarkIndex(ReportDocumentBuilder.this.reportletsIndexByBookmark);
        }

        public void startContent(IContent content) {
            if (this.writer != null) {
                if (!ReportDocumentBuilder.this.needSave(content)) {
                    return;
                }
                try {
                    String bookmark;
                    String strIID;
                    InstanceID iid;
                    long offset = ReportDocumentBuilder.this.writeContent(this.writer, content);
                    Object generateBy = content.getGenerateBy();
                    if ((generateBy instanceof TableItemDesign || generateBy instanceof ListItemDesign || generateBy instanceof ExtendedItemDesign) && (iid = content.getInstanceID()) != null && ReportDocumentBuilder.this.reportletsIndexById.get(strIID = iid.toUniqueString()) == null) {
                        ReportDocumentBuilder.this.reportletsIndexById.put(strIID, new Long(offset));
                    }
                    if ((bookmark = content.getBookmark()) != null && ReportDocumentBuilder.this.reportletsIndexByBookmark.get(bookmark) == null) {
                        ReportDocumentBuilder.this.reportletsIndexByBookmark.put(bookmark, new Long(offset));
                    }
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, "Write content error");
                    this.close();
                }
            }
        }
    }

    class LayoutPageHandler
    implements ILayoutPageHandler {
        IPageHintWriter hintWriter;

        LayoutPageHandler() {
        }

        boolean ensureOpen() {
            if (this.hintWriter != null) {
                return true;
            }
            try {
                this.hintWriter = new PageHintWriterV3(ReportDocumentBuilder.this.document.getArchive());
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Can't open the hint stream", ex);
                return false;
            }
            return true;
        }

        protected void close() {
            if (this.hintWriter != null) {
                this.hintWriter.close();
            }
            this.hintWriter = null;
        }

        void writeTotalPage(long pageNumber) {
            if (this.ensureOpen()) {
                try {
                    this.hintWriter.writeTotalPage(pageNumber);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Failed to save the page number", ex);
                    this.close();
                }
            }
        }

        void writePageHint(PageHint pageHint) {
            if (this.ensureOpen()) {
                try {
                    this.hintWriter.writePageHint(pageHint);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Failed to save the page hint", ex);
                    this.close();
                }
            }
        }

        private long getContentIndex(IContent content) {
            DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
            if (docExt != null) {
                long offset = docExt.getIndex();
                if (offset != -1L) {
                    return offset;
                }
                return docExt.getPrevious();
            }
            return -1L;
        }

        private InstanceIndex[] createInstanceIndexes(IContent content) {
            LinkedList<InstanceIndex> indexes = new LinkedList<InstanceIndex>();
            while (content != null && content != content.getReportContent().getRoot()) {
                InstanceID id = content.getInstanceID();
                long offset = this.getContentIndex(content);
                indexes.addFirst(new InstanceIndex(id, offset));
                content = (IContent)content.getParent();
            }
            return indexes.toArray(new InstanceIndex[0]);
        }

        private PageSection createPageSection(IContent start, IContent end) {
            PageSection section = new PageSection();
            section.starts = this.createInstanceIndexes(start);
            section.ends = this.createInstanceIndexes(end);
            return section;
        }

        public void onPage(long pageNumber, Object context) {
            if (context instanceof HTMLLayoutContext) {
                HTMLLayoutContext htmlContext = (HTMLLayoutContext)context;
                ReportDocumentBuilder.this.document.setPageCount(pageNumber);
                boolean reportFinished = htmlContext.isFinished();
                if (reportFinished) {
                    this.writeTotalPage(pageNumber);
                    this.close();
                    return;
                }
                boolean checkpoint = false;
                if (pageNumber == 1L || pageNumber == 10L || pageNumber == 50L || pageNumber % 100L == 0L) {
                    checkpoint = true;
                }
                ArrayList pageHint = htmlContext.getPageHint();
                PageHint hint = new PageHint(pageNumber, ReportDocumentBuilder.this.pageOffset);
                int i = 0;
                while (i < pageHint.size()) {
                    IContent[] range = (IContent[])pageHint.get(i);
                    PageSection section = this.createPageSection(range[0], range[1]);
                    hint.addSection(section);
                    ++i;
                }
                hint.addUnresolvedRowHints(htmlContext.getUnresolvedRowHints());
                this.writePageHint(hint);
                if (checkpoint) {
                    try {
                        IDocArchiveWriter archive = ReportDocumentBuilder.this.document.getArchive();
                        this.writeTotalPage(pageNumber);
                        ReportDocumentBuilder.this.document.saveCoreStreams();
                        archive.flush();
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, " check point failed ", e);
                    }
                }
                if (ReportDocumentBuilder.this.pageHandler != null && !htmlContext.getCancelFlag()) {
                    ReportDocumentInfo docInfo = new ReportDocumentInfo(ReportDocumentBuilder.this.executionContext, pageNumber, false);
                    ReportDocumentBuilder.this.pageHandler.onPage((int)pageNumber, checkpoint, docInfo);
                }
            }
        }
    }

    class PageEmitter
    extends ContentEmitterAdapter {
        IReportContentWriter pageWriter;

        PageEmitter() {
        }

        protected void open() {
            try {
                this.pageWriter = new ReportContentWriterV3(ReportDocumentBuilder.this.document);
                this.pageWriter.open("/content/page.dat");
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "failed to open the content writers", ex);
                this.close();
            }
        }

        protected void close() {
            if (this.pageWriter != null) {
                this.pageWriter.close();
            }
            this.pageWriter = null;
        }

        public void start(IReportContent report) {
            this.open();
        }

        public void end(IReportContent report) {
            this.close();
            ReportDocumentBuilder.this.document.saveBookmarks(ReportDocumentBuilder.this.bookmarks);
        }

        public void startPage(IPageContent page) {
            ReportDocumentBuilder.this.pageNumber = page.getPageNumber();
            try {
                ReportDocumentBuilder.this.pageOffset = ReportDocumentBuilder.this.writeFullContent(this.pageWriter, page);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "write page content failed", ex);
                this.close();
            }
        }

        public void startContent(IContent content) {
            if (content.getBookmark() != null && !ReportDocumentBuilder.this.bookmarks.containsKey(content.getBookmark())) {
                ReportDocumentBuilder.this.bookmarks.put(content.getBookmark(), new Long(ReportDocumentBuilder.this.pageNumber));
            }
        }
    }
}

