/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.script.IRowData;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;

public class RowData
implements IRowData {
    protected static Logger logger;
    private IBaseResultSet rset;
    private ArrayList bindingNames = new ArrayList();
    private static final Pattern rowWithIndex;
    private static final Pattern rowWithWord;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.IRowData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        rowWithIndex = Pattern.compile("(row\\[\\d+\\])", 2);
        rowWithWord = Pattern.compile("(row\\[\\w+\\])", 2);
    }

    public RowData(IBaseResultSet rset, ReportItemHandle element) {
        this.rset = rset;
        if (element != null) {
            this.addColumnBindings(element.columnBindingsIterator());
        }
    }

    private void addColumnBindings(Iterator bindingIter) {
        if (bindingIter != null) {
            while (bindingIter.hasNext()) {
                ComputedColumnHandle binding = (ComputedColumnHandle)bindingIter.next();
                this.bindingNames.add(binding.getName());
            }
        }
    }

    public Object getExpressionValue(String expression) throws ScriptException {
        expression = this.process(expression);
        try {
            return this.rset.evaluate(expression);
        }
        catch (BirtException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public Object getExpressionValue(int index) throws ScriptException {
        String name = this.getColumnName(index);
        if (name != null) {
            return this.getColumnValue(name);
        }
        return null;
    }

    private String process(String expression) {
        if (expression == null) {
            return null;
        }
        expression = expression.trim();
        Matcher mWord = rowWithWord.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (mWord.find()) {
            String group = mWord.group(1);
            Matcher mIndex = rowWithIndex.matcher(group);
            if (!mIndex.matches()) {
                group = group.replaceAll("\\[", "[\"");
                group = group.replaceAll("\\]", "\"]");
            }
            mWord.appendReplacement(sb, group);
        }
        mWord.appendTail(sb);
        return sb.toString();
    }

    public int getExpressionCount() {
        return this.getColumnCount();
    }

    public Object getColumnValue(String name) throws ScriptException {
        try {
            if (this.rset != null && this.rset.getType() == 0) {
                return ((IQueryResultSet)this.rset).getValue(name);
            }
        }
        catch (BirtException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return null;
    }

    public Object getColumnValue(int index) throws ScriptException {
        String name = this.getColumnName(index);
        if (name != null) {
            return this.getColumnValue(name);
        }
        return null;
    }

    public String getColumnName(int index) {
        if (index < this.bindingNames.size()) {
            return (String)this.bindingNames.get(index);
        }
        return null;
    }

    public int getColumnCount() {
        return this.bindingNames.size();
    }
}

