/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.script.eventhandler.ITableGroupEventHandler;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.TableGroup;
import org.eclipse.birt.report.engine.script.internal.instance.ReportElementInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;

public class TableGroupScriptExecutor
extends ScriptExecutor {
    static /* synthetic */ Class class$0;

    public static void handleOnPrepare(TableGroupHandle groupHandle, ExecutionContext context) {
        try {
            TableGroup group = new TableGroup(groupHandle);
            ITableGroupEventHandler eh = TableGroupScriptExecutor.getEventHandler(groupHandle, context);
            if (eh != null) {
                eh.onPrepare(group, context.getReportContext());
            }
        }
        catch (Exception e) {
            TableGroupScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnPageBreak(ITableGroupContent content, ExecutionContext context) {
        try {
            ReportItemDesign tableGroupDesign = (ReportItemDesign)content.getGenerateBy();
            if (!TableGroupScriptExecutor.needOnPageBreak(tableGroupDesign)) {
                return;
            }
            ReportElementInstance table = new ReportElementInstance(content, context);
            if (TableGroupScriptExecutor.handleJS(table, tableGroupDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            ITableGroupEventHandler eh = TableGroupScriptExecutor.getEventHandler(tableGroupDesign, context);
            if (eh != null) {
                eh.onPageBreak(table, context.getReportContext());
            }
        }
        catch (Exception e) {
            TableGroupScriptExecutor.addException(context, e);
        }
    }

    private static ITableGroupEventHandler getEventHandler(TableGroupHandle handle, ExecutionContext context) {
        try {
            return (ITableGroupEventHandler)TableGroupScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            String string = handle.getEventHandlerClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.eventhandler.ITableGroupEventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            TableGroupScriptExecutor.addClassCastException(context, e, string, clazz);
            return null;
        }
    }

    private static ITableGroupEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        try {
            return (ITableGroupEventHandler)TableGroupScriptExecutor.getInstance(design, context);
        }
        catch (ClassCastException e) {
            String string = design.getJavaClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.eventhandler.ITableGroupEventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            TableGroupScriptExecutor.addClassCastException(context, e, string, clazz);
            return null;
        }
    }
}

