/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;

public abstract class IndexInput
implements Cloneable {
    private char[] chars;

    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readVLong() throws IOException {
        byte b = this.readByte();
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    public String readString() throws IOException {
        int length = this.readVInt();
        if (this.chars == null || length > this.chars.length) {
            this.chars = new char[length];
        }
        this.readChars(this.chars, 0, length);
        return new String(this.chars, 0, length);
    }

    public void readChars(char[] buffer, int start, int length) throws IOException {
        int end = start + length;
        int i = start;
        while (i < end) {
            byte b = this.readByte();
            buffer[i] = (b & 0x80) == 0 ? (char)(b & 0x7F) : ((b & 0xE0) != 224 ? (char)((b & 0x1F) << 6 | this.readByte() & 0x3F) : (char)((b & 0xF) << 12 | (this.readByte() & 0x3F) << 6 | this.readByte() & 0x3F));
            ++i;
        }
    }

    public abstract void close() throws IOException;

    public abstract long getFilePointer();

    public abstract void seek(long var1) throws IOException;

    public abstract long length();

    public Object clone() {
        IndexInput clone = null;
        try {
            clone = (IndexInput)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        clone.chars = null;
        return clone;
    }
}

