/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.type.impl;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.icu.util.ULocale;
import java.util.Collection;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.model.type.TypeFactory;
import org.eclipse.birt.chart.model.type.TypePackage;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class LineSeriesImpl
extends SeriesImpl
implements LineSeries {
    protected EList markers = null;
    protected Marker marker = null;
    protected LineAttributes lineAttributes = null;
    protected static final boolean PALETTE_LINE_COLOR_EDEFAULT = false;
    protected boolean paletteLineColor = false;
    protected boolean paletteLineColorESet = false;
    protected static final boolean CURVE_EDEFAULT = false;
    protected boolean curve = false;
    protected boolean curveESet = false;
    protected ColorDefinition shadowColor = null;
    protected static final boolean CONNECT_MISSING_VALUE_EDEFAULT = true;
    protected boolean connectMissingValue = true;
    protected boolean connectMissingValueESet = false;
    static /* synthetic */ Class class$0;

    protected LineSeriesImpl() {
    }

    protected EClass eStaticClass() {
        return TypePackage.Literals.LINE_SERIES;
    }

    public EList getMarkers() {
        if (this.markers == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.chart.model.attribute.Marker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.markers = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 11);
        }
        return this.markers;
    }

    public Marker getMarker() {
        if (this.getMarkers().size() == 0) {
            return null;
        }
        return (Marker)this.getMarkers().get(0);
    }

    public NotificationChain basicSetMarker(Marker newMarker, NotificationChain msgs) {
        Marker oldMarker = this.marker;
        this.marker = newMarker;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldMarker, (Object)newMarker);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setMarker(Marker newMarker) {
        if (this.getMarkers().size() == 0) {
            this.getMarkers().add((Object)newMarker);
        }
        this.getMarkers().set(0, (Object)newMarker);
    }

    public LineAttributes getLineAttributes() {
        return this.lineAttributes;
    }

    public NotificationChain basicSetLineAttributes(LineAttributes newLineAttributes, NotificationChain msgs) {
        LineAttributes oldLineAttributes = this.lineAttributes;
        this.lineAttributes = newLineAttributes;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldLineAttributes, (Object)newLineAttributes);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setLineAttributes(LineAttributes newLineAttributes) {
        if (newLineAttributes != this.lineAttributes) {
            NotificationChain msgs = null;
            if (this.lineAttributes != null) {
                msgs = ((InternalEObject)this.lineAttributes).eInverseRemove((InternalEObject)this, -14, null, msgs);
            }
            if (newLineAttributes != null) {
                msgs = ((InternalEObject)newLineAttributes).eInverseAdd((InternalEObject)this, -14, null, msgs);
            }
            if ((msgs = this.basicSetLineAttributes(newLineAttributes, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)newLineAttributes, (Object)newLineAttributes));
        }
    }

    public boolean isPaletteLineColor() {
        return this.paletteLineColor;
    }

    public void setPaletteLineColor(boolean newPaletteLineColor) {
        boolean oldPaletteLineColor = this.paletteLineColor;
        this.paletteLineColor = newPaletteLineColor;
        boolean oldPaletteLineColorESet = this.paletteLineColorESet;
        this.paletteLineColorESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, oldPaletteLineColor, this.paletteLineColor, !oldPaletteLineColorESet));
        }
    }

    public void unsetPaletteLineColor() {
        boolean oldPaletteLineColor = this.paletteLineColor;
        boolean oldPaletteLineColorESet = this.paletteLineColorESet;
        this.paletteLineColor = false;
        this.paletteLineColorESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 14, oldPaletteLineColor, false, oldPaletteLineColorESet));
        }
    }

    public boolean isSetPaletteLineColor() {
        return this.paletteLineColorESet;
    }

    public boolean isCurve() {
        return this.curve;
    }

    public void setCurve(boolean newCurve) {
        boolean oldCurve = this.curve;
        this.curve = newCurve;
        boolean oldCurveESet = this.curveESet;
        this.curveESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, oldCurve, this.curve, !oldCurveESet));
        }
    }

    public void unsetCurve() {
        boolean oldCurve = this.curve;
        boolean oldCurveESet = this.curveESet;
        this.curve = false;
        this.curveESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 15, oldCurve, false, oldCurveESet));
        }
    }

    public boolean isSetCurve() {
        return this.curveESet;
    }

    public ColorDefinition getShadowColor() {
        return this.shadowColor;
    }

    public NotificationChain basicSetShadowColor(ColorDefinition newShadowColor, NotificationChain msgs) {
        ColorDefinition oldShadowColor = this.shadowColor;
        this.shadowColor = newShadowColor;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 16, (Object)oldShadowColor, (Object)newShadowColor);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setShadowColor(ColorDefinition newShadowColor) {
        if (newShadowColor != this.shadowColor) {
            NotificationChain msgs = null;
            if (this.shadowColor != null) {
                msgs = ((InternalEObject)this.shadowColor).eInverseRemove((InternalEObject)this, -17, null, msgs);
            }
            if (newShadowColor != null) {
                msgs = ((InternalEObject)newShadowColor).eInverseAdd((InternalEObject)this, -17, null, msgs);
            }
            if ((msgs = this.basicSetShadowColor(newShadowColor, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, (Object)newShadowColor, (Object)newShadowColor));
        }
    }

    public boolean isConnectMissingValue() {
        return this.connectMissingValue;
    }

    public void setConnectMissingValue(boolean newConnectMissingValue) {
        boolean oldConnectMissingValue = this.connectMissingValue;
        this.connectMissingValue = newConnectMissingValue;
        boolean oldConnectMissingValueESet = this.connectMissingValueESet;
        this.connectMissingValueESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, oldConnectMissingValue, this.connectMissingValue, !oldConnectMissingValueESet));
        }
    }

    public void unsetConnectMissingValue() {
        boolean oldConnectMissingValue = this.connectMissingValue;
        boolean oldConnectMissingValueESet = this.connectMissingValueESet;
        this.connectMissingValue = true;
        this.connectMissingValueESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 17, oldConnectMissingValue, true, oldConnectMissingValueESet));
        }
    }

    public boolean isSetConnectMissingValue() {
        return this.connectMissingValueESet;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 11: {
                return ((InternalEList)this.getMarkers()).basicRemove((Object)otherEnd, msgs);
            }
            case 12: {
                return this.basicSetMarker(null, msgs);
            }
            case 13: {
                return this.basicSetLineAttributes(null, msgs);
            }
            case 16: {
                return this.basicSetShadowColor(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return this.getMarkers();
            }
            case 12: {
                return this.getMarker();
            }
            case 13: {
                return this.getLineAttributes();
            }
            case 14: {
                return this.isPaletteLineColor() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 15: {
                return this.isCurve() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return this.getShadowColor();
            }
            case 17: {
                return this.isConnectMissingValue() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.getMarkers().clear();
                this.getMarkers().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.setMarker((Marker)newValue);
                return;
            }
            case 13: {
                this.setLineAttributes((LineAttributes)newValue);
                return;
            }
            case 14: {
                this.setPaletteLineColor((Boolean)newValue);
                return;
            }
            case 15: {
                this.setCurve((Boolean)newValue);
                return;
            }
            case 16: {
                this.setShadowColor((ColorDefinition)newValue);
                return;
            }
            case 17: {
                this.setConnectMissingValue((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.getMarkers().clear();
                return;
            }
            case 12: {
                this.setMarker(null);
                return;
            }
            case 13: {
                this.setLineAttributes(null);
                return;
            }
            case 14: {
                this.unsetPaletteLineColor();
                return;
            }
            case 15: {
                this.unsetCurve();
                return;
            }
            case 16: {
                this.setShadowColor(null);
                return;
            }
            case 17: {
                this.unsetConnectMissingValue();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return this.markers != null && !this.markers.isEmpty();
            }
            case 12: {
                return this.marker != null;
            }
            case 13: {
                return this.lineAttributes != null;
            }
            case 14: {
                return this.isSetPaletteLineColor();
            }
            case 15: {
                return this.isSetCurve();
            }
            case 16: {
                return this.shadowColor != null;
            }
            case 17: {
                return this.isSetConnectMissingValue();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (paletteLineColor: ");
        if (this.paletteLineColorESet) {
            result.append(this.paletteLineColor);
        } else {
            result.append("<unset>");
        }
        result.append(", curve: ");
        if (this.curveESet) {
            result.append(this.curve);
        } else {
            result.append("<unset>");
        }
        result.append(", connectMissingValue: ");
        if (this.connectMissingValueESet) {
            result.append(this.connectMissingValue);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public boolean canParticipateInCombination() {
        return true;
    }

    public void translateFrom(Series series, int iSeriesDefinitionIndex, Chart chart) {
        this.getLineAttributes().setVisible(true);
        this.getLineAttributes().setColor(ColorDefinitionImpl.BLACK());
        if (!(series instanceof ScatterSeries)) {
            this.getMarkers().clear();
            Marker marker = AttributeFactory.eINSTANCE.createMarker();
            marker.setSize(4);
            marker.setType(MarkerType.BOX_LITERAL);
            marker.setVisible(true);
            this.getMarkers().add((Object)marker);
        } else {
            this.getMarkers().clear();
            this.getMarkers().addAll((Collection)((ScatterSeries)series).getMarkers());
        }
        this.setLabel(series.getLabel());
        if (((Object)((Object)series.getLabelPosition())).equals((Object)Position.INSIDE_LITERAL) || ((Object)((Object)series.getLabelPosition())).equals((Object)Position.OUTSIDE_LITERAL)) {
            this.setLabelPosition(Position.ABOVE_LITERAL);
        } else {
            this.setLabelPosition(series.getLabelPosition());
        }
        this.setVisible(series.isVisible());
        this.setStacked(series.isStacked());
        if (series.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_Triggers())) {
            this.getTriggers().addAll((Collection)series.getTriggers());
        }
        if (series.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_DataPoint())) {
            this.setDataPoint(series.getDataPoint());
        }
        if (series.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_DataDefinition())) {
            this.getDataDefinition().add(series.getDataDefinition().get(0));
        }
        if (series instanceof StockSeries) {
            this.getLineAttributes().setColor(((StockSeries)series).getLineAttributes().getColor());
        }
        if (!(chart instanceof ChartWithAxes)) {
            throw new IllegalArgumentException(Messages.getString("error.invalid.argument.for.lineSeries", new Object[]{chart.getClass().getName()}, ULocale.getDefault()));
        }
        ((Axis)((ChartWithAxes)chart).getAxes().get(0)).setCategoryAxis(true);
        chart.setSampleData(this.getConvertedSampleData(chart.getSampleData(), iSeriesDefinitionIndex));
    }

    private SampleData getConvertedSampleData(SampleData currentSampleData, int iSeriesDefinitionIndex) {
        EList osdList = currentSampleData.getOrthogonalSampleData();
        int i = 0;
        while (i < osdList.size()) {
            if (i == iSeriesDefinitionIndex) {
                OrthogonalSampleData osd = (OrthogonalSampleData)osdList.get(i);
                osd.setDataSetRepresentation(this.getConvertedOrthogonalSampleDataRepresentation(osd.getDataSetRepresentation()));
                currentSampleData.getOrthogonalSampleData().set(i, (Object)osd);
            }
            ++i;
        }
        return currentSampleData;
    }

    private String getConvertedOrthogonalSampleDataRepresentation(String sOldRepresentation) {
        StringTokenizer strtok = new StringTokenizer(sOldRepresentation, ",");
        StringBuffer sbNewRepresentation = new StringBuffer("");
        while (strtok.hasMoreTokens()) {
            String sElement = strtok.nextToken().trim();
            if (sElement.startsWith("H")) {
                StringTokenizer strStockTokenizer = new StringTokenizer(sElement);
                sbNewRepresentation.append(strStockTokenizer.nextToken().trim().substring(1));
            } else {
                sbNewRepresentation.append(sElement);
            }
            sbNewRepresentation.append(",");
        }
        return sbNewRepresentation.toString().substring(0, sbNewRepresentation.length() - 1);
    }

    public final boolean canShareAxisUnit() {
        return true;
    }

    public static Series create() {
        LineSeries ls = TypeFactory.eINSTANCE.createLineSeries();
        ((LineSeriesImpl)ls).initialize();
        return ls;
    }

    protected void initialize() {
        super.initialize();
        LineAttributes lia = AttributeFactory.eINSTANCE.createLineAttributes();
        ((LineAttributesImpl)lia).set(ColorDefinitionImpl.BLACK(), LineStyle.SOLID_LITERAL, 1);
        lia.setVisible(true);
        this.setLineAttributes(lia);
        this.setLabelPosition(Position.ABOVE_LITERAL);
        Marker m = AttributeFactory.eINSTANCE.createMarker();
        m.setType(MarkerType.BOX_LITERAL);
        m.setSize(4);
        m.setVisible(true);
        this.getMarkers().add((Object)m);
    }

    public boolean canBeStacked() {
        return true;
    }

    public String getDisplayName() {
        return Messages.getString("LineSeriesImpl.displayName");
    }
}

