/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.equinox.internal.app.AppCommands;
import org.eclipse.equinox.internal.app.AppPersistence;
import org.eclipse.equinox.internal.app.CommandLineArgs;
import org.eclipse.equinox.internal.app.EclipseAppContainer;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer {
    public static final String PI_APP = "org.eclipse.equinox.app";
    public static boolean DEBUG = false;
    private static BundleContext context;
    private static PackageAdmin packageAdmin;
    private static EclipseAppContainer container;
    private static ServiceTracker frameworkLog;
    private ServiceTracker registryTracker;
    private IExtensionRegistry registry;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public void start(BundleContext bc) {
        ServiceReference ref;
        context = bc;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ref = context.getServiceReference(clazz.getName())) != null) {
            packageAdmin = (PackageAdmin)context.getService(ref);
        }
        this.getDebugOptions(context);
        this.processCommandLineArgs();
        AppPersistence.start(context);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.runtime.IExtensionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registryTracker = new ServiceTracker(context, clazz2.getName(), (ServiceTrackerCustomizer)this);
        this.registryTracker.open();
        try {
            AppCommands.create(context);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
    }

    public void stop(BundleContext bc) {
        try {
            AppCommands.destroy(context);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        this.registryTracker.close();
        this.registryTracker = null;
        AppPersistence.stop();
        if (frameworkLog != null) {
            frameworkLog.close();
            frameworkLog = null;
        }
        packageAdmin = null;
        context = null;
    }

    private void getDebugOptions(BundleContext context) {
        ServiceReference debugRef;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((debugRef = context.getServiceReference(clazz.getName())) == null) {
            return;
        }
        DebugOptions debugOptions = (DebugOptions)context.getService(debugRef);
        DEBUG = debugOptions.getBooleanOption("org.eclipse.equinox.app/debug", false);
        context.ungetService(debugRef);
    }

    private void processCommandLineArgs() {
        ServiceReference infoRef;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((infoRef = context.getServiceReference(clazz.getName())) == null) {
            return;
        }
        EnvironmentInfo envInfo = (EnvironmentInfo)context.getService(infoRef);
        if (envInfo == null) {
            return;
        }
        String[] args = envInfo.getNonFrameworkArgs();
        context.ungetService(infoRef);
        CommandLineArgs.processCommandLine(args);
    }

    public Object addingService(ServiceReference reference) {
        if (container != null) {
            return null;
        }
        Object service = context.getService(reference);
        if (this.registry == null && service instanceof IExtensionRegistry) {
            this.registry = (IExtensionRegistry)service;
            container = new EclipseAppContainer(context, this.registry);
            container.start();
            return service;
        }
        context.ungetService(reference);
        return null;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        if (service == this.registry) {
            this.registry = null;
        }
        if (container == null) {
            return;
        }
        container.stop();
        container = null;
    }

    static void openTracker(final ServiceTracker tracker, final boolean allServices) {
        if (System.getSecurityManager() == null) {
            tracker.open(allServices);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    tracker.open(allServices);
                    return null;
                }
            });
        }
    }

    static Object getService(final ServiceTracker tracker) {
        if (System.getSecurityManager() == null) {
            return tracker.getService();
        }
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return tracker.getService();
            }
        });
    }

    static String getLocation(final Bundle bundle) {
        if (System.getSecurityManager() == null) {
            return bundle.getLocation();
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return bundle.getLocation();
            }
        });
    }

    static Bundle getBundle(IContributor contributor) {
        if (contributor instanceof RegistryContributor) {
            try {
                long id = Long.parseLong(((RegistryContributor)contributor).getActualId());
                if (context != null) {
                    return context.getBundle(id);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(contributor.getName(), null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    static BundleContext getContext() {
        return context;
    }

    public static EclipseAppContainer getContainer() {
        return container;
    }

    static void log(FrameworkLogEntry entry) {
        BundleContext bc = context;
        if (bc == null) {
            return;
        }
        ServiceReference ref = null;
        try {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((ref = bc.getServiceReference(clazz.getName())) == null) {
                return;
            }
            FrameworkLog log = (FrameworkLog)context.getService(ref);
            if (log != null) {
                log.log(entry);
            }
        }
        finally {
            if (ref != null) {
                bc.ungetService(ref);
            }
        }
    }
}

