/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de;

import java.util.logging.Level;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.IMeasureViewConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

public class MeasureViewHandle
extends AbstractCrosstabItemHandle
implements IMeasureViewConstants,
ICrosstabConstants {
    MeasureViewHandle(DesignElementHandle handle) {
        super(handle);
    }

    public MeasureHandle getCubeMeasure() {
        return (MeasureHandle)this.handle.getElementProperty("measure");
    }

    public String getCubeMeasureName() {
        return this.handle.getStringProperty("measure");
    }

    public String getDataType() {
        MeasureHandle cubeMeasure = this.getCubeMeasure();
        return cubeMeasure == null ? null : cubeMeasure.getDataType();
    }

    PropertyHandle getAggregationsProperty() {
        return this.handle.getPropertyHandle("aggregations");
    }

    PropertyHandle getDetailProperty() {
        return this.handle.getPropertyHandle("detail");
    }

    PropertyHandle getHeaderProperty() {
        return this.handle.getPropertyHandle("header");
    }

    public CrosstabCellHandle getCell() {
        PropertyHandle propHandle = this.getDetailProperty();
        return propHandle.getContentCount() == 0 ? null : (CrosstabCellHandle)CrosstabUtil.getReportItem(propHandle.getContent(0), "CrosstabCell");
    }

    public AggregationCellHandle addAggregation(String rowDimension, String rowLevel, String colDimension, String colLevel) throws SemanticException {
        AggregationCellHandle aggregation = this.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        if (aggregation != null) {
            logger.log(Level.INFO, Messages.getString("MeasureViewHandle.info.aggregation.already.exist"));
            return aggregation;
        }
        ExtendedItemHandle aggregationCell = CrosstabExtendedItemFactory.createAggregationCell(this.moduleHandle);
        if (aggregationCell != null) {
            CommandStack stack = this.getCommandStack();
            stack.startTrans(Messages.getString("MeasureViewHandle.msg.add.aggregation"));
            try {
                aggregationCell.setProperty("aggregationOnRow", (Object)rowLevel);
                aggregationCell.setProperty("aggregationOnColumn", (Object)colLevel);
                this.getAggregationsProperty().add((DesignElementHandle)aggregationCell);
            }
            catch (SemanticException e) {
                stack.rollback();
                throw e;
            }
            stack.commit();
        }
        return (AggregationCellHandle)CrosstabUtil.getReportItem((DesignElementHandle)aggregationCell);
    }

    public void removeAggregation(String rowDimension, String rowLevel, String colDimension, String colLevel) throws SemanticException {
        AggregationCellHandle cell = this.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        if (cell != null) {
            cell.handle.drop();
        }
    }

    public AggregationCellHandle getAggregationCell(String rowDimension, String rowLevel, String colDimension, String colLevel) {
        int count = this.getAggregationCount();
        if (count == 0) {
            return null;
        }
        DesignElementHandle found = null;
        int i = 0;
        while (i < count) {
            DesignElementHandle element = this.getAggregationsProperty().getContent(i);
            String row = element.getStringProperty("aggregationOnRow");
            String column = element.getStringProperty("aggregationOnColumn");
            if ((rowLevel != null && rowLevel.equals(row) || rowLevel == null && row == null) && (colLevel != null && colLevel.equals(column) || colLevel == null && column == null)) {
                found = element;
                break;
            }
            ++i;
        }
        return (AggregationCellHandle)CrosstabUtil.getReportItem(found, "AggregationCell");
    }

    public int getAggregationCount() {
        return this.getAggregationsProperty().getContentCount();
    }

    public AggregationCellHandle getAggregationCell(int index) {
        DesignElementHandle element = this.getAggregationsProperty().getContent(index);
        return (AggregationCellHandle)CrosstabUtil.getReportItem(element, "AggregationCell");
    }

    public void removeAggregation(int index) throws SemanticException {
        this.getAggregationsProperty().drop(index);
    }

    public int getIndex() {
        return this.handle.getIndex();
    }

    public CrosstabCellHandle getHeader() {
        DesignElementHandle headerCell = this.getHeaderCell();
        return (CrosstabCellHandle)(headerCell == null ? null : CrosstabUtil.getReportItem(headerCell, "CrosstabCell"));
    }

    private DesignElementHandle getHeaderCell() {
        PropertyHandle propHandle = this.getHeaderProperty();
        if (propHandle.getContentCount() <= 0) {
            return null;
        }
        return propHandle.getContent(0);
    }

    public void removeHeader() throws SemanticException {
        DesignElementHandle headerCell = this.getHeaderCell();
        if (headerCell != null) {
            headerCell.drop();
        }
    }

    public void addHeader() throws SemanticException {
        PropertyHandle propHandle = this.getHeaderProperty();
        if (propHandle.getContentCount() > 0) {
            logger.log(Level.INFO, "Measure header is set, need not add another");
            return;
        }
        ExtendedItemHandle headerCell = CrosstabExtendedItemFactory.createCrosstabCell(this.moduleHandle);
        propHandle.add((DesignElementHandle)headerCell);
    }
}

