/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsWriter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Posting;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosWriter;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.index.TermVectorsWriter;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;

final class DocumentWriter {
    private Analyzer analyzer;
    private Directory directory;
    private Similarity similarity;
    private FieldInfos fieldInfos;
    private int maxFieldLength;
    private int termIndexInterval = 128;
    private PrintStream infoStream;
    private final Hashtable postingTable = new Hashtable();
    private int[] fieldLengths;
    private int[] fieldPositions;
    private int[] fieldOffsets;
    private float[] fieldBoosts;
    private final Term termBuffer = new Term("", "");

    DocumentWriter(Directory directory, Analyzer analyzer, Similarity similarity, int maxFieldLength) {
        this.directory = directory;
        this.analyzer = analyzer;
        this.similarity = similarity;
        this.maxFieldLength = maxFieldLength;
    }

    DocumentWriter(Directory directory, Analyzer analyzer, IndexWriter writer) {
        this.directory = directory;
        this.analyzer = analyzer;
        this.similarity = writer.getSimilarity();
        this.maxFieldLength = writer.getMaxFieldLength();
        this.termIndexInterval = writer.getTermIndexInterval();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void addDocument(String segment, Document doc) throws IOException {
        this.fieldInfos = new FieldInfos();
        this.fieldInfos.add(doc);
        this.fieldInfos.write(this.directory, String.valueOf(segment) + ".fnm");
        FieldsWriter fieldsWriter = new FieldsWriter(this.directory, segment, this.fieldInfos);
        try {
            fieldsWriter.addDocument(doc);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            fieldsWriter.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        fieldsWriter.close();
        this.postingTable.clear();
        this.fieldLengths = new int[this.fieldInfos.size()];
        this.fieldPositions = new int[this.fieldInfos.size()];
        this.fieldOffsets = new int[this.fieldInfos.size()];
        this.fieldBoosts = new float[this.fieldInfos.size()];
        Arrays.fill(this.fieldBoosts, doc.getBoost());
        this.invertDocument(doc);
        Posting[] postings = this.sortPostingTable();
        this.writePostings(postings, segment);
        this.writeNorms(segment);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void invertDocument(Document doc) throws IOException {
        Enumeration fields = doc.fields();
        while (fields.hasMoreElements()) {
            Field field = (Field)fields.nextElement();
            String fieldName = field.name();
            int fieldNumber = this.fieldInfos.fieldNumber(fieldName);
            int length = this.fieldLengths[fieldNumber];
            int position = this.fieldPositions[fieldNumber];
            if (length > 0) {
                position += this.analyzer.getPositionIncrementGap(fieldName);
            }
            int offset = this.fieldOffsets[fieldNumber];
            if (!field.isIndexed()) continue;
            if (!field.isTokenized()) {
                String stringValue = field.stringValue();
                if (field.isStoreOffsetWithTermVector()) {
                    this.addPosition(fieldName, stringValue, position++, new TermVectorOffsetInfo(offset, offset + stringValue.length()));
                } else {
                    this.addPosition(fieldName, stringValue, position++, null);
                }
                offset += stringValue.length();
            } else {
                Object var13_13;
                Reader reader;
                if (field.readerValue() != null) {
                    reader = field.readerValue();
                } else {
                    if (field.stringValue() == null) {
                        throw new IllegalArgumentException("field must have either String or Reader value");
                    }
                    reader = new StringReader(field.stringValue());
                }
                TokenStream stream = this.analyzer.tokenStream(fieldName, reader);
                try {
                    Token lastToken = null;
                    Token t = stream.next();
                    while (t != null) {
                        position += t.getPositionIncrement() - 1;
                        if (field.isStoreOffsetWithTermVector()) {
                            this.addPosition(fieldName, t.termText(), position++, new TermVectorOffsetInfo(offset + t.startOffset(), offset + t.endOffset()));
                        } else {
                            this.addPosition(fieldName, t.termText(), position++, null);
                        }
                        lastToken = t;
                        if (++length > this.maxFieldLength) {
                            if (this.infoStream == null) break;
                            this.infoStream.println("maxFieldLength " + this.maxFieldLength + " reached, ignoring following tokens");
                            break;
                        }
                        t = stream.next();
                    }
                    if (lastToken != null) {
                        offset += lastToken.endOffset() + 1;
                    }
                }
                catch (Throwable throwable) {
                    var13_13 = null;
                    stream.close();
                    throw throwable;
                }
                {
                    var13_13 = null;
                }
                stream.close();
            }
            this.fieldLengths[fieldNumber] = ++length;
            this.fieldPositions[fieldNumber] = position;
            int n = fieldNumber;
            this.fieldBoosts[n] = this.fieldBoosts[n] * field.getBoost();
            this.fieldOffsets[fieldNumber] = offset;
        }
        return;
    }

    private final void addPosition(String field, String text, int position, TermVectorOffsetInfo offset) {
        this.termBuffer.set(field, text);
        Posting ti = (Posting)this.postingTable.get(this.termBuffer);
        if (ti != null) {
            int i;
            int freq = ti.freq;
            if (ti.positions.length == freq) {
                int[] newPositions = new int[freq * 2];
                int[] positions = ti.positions;
                i = 0;
                while (i < freq) {
                    newPositions[i] = positions[i];
                    ++i;
                }
                ti.positions = newPositions;
            }
            ti.positions[freq] = position;
            if (offset != null) {
                if (ti.offsets.length == freq) {
                    TermVectorOffsetInfo[] newOffsets = new TermVectorOffsetInfo[freq * 2];
                    TermVectorOffsetInfo[] offsets = ti.offsets;
                    i = 0;
                    while (i < freq) {
                        newOffsets[i] = offsets[i];
                        ++i;
                    }
                    ti.offsets = newOffsets;
                }
                ti.offsets[freq] = offset;
            }
            ti.freq = freq + 1;
        } else {
            Term term = new Term(field, text, false);
            this.postingTable.put(term, new Posting(term, position, offset));
        }
    }

    private final Posting[] sortPostingTable() {
        Posting[] array = new Posting[this.postingTable.size()];
        Enumeration postings = this.postingTable.elements();
        int i = 0;
        while (postings.hasMoreElements()) {
            array[i] = (Posting)postings.nextElement();
            ++i;
        }
        DocumentWriter.quickSort(array, 0, array.length - 1);
        return array;
    }

    private static final void quickSort(Posting[] postings, int lo, int hi) {
        int right;
        int left;
        Posting tmp;
        if (lo >= hi) {
            return;
        }
        int mid = (lo + hi) / 2;
        if (postings[lo].term.compareTo(postings[mid].term) > 0) {
            tmp = postings[lo];
            postings[lo] = postings[mid];
            postings[mid] = tmp;
        }
        if (postings[mid].term.compareTo(postings[hi].term) > 0) {
            tmp = postings[mid];
            postings[mid] = postings[hi];
            postings[hi] = tmp;
            if (postings[lo].term.compareTo(postings[mid].term) > 0) {
                Posting tmp2 = postings[lo];
                postings[lo] = postings[mid];
                postings[mid] = tmp2;
            }
        }
        if ((left = lo + 1) >= (right = hi - 1)) {
            return;
        }
        Term partition = postings[mid].term;
        while (true) {
            if (postings[right].term.compareTo(partition) > 0) {
                --right;
                continue;
            }
            while (left < right && postings[left].term.compareTo(partition) <= 0) {
                ++left;
            }
            if (left >= right) break;
            Posting tmp2 = postings[left];
            postings[left] = postings[right];
            postings[right] = tmp2;
            --right;
        }
        DocumentWriter.quickSort(postings, lo, left);
        DocumentWriter.quickSort(postings, left + 1, hi);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writePostings(Posting[] postings, String segment) throws IOException {
        block42: {
            block41: {
                block40: {
                    block39: {
                        freq = null;
                        prox = null;
                        tis = null;
                        termVectorWriter = null;
                        try {
                            freq = this.directory.createOutput(String.valueOf(segment) + ".frq");
                            prox = this.directory.createOutput(String.valueOf(segment) + ".prx");
                            tis = new TermInfosWriter(this.directory, segment, this.fieldInfos, this.termIndexInterval);
                            ti = new TermInfo();
                            currentField = null;
                            i = 0;
                            while (true) {
                                block34: {
                                    block43: {
                                        if (i < postings.length) break block43;
                                        if (termVectorWriter != null) {
                                            termVectorWriter.closeDocument();
                                        }
                                        break;
                                    }
                                    posting = postings[i];
                                    ti.set(1, freq.getFilePointer(), prox.getFilePointer(), -1);
                                    tis.add(posting.term, ti);
                                    postingFreq = posting.freq;
                                    if (postingFreq == 1) {
                                        freq.writeVInt(1);
                                    } else {
                                        freq.writeVInt(0);
                                        freq.writeVInt(postingFreq);
                                    }
                                    lastPosition = 0;
                                    positions = posting.positions;
                                    j = 0;
                                    while (true) {
                                        if (j >= postingFreq) {
                                            termField = posting.term.field();
                                            if (currentField != termField) {
                                                currentField = termField;
                                                fi = this.fieldInfos.fieldInfo(currentField);
                                                if (!fi.storeTermVector) break;
                                                if (termVectorWriter == null) {
                                                    termVectorWriter = new TermVectorsWriter(this.directory, segment, this.fieldInfos);
                                                    termVectorWriter.openDocument();
                                                }
                                                termVectorWriter.openField(currentField);
                                            }
                                            break block34;
                                        }
                                        position = positions[j];
                                        prox.writeVInt(position - lastPosition);
                                        lastPosition = position;
                                        ++j;
                                    }
                                    if (termVectorWriter != null) {
                                        termVectorWriter.closeField();
                                    }
                                }
                                if (termVectorWriter != null && termVectorWriter.isFieldOpen()) {
                                    termVectorWriter.addTerm(posting.term.text(), postingFreq, posting.positions, posting.offsets);
                                }
                                ++i;
                            }
                        }
                        catch (Throwable var17_18) {
                            block38: {
                                block37: {
                                    block36: {
                                        block35: {
                                            var16_19 = null;
                                            keep = null;
                                            if (freq != null) {
                                                try {
                                                    freq.close();
                                                }
                                                catch (IOException e) {
                                                    if (keep != null) break block35;
                                                    keep = e;
                                                }
                                            }
                                        }
                                        if (prox != null) {
                                            try {
                                                prox.close();
                                            }
                                            catch (IOException e) {
                                                if (keep != null) break block36;
                                                keep = e;
                                            }
                                        }
                                    }
                                    if (tis != null) {
                                        try {
                                            tis.close();
                                        }
                                        catch (IOException e) {
                                            if (keep != null) break block37;
                                            keep = e;
                                        }
                                    }
                                }
                                if (termVectorWriter != null) {
                                    try {
                                        termVectorWriter.close();
                                    }
                                    catch (IOException e) {
                                        if (keep != null) break block38;
                                        keep = e;
                                    }
                                }
                            }
                            if (keep != null) {
                                throw (IOException)keep.fillInStackTrace();
                            }
                            throw var17_18;
                        }
                        {
                            var16_20 = null;
                            keep = null;
                            if (freq == null) break block39;
                        }
                        ** try [egrp 1[TRYBLOCK] [2 : 387->394)] { 
lbl97:
                        // 1 sources

                        freq.close();
                        break block39;
lbl99:
                        // 1 sources

                        catch (IOException e) {
                            if (keep != null) break block39;
                            keep = e;
                        }
                    }
                    if (prox != null) {
                        ** try [egrp 2[TRYBLOCK] [3 : 410->418)] { 
lbl105:
                        // 1 sources

                        prox.close();
                        break block40;
lbl107:
                        // 1 sources

                        catch (IOException e) {
                            if (keep != null) break block40;
                            keep = e;
                        }
                    }
                }
                if (tis != null) {
                    ** try [egrp 3[TRYBLOCK] [4 : 434->442)] { 
lbl113:
                    // 1 sources

                    tis.close();
                    break block41;
lbl115:
                    // 1 sources

                    catch (IOException e) {
                        if (keep != null) break block41;
                        keep = e;
                    }
                }
            }
            if (termVectorWriter != null) {
                ** try [egrp 4[TRYBLOCK] [5 : 458->466)] { 
lbl121:
                // 1 sources

                termVectorWriter.close();
                break block42;
lbl123:
                // 1 sources

                catch (IOException e) {
                    if (keep != null) break block42;
                    keep = e;
                }
            }
        }
        if (keep != null) {
            throw (IOException)keep.fillInStackTrace();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeNorms(String segment) throws IOException {
        int n = 0;
        while (n < this.fieldInfos.size()) {
            FieldInfo fi = this.fieldInfos.fieldInfo(n);
            if (fi.isIndexed && !fi.omitNorms) {
                Object var6_6;
                float norm = this.fieldBoosts[n] * this.similarity.lengthNorm(fi.name, this.fieldLengths[n]);
                IndexOutput norms = this.directory.createOutput(String.valueOf(segment) + ".f" + n);
                try {
                    norms.writeByte(Similarity.encodeNorm(norm));
                }
                catch (Throwable throwable) {
                    var6_6 = null;
                    norms.close();
                    throw throwable;
                }
                {
                    var6_6 = null;
                }
                norms.close();
            }
            ++n;
        }
        return;
    }

    void setInfoStream(PrintStream infoStream) {
        this.infoStream = infoStream;
    }
}

