/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pdf;

import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfOutline;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.script.instance.IScriptStyle;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.script.internal.instance.StyleInstance;
import org.w3c.dom.css.CSSValue;

public class TOCHandler {
    private TOCNode root;
    private PdfOutline outline;
    private Set bookmarks;

    public TOCHandler(TOCNode root, PdfOutline outline, Set bookmarks) {
        this.root = root;
        this.outline = outline;
        this.bookmarks = bookmarks;
    }

    public TOCNode getTOCRoot() {
        return this.root;
    }

    public void createTOC() {
        this.createTOC(this.root, this.outline, this.bookmarks);
    }

    private void createTOC(TOCNode tocNode, PdfOutline pol, Set bookmarks) {
        if (tocNode == null || tocNode.getChildren() == null) {
            return;
        }
        Iterator i = tocNode.getChildren().iterator();
        while (i.hasNext()) {
            TOCNode node = (TOCNode)i.next();
            if (!bookmarks.contains(node.getBookmark())) continue;
            PdfOutline outline = new PdfOutline(pol, PdfAction.gotoLocalPage((String)node.getBookmark(), (boolean)false), node.getDisplayString());
            IScriptStyle style = node.getTOCStyle();
            if (style instanceof StyleInstance) {
                StyleInstance instance = (StyleInstance)style;
                CSSValue color = instance.getProperty(14);
                if (color != null && !color.equals(CSSValueConstants.BLACK_VALUE)) {
                    outline.setColor(PropertyUtil.getColor((CSSValue)color));
                }
                int styleValue = 0;
                CSSValue fontStyle = instance.getProperty(39);
                if (CSSValueConstants.OBLIQUE_VALUE.equals(fontStyle) || CSSValueConstants.ITALIC_VALUE.equals(fontStyle)) {
                    styleValue |= 2;
                }
                if (PropertyUtil.isBoldFont((CSSValue)instance.getProperty(27))) {
                    styleValue |= 1;
                }
                outline.setStyle(styleValue);
            }
            this.createTOC(node, outline, bookmarks);
        }
    }
}

