/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

public class XPathParserUtil {
    public static final String SLASH = "/";
    public static final String DOUBLE_SLASH = "//";
    public static final String EMPTY_STRING = "";
    public static final String WILDCARD_PREDICATE_NUMBER = "[\\d+]";
    public static final String RE_XPATH_WILDCARD = "\\Q*\\E";
    public static final String RE_OPENING_BRACKET = "\\Q[\\E";
    public static final String RE_CLOSING_BRACKET = "\\Q]\\E";
    public static final String RE_SQUARE_BRACKETS = "\\Q[\\E.+\\Q]\\E";
    public static final String RE_NODETEST_WITH_PREDICATE_NUM_AND_OPTIONAL_ATTR = ".+\\Q[\\E\\d+\\Q]\\E.*";
    public static final String RE_WITH_PREDICATE_ONLY = "\\Q[\\E.*\\Q]\\E";
    public static final String RE_PREDICATE_WILDCARD = "\\Q[\\E\\*\\Q]\\E";
    public static final String REPL_XPATH_WILDCARD = ".+";
    public static final String REPL_DOUBLE_SLASH = "(/|/.+/)";
    public static final String REPL_OPENING_BRACKET = "\\\\Q[\\\\E";
    public static final String REPL_CLOSING_BRACKET = "\\\\Q]\\\\E";

    public static boolean match(String string, String regex) {
        if (!XPathParserUtil.checkXPath(string, regex)) {
            return false;
        }
        if (!XPathParserUtil.checkStepLength(string, regex)) {
            return false;
        }
        if (!XPathParserUtil.checkLastStep(string, regex = XPathParserUtil.toMediatedRE(regex))) {
            return false;
        }
        regex = XPathParserUtil.toRE(regex);
        return string.matches(regex);
    }

    private static boolean checkXPath(String string, String regex) {
        if (regex == null || string == null) {
            return false;
        }
        if (!regex.startsWith(SLASH)) {
            return false;
        }
        if (string.equals(regex)) {
            return true;
        }
        return true;
    }

    private static boolean checkStepLength(String string, String regex) {
        boolean absolute;
        boolean bl = absolute = regex.indexOf(DOUBLE_SLASH) == -1;
        return !(absolute ? regex.split(SLASH).length != string.split(SLASH).length : (regex = regex.replaceAll(DOUBLE_SLASH, SLASH)).split(SLASH).length > string.split(SLASH).length);
    }

    private static String toMediatedRE(String regex) {
        regex = regex.replaceAll(RE_PREDICATE_WILDCARD, EMPTY_STRING);
        StringBuffer buffer = new StringBuffer((regex = regex.replaceAll(RE_XPATH_WILDCARD, REPL_XPATH_WILDCARD)).trim());
        int start = buffer.toString().startsWith(DOUBLE_SLASH) ? 2 : 1;
        int end = 0;
        String step = EMPTY_STRING;
        while (buffer.indexOf(SLASH, start) != -1) {
            end = buffer.indexOf(SLASH, start);
            step = buffer.toString().substring(start, end);
            if (!step.matches(RE_NODETEST_WITH_PREDICATE_NUM_AND_OPTIONAL_ATTR)) {
                buffer.replace(start, end, XPathParserUtil.qualifyStep(step));
                end += WILDCARD_PREDICATE_NUMBER.length();
            }
            start = (String.valueOf(buffer.toString().charAt(end + 1)).equals(SLASH) ? 2 : 1) + end;
        }
        step = buffer.toString().substring(start);
        if (!step.matches(RE_NODETEST_WITH_PREDICATE_NUM_AND_OPTIONAL_ATTR)) {
            buffer.replace(start, buffer.toString().length(), XPathParserUtil.qualifyStep(step));
        }
        return buffer.toString();
    }

    private static String qualifyStep(String step) {
        StringBuffer buffer = new StringBuffer(step);
        if (buffer.toString().matches(RE_WITH_PREDICATE_ONLY)) {
            buffer.insert(0, REPL_XPATH_WILDCARD);
        }
        buffer.insert(buffer.toString().replaceAll(RE_SQUARE_BRACKETS, EMPTY_STRING).length(), WILDCARD_PREDICATE_NUMBER);
        return buffer.toString();
    }

    private static boolean checkLastStep(String string, String regex) {
        String[] regexSplits;
        String[] stringSplits = string.substring(string.lastIndexOf(SLASH) + 1).split(RE_OPENING_BRACKET);
        return (stringSplits[0].equals((regexSplits = regex.substring(regex.lastIndexOf(SLASH) + 1).split(RE_OPENING_BRACKET))[0]) || regexSplits[0].equals(REPL_XPATH_WILDCARD)) && stringSplits.length == regexSplits.length;
    }

    private static String toRE(String regex) {
        regex = regex.replaceAll(DOUBLE_SLASH, REPL_DOUBLE_SLASH);
        regex = regex.replaceAll(RE_OPENING_BRACKET, REPL_OPENING_BRACKET);
        regex = regex.replaceAll(RE_CLOSING_BRACKET, REPL_CLOSING_BRACKET);
        return regex;
    }
}

