/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import java.util.ArrayList;

public class FontSelector {
    protected ArrayList fonts = new ArrayList();

    public void addFont(Font font) {
        if (font.getBaseFont() != null) {
            this.fonts.add(font);
            return;
        }
        BaseFont baseFont = font.getCalculatedBaseFont(true);
        Font font2 = new Font(baseFont, font.size(), font.getCalculatedStyle(), font.color());
        this.fonts.add(font2);
    }

    public Phrase process(String string) {
        int n = this.fonts.size();
        if (n == 0) {
            throw new IndexOutOfBoundsException("No font is defined.");
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        Font font = null;
        int n3 = -1;
        Phrase phrase = new Phrase();
        int n4 = 0;
        while (n4 < n2) {
            char c = cArray[n4];
            if (c == '\n' || c == '\r') {
                stringBuffer.append(c);
            } else {
                int n5 = 0;
                while (n5 < n) {
                    font = (Font)this.fonts.get(n5);
                    if (font.getBaseFont().charExists(c)) {
                        if (n3 == n5) {
                            stringBuffer.append(c);
                            break;
                        }
                        if (stringBuffer.length() > 0 && n3 != -1) {
                            Chunk chunk = new Chunk(stringBuffer.toString(), (Font)this.fonts.get(n3));
                            phrase.add(chunk);
                            stringBuffer = new StringBuffer();
                        }
                        stringBuffer.append(c);
                        n3 = n5;
                        break;
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        if (stringBuffer.length() > 0) {
            Chunk chunk = new Chunk(stringBuffer.toString(), (Font)this.fonts.get(n3));
            phrase.add(chunk);
        }
        return phrase;
    }
}

