/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.DataOutputStream;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.impl.ParameterAttribute;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentConstants;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentStreamSorter;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.toc.TOCTree;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ReportDocumentWriter
implements ReportDocumentConstants {
    private static Logger logger;
    protected IReportEngine engine;
    private IDocArchiveWriter archive;
    private String designName;
    private HashMap paramters = new HashMap();
    private HashMap globalVariables = new HashMap();
    private int checkpoint = 0;
    private long pageCount = 0L;
    private HashMap bookmarks = new HashMap();
    private TOCTree tocTree = null;
    private HashMap idToOffset = new HashMap();
    private HashMap bookmarkToOffset = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public ReportDocumentWriter(IReportEngine engine, IDocArchiveWriter archive) {
        this.engine = engine;
        this.archive = archive;
        try {
            archive.initialize();
            this.saveCoreStreams();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed in initializing the archive", e);
        }
    }

    public IDocArchiveWriter getArchive() {
        return this.archive;
    }

    public void close() {
        try {
            this.checkpoint = -1;
            this.saveCoreStreams();
            this.archive.setStreamSorter((IStreamSorter)new ReportDocumentStreamSorter());
            this.archive.finish();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed in close the archive", e);
        }
    }

    public String getName() {
        return this.archive.getName();
    }

    public void saveTOC(TOCTree tocTree) {
        this.tocTree = tocTree;
    }

    public void saveBookmarks(HashMap bookmarks) {
        if (bookmarks.isEmpty()) {
            return;
        }
        this.bookmarks = new HashMap();
        this.bookmarks.putAll(bookmarks);
    }

    /*
     * Exception decompiling
     */
    public void saveDesign(ReportRunnable runnable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 85->88)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void saveParamters(HashMap map) {
        this.paramters = new HashMap();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            ParameterAttribute valueObj = (ParameterAttribute)entry.getValue();
            Object value = valueObj.getValue();
            String display = valueObj.getDisplayText();
            this.paramters.put(key, new Object[]{value, display});
        }
    }

    public void savePersistentObjects(Map map) {
        this.globalVariables = new HashMap();
        this.globalVariables.putAll(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveCoreStreams() throws Exception {
        Object lock = this.archive.lock("/core");
        try {
            Object object = lock;
            synchronized (object) {
                this.doSaveCoreStreams();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.archive.unlock(lock);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.archive.unlock(lock);
    }

    /*
     * Exception decompiling
     */
    protected void doSaveCoreStreams() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 241->245)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeMap(DataOutputStream stream, HashMap map) throws Exception {
        if (map == null) {
            map = new HashMap();
        }
        IOUtil.writeLong((DataOutputStream)stream, (long)map.size());
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Long value = (Long)entry.getValue();
            IOUtil.writeString((DataOutputStream)stream, (String)key);
            IOUtil.writeLong((DataOutputStream)stream, (long)value);
        }
    }

    public void setPageCount(long pageCount) {
        this.pageCount = pageCount;
    }

    public void saveReprotletsBookmarkIndex(Map bookmarkToOffset) {
        this.bookmarkToOffset = new HashMap();
        this.bookmarkToOffset.putAll(bookmarkToOffset);
    }

    public void saveReportletsIdIndex(Map idToOffset) {
        this.idToOffset = new HashMap();
        this.idToOffset.putAll(idToOffset);
    }

    private String getBuildNumber() {
        Object version;
        Dictionary dict;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.birt.report.engine");
        if (bundle != null && (dict = bundle.getHeaders()) != null && (version = dict.get("Bundle-Version")) != null) {
            return version.toString();
        }
        return "UNKNOWN";
    }
}

