/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.content.wrap;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.internal.content.wrap.AbstractContentWrapper;

public class CellContentWrapper
extends AbstractContentWrapper
implements ICellContent {
    protected ICellContent cell;
    protected int rowSpan = -1;
    protected int colSpan = -1;
    protected int column = -1;
    protected int row = -1;

    public CellContentWrapper(ICellContent cell) {
        super(cell);
        this.cell = cell;
    }

    public int getRowSpan() {
        if (this.rowSpan != -1) {
            return this.rowSpan;
        }
        return this.cell.getRowSpan();
    }

    public int getColSpan() {
        if (this.colSpan != -1) {
            return this.colSpan;
        }
        return this.cell.getColSpan();
    }

    public int getColumn() {
        if (this.column != -1) {
            return this.column;
        }
        return this.cell.getColumn();
    }

    public int getRow() {
        if (this.row != -1) {
            return this.row;
        }
        return this.cell.getRow();
    }

    public Object accept(IContentVisitor visitor, Object value) {
        return visitor.visitCell(this, value);
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public boolean getDisplayGroupIcon() {
        return this.cell.getDisplayGroupIcon();
    }

    public void setDisplayGroupIcon(boolean isStartOfGroup) {
        this.cell.setDisplayGroupIcon(isStartOfGroup);
    }

    public IColumn getColumnInstance() {
        return this.cell.getColumnInstance();
    }
}

