/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.xpathparser.XPathParser;

public class XPathUtil {
    public static final String SLOT_NAME_PROPERTY = "slotName";
    public static final String RESOURCE_KEY_SUFFIX = "ID";
    private static final String EMPTY_STRING = "";
    private static final String SEPARATOR = "/";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.util.XPathUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static String getXPath(Object instance) {
        if (instance == null) {
            return EMPTY_STRING;
        }
        if (instance instanceof DesignElementHandle) {
            return XPathUtil.serializeToXPath((DesignElementHandle)instance);
        }
        if (instance instanceof SlotHandle) {
            SlotHandle slot = (SlotHandle)instance;
            return XPathUtil.serializeToXPath(slot);
        }
        if (instance instanceof StructureHandle) {
            return XPathUtil.serializeToXPath((StructureHandle)instance);
        }
        if (instance instanceof PropertyHandle) {
            return XPathUtil.serializeToXPath((PropertyHandle)instance);
        }
        return null;
    }

    public static Object getInstance(ModuleHandle module, String xpath) {
        return new XPathParser(module).getObject(xpath);
    }

    private static String serializeToXPath(SlotHandle slot) {
        StringBuffer sb = new StringBuffer();
        DesignElementHandle tmpElement = slot.getElementHandle();
        sb.append(XPathUtil.serializeToXPath(tmpElement));
        String slotInfo = slot.getDefn().getXmlName();
        slotInfo = StringUtil.isBlank(slotInfo) ? XPathUtil.formatXPathProperty(SLOT_NAME_PROPERTY, slot.getDefn().getName()) : SEPARATOR + slotInfo;
        sb.append(slotInfo);
        return sb.toString();
    }

    private static String serializeToXPath(PropertyHandle prop) {
        StringBuffer sb = new StringBuffer();
        DesignElementHandle tmpElement = prop.getElementHandle();
        sb.append(XPathUtil.serializeToXPath(tmpElement));
        sb.append(SEPARATOR);
        PropertyDefn tmpPropDefn = (PropertyDefn)prop.getDefn();
        if (tmpPropDefn.isList()) {
            sb.append("list-property");
            sb.append(XPathUtil.formatXPathProperty("name", tmpPropDefn.getName()));
            return sb.toString();
        }
        boolean isResourceKeyDefn = false;
        IPropertyDefn resourcePropDefn = XPathUtil.getResourceKeyDefn((ElementPropertyDefn)tmpPropDefn);
        if (resourcePropDefn != null) {
            isResourceKeyDefn = true;
        }
        if (!isResourceKeyDefn && !XPathUtil.isEnclosedAttr(tmpPropDefn.getName())) {
            sb.append(XPathUtil.getTagByPropertyType((ElementPropertyDefn)tmpPropDefn));
            sb.append(XPathUtil.formatXPathProperty("name", tmpPropDefn.getName()));
            return sb.toString();
        }
        if (!isResourceKeyDefn) {
            sb.append("@" + tmpPropDefn.getName());
            return sb.toString();
        }
        if (!$assertionsDisabled && resourcePropDefn == null) {
            throw new AssertionError();
        }
        sb.append(XPathUtil.getTagByPropertyType((ElementPropertyDefn)resourcePropDefn));
        sb.append(XPathUtil.formatXPathProperty("name", resourcePropDefn.getName()));
        if (resourcePropDefn != tmpPropDefn) {
            sb.append("/@key");
        }
        return sb.toString();
    }

    private static String serializeToXPath(StructureHandle prop) {
        StringBuffer sb = new StringBuffer();
        DesignElementHandle tmpElement = prop.getElementHandle();
        sb.append(XPathUtil.serializeToXPath(tmpElement));
        MemberRef memberRef = prop.getReference();
        PropertyDefn tmpPropDefn = memberRef.getPropDefn();
        if (!tmpPropDefn.isList() && tmpPropDefn.getStructDefn() != null) {
            sb.append("/structure" + XPathUtil.formatXPathProperty("name", tmpPropDefn.getName()));
            tmpPropDefn = memberRef.getMemberDefn();
        }
        if (tmpPropDefn.isList()) {
            sb.append("/list-property" + XPathUtil.formatXPathProperty("name", tmpPropDefn.getName()));
        }
        sb.append("/structure");
        if (!tmpPropDefn.isList()) {
            sb.append(XPathUtil.formatXPathProperty("name", prop.getDefn().getName()));
        } else {
            int index = memberRef.getIndex() + 1;
            sb.append("[" + index + "]");
        }
        return sb.toString();
    }

    private static String serializeToXPath(DesignElementHandle element) {
        DesignElementHandle container;
        DesignElementHandle tmpElement = element;
        StringBuffer sb = new StringBuffer();
        do {
            ElementDefn elementDefn = (ElementDefn)tmpElement.getDefn();
            container = tmpElement.getContainer();
            String slotInfo = null;
            String idInfo = EMPTY_STRING;
            if (container != null) {
                SlotHandle slot = tmpElement.getContainerSlotHandle();
                String slotTagName = slot.getDefn().getXmlName();
                if (!StringUtil.isBlank(slotTagName)) {
                    slotInfo = SEPARATOR + slotTagName;
                }
                if (slot.getCount() > 1) {
                    idInfo = XPathUtil.formatXPathProperty("id", Long.toString(tmpElement.getID()));
                }
            }
            String elementPath = EMPTY_STRING;
            if (!StringUtil.isBlank(slotInfo)) {
                elementPath = slotInfo;
            }
            elementPath = String.valueOf(elementPath) + SEPARATOR + elementDefn.getXmlName();
            elementPath = String.valueOf(elementPath) + idInfo;
            sb.insert(0, elementPath);
        } while ((tmpElement = container) != null);
        return sb.toString();
    }

    private static String formatXPathProperty(String propName, String propValue) {
        return "[@" + propName + "=\"" + propValue + "\"]";
    }

    private static boolean isEnclosedAttr(String propName) {
        return "name".equalsIgnoreCase(propName) || "extends".equalsIgnoreCase(propName) || "extensionName".equalsIgnoreCase(propName) || "extensionID".equalsIgnoreCase(propName);
    }

    private static String getTagByPropertyType(ElementPropertyDefn propDefn) {
        String tagName = ModelUtil.getTagByPropertyType(propDefn);
        if (!"property".equalsIgnoreCase(tagName)) {
            return tagName;
        }
        IPropertyDefn tmpPropDefn = XPathUtil.getResourceKeyDefn(propDefn);
        if (tmpPropDefn == null) {
            return tagName;
        }
        if (tmpPropDefn.getTypeCode() == 8) {
            return "html-property";
        }
        return "text-property";
    }

    private static IPropertyDefn getResourceKeyDefn(ElementPropertyDefn propDefn) {
        String propName = propDefn.getName();
        String otherPropName = EMPTY_STRING;
        ElementPropertyDefn tmpPropDefn = propDefn;
        boolean isKeyDefn = false;
        if (propName.endsWith(RESOURCE_KEY_SUFFIX)) {
            int index = propName.lastIndexOf(RESOURCE_KEY_SUFFIX);
            otherPropName = propName.substring(0, index);
            if (propDefn.getTypeCode() != 9) {
                return null;
            }
            isKeyDefn = true;
        } else {
            otherPropName = String.valueOf(propName) + RESOURCE_KEY_SUFFIX;
        }
        isKeyDefn = !isKeyDefn;
        tmpPropDefn = (ElementPropertyDefn)((ElementDefn)propDefn.definedBy()).getProperty(otherPropName);
        if (tmpPropDefn == null) {
            return null;
        }
        if (isKeyDefn && tmpPropDefn.getTypeCode() != 9) {
            return null;
        }
        return isKeyDefn ? propDefn : tmpPropDefn;
    }
}

