/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSourceAndDataSet;
import org.eclipse.birt.data.engine.executor.DiskDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.IncreDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.MemoryDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.cache.CacheUtil;
import org.eclipse.birt.data.engine.impl.IIncreCacheDataSetDesign;
import org.eclipse.birt.data.engine.odi.IResultClass;

class CacheMapManager {
    private static Map cacheMap = Collections.synchronizedMap(new HashMap());
    private Map cacheDirMap = new HashMap();
    private String tempDir;

    CacheMapManager(String tempDir) {
        this.tempDir = tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean doesSaveToCache(DataSourceAndDataSet dsAndDs, int mode, IBaseDataSourceDesign baseDataSourceDesign, IBaseDataSetDesign baseDataSetDesign, Collection parameterHints, Map appContext) throws DataException {
        String cacheObject = null;
        Map map = cacheMap;
        synchronized (map) {
            cacheObject = (String)cacheMap.get(dsAndDs);
        }
        if (cacheObject != null) {
            return this.needSaveToCache(cacheObject);
        }
        map = cacheMap;
        synchronized (map) {
            void var9_13;
            cacheObject = (String)cacheMap.get(dsAndDs);
            if (cacheObject != null) {
                return this.needSaveToCache(cacheObject);
            }
            Object var9_9 = null;
            String cacheDir = (String)this.cacheDirMap.get(baseDataSetDesign);
            if (baseDataSetDesign instanceof IIncreCacheDataSetDesign) {
                IncreDataSetCacheObject increDataSetCacheObject = new IncreDataSetCacheObject(cacheDir);
            } else {
                switch (mode) {
                    case 1: {
                        MemoryDataSetCacheObject memoryDataSetCacheObject = new MemoryDataSetCacheObject();
                        break;
                    }
                    case 2: {
                        String tempRootDir = CacheUtil.createTempRootDir(this.tempDir);
                        String sessionTempDir = CacheUtil.createSessionTempDir(tempRootDir);
                        DiskDataSetCacheObject diskDataSetCacheObject = new DiskDataSetCacheObject(sessionTempDir);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            cacheMap.put(dsAndDs, var9_13);
            return true;
        }
    }

    private boolean needSaveToCache(Object cacheObject) {
        if (cacheObject instanceof DiskDataSetCacheObject) {
            DiskDataSetCacheObject diskCacheObject = (DiskDataSetCacheObject)cacheObject;
            return !diskCacheObject.getDataFile().exists() || !diskCacheObject.getMetaFile().exists();
        }
        if (cacheObject instanceof MemoryDataSetCacheObject) {
            return ((MemoryDataSetCacheObject)cacheObject).needPopulateResult();
        }
        return cacheObject instanceof IncreDataSetCacheObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doesLoadFromCache(DataSourceAndDataSet dsAndDs) {
        Object cacheObject = null;
        Map map = cacheMap;
        synchronized (map) {
            cacheObject = cacheMap.get(dsAndDs);
        }
        if (cacheObject != null) {
            return cacheObject instanceof IncreDataSetCacheObject ? true : !this.needSaveToCache(cacheObject);
        }
        return false;
    }

    IDataSetCacheObject getCacheObject(DataSourceAndDataSet dsAndDs) {
        return (IDataSetCacheObject)cacheMap.get(dsAndDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache(DataSourceAndDataSet dsAndDs) {
        ArrayList cacheDir = new ArrayList();
        Map map = cacheMap;
        synchronized (map) {
            while (this.getKey(dsAndDs) != null) {
                cacheDir.add(cacheMap.remove(this.getKey(dsAndDs)));
            }
        }
        int i = 0;
        while (i < cacheDir.size()) {
            Object cacheObject = cacheDir.get(i);
            if (cacheObject instanceof DiskDataSetCacheObject) {
                DiskDataSetCacheObject diskObject = (DiskDataSetCacheObject)cacheObject;
                this.deleteDir(diskObject.getTempDir());
            } else if (cacheObject instanceof IncreDataSetCacheObject) {
                IncreDataSetCacheObject psObject = (IncreDataSetCacheObject)cacheObject;
                this.deleteDir(psObject.getCacheDir());
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetForTest() {
        CacheMapManager cacheMapManager = this;
        synchronized (cacheMapManager) {
            cacheMap = new HashMap();
        }
    }

    IResultClass getCachedResultClass(DataSourceAndDataSet dsAndDs) throws DataException {
        Object cacheObject = null;
        Object key = this.getKey(dsAndDs);
        if (key != null) {
            cacheObject = cacheMap.get(key);
        }
        if (cacheObject instanceof MemoryDataSetCacheObject) {
            return ((MemoryDataSetCacheObject)cacheObject).getResultClass();
        }
        if (cacheObject instanceof DiskDataSetCacheObject) {
            FileInputStream fis1 = null;
            BufferedInputStream bis1 = null;
            try {
                fis1 = new FileInputStream(((DiskDataSetCacheObject)cacheObject).getMetaFile());
                bis1 = new BufferedInputStream(fis1);
                IOUtil.readInt((InputStream)bis1);
                ResultClass rsClass = new ResultClass(bis1);
                bis1.close();
                fis1.close();
                return rsClass;
            }
            catch (FileNotFoundException e) {
                throw new DataException("data.engine.datasetcache.load.error", e);
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.load.error", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getKey(DataSourceAndDataSet dsAndDs) {
        Map map = cacheMap;
        synchronized (map) {
            Iterator it = cacheMap.keySet().iterator();
            while (it.hasNext()) {
                DataSourceAndDataSet temp = (DataSourceAndDataSet)it.next();
                if (!temp.isDataSourceDataSetEqual(dsAndDs, false)) continue;
                return temp;
            }
            return null;
        }
    }

    private void deleteDir(String dirStr) {
        File curDir = new File(dirStr);
        if (!curDir.exists()) {
            return;
        }
        File[] files = curDir.listFiles();
        int i = 0;
        while (i < files.length) {
            files[i].delete();
            ++i;
        }
        File parentDir = curDir.getParentFile();
        curDir.delete();
        parentDir.delete();
    }

    Map getCacheDirMap() {
        return this.cacheDirMap;
    }
}

