/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.aggregation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.Aggregation;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.cache.BasicCachedList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.impl.aggregation.AggrExprInfo;
import org.eclipse.birt.data.engine.impl.aggregation.JSAggrValueObject;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Scriptable;

class AggregateCalculator {
    private List[] aggrValues;
    private Object[][] aggrArgs;
    private List aggrExprInfoList;
    private int aggrCount;
    private IResultIterator odiResult;
    private AccumulatorManager[] accumulatorManagers;
    private Set invalidAggrSet;
    private Map invalidAggrMsg;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.aggregation.AggregateCalculator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.aggregation.AggregateCalculator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    AggregateCalculator(List aggrExprInfoList, IResultIterator odiResult) {
        Class<?> clazz;
        Object[] params = new Object[]{aggrExprInfoList, odiResult};
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.aggregation.AggregateCalculator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz2.getName(), "AggregateCalculator", params);
        if (!$assertionsDisabled && aggrExprInfoList == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && odiResult == null) {
            throw new AssertionError();
        }
        this.aggrExprInfoList = aggrExprInfoList;
        this.odiResult = odiResult;
        this.aggrCount = aggrExprInfoList.size();
        if (this.aggrCount > 0) {
            this.aggrValues = new List[this.aggrCount];
            this.aggrArgs = new Object[this.aggrCount][];
            int i = 0;
            while (i < this.aggrCount) {
                this.aggrValues[i] = new BasicCachedList();
                AggrExprInfo aggrInfo = this.getAggrInfo(i);
                this.aggrArgs[i] = new Object[aggrInfo.aggregation.getParameterDefn().length];
                ++i;
            }
            this.accumulatorManagers = new AccumulatorManager[this.aggrCount];
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.aggregation.AggregateCalculator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz.getName(), "AggregateCalculator");
    }

    void calculate(Scriptable scope) throws DataException {
        ArrayList<Integer> validAggregations = new ArrayList<Integer>();
        boolean[] populateAggrValue = new boolean[this.aggrCount];
        int count = 1;
        int i = 0;
        while (i < this.aggrCount) {
            validAggregations.add(new Integer(i));
            populateAggrValue[i] = !(this.getAggrInfo((int)i).aggregation instanceof Aggregation) || ((Aggregation)this.getAggrInfo((int)i).aggregation).getNumberOfPasses() <= 1;
            this.accumulatorManagers[i] = new AccumulatorManager(this.getAggrInfo((int)i).aggregation);
            ++i;
        }
        while (validAggregations.size() > 0) {
            int[] validAggregationArray = new int[validAggregations.size()];
            int i2 = 0;
            while (i2 < validAggregations.size()) {
                validAggregationArray[i2] = (Integer)validAggregations.get(i2);
                ++i2;
            }
            if (!$assertionsDisabled && this.odiResult.getCurrentResultIndex() != 0) {
                throw new AssertionError();
            }
            if (this.odiResult.getCurrentResult() == null) {
                return;
            }
            this.pass(scope, populateAggrValue, validAggregationArray);
            this.odiResult.first(0);
            this.prepareNextIteration(validAggregations, populateAggrValue, ++count);
        }
    }

    private void pass(Scriptable scope, boolean[] populateAggrValue, int[] validAggregationArray) throws DataException {
        do {
            int startingGroupLevel = this.odiResult.getStartingGroupLevel();
            int endingGroupLevel = this.odiResult.getEndingGroupLevel();
            int i = 0;
            while (i < validAggregationArray.length) {
                int index = validAggregationArray[i];
                if (this.invalidAggrSet != null && this.invalidAggrSet.contains(new Integer(index))) {
                    this.addInvalidAggrMsg(index, endingGroupLevel);
                } else if (!this.onRow(index, startingGroupLevel, endingGroupLevel, scope, populateAggrValue[index])) {
                    this.addInvalidAggrMsg(index, endingGroupLevel);
                    if (this.invalidAggrSet == null) {
                        this.invalidAggrSet = new HashSet();
                    }
                    this.invalidAggrSet.add(new Integer(index));
                }
                ++i;
            }
        } while (this.odiResult.next());
    }

    private void addInvalidAggrMsg(int index, int endingGroupLevel) {
        if (!$assertionsDisabled && this.invalidAggrMsg == null) {
            throw new AssertionError();
        }
        if (this.getAggrInfo((int)index).aggregation.getType() == 1 || endingGroupLevel <= this.getAggrInfo((int)index).groupLevel) {
            this.aggrValues[index].add(this.invalidAggrMsg.get(new Integer(index)));
        }
    }

    private boolean onRow(int aggrIndex, int startingGroupLevel, int endingGroupLevel, Scriptable scope, boolean populateValue) throws DataException {
        boolean isRunning;
        AggrExprInfo aggrInfo = this.getAggrInfo(aggrIndex);
        Accumulator acc = null;
        boolean newGroup = false;
        if (startingGroupLevel <= aggrInfo.groupLevel) {
            newGroup = true;
            acc = this.accumulatorManagers[aggrIndex].next();
            acc.start();
        } else {
            acc = this.accumulatorManagers[aggrIndex].getCurrentAccumulator();
        }
        boolean accepted = true;
        if (aggrInfo.filter != null) {
            try {
                Object filterResult = ExprEvaluateUtil.evaluateCompiledExpression(aggrInfo.filter, this.odiResult, scope);
                accepted = filterResult == null ? true : DataTypeUtil.toBoolean((Object)filterResult);
            }
            catch (BirtException e) {
                if (this.invalidAggrMsg == null) {
                    this.invalidAggrMsg = new HashMap();
                }
                this.invalidAggrMsg.put(new Integer(aggrIndex), e);
                return false;
            }
        }
        if (aggrInfo.calculateLevel > 0 && startingGroupLevel > aggrInfo.calculateLevel) {
            accepted = false;
        }
        if (accepted) {
            boolean[] argDefs = aggrInfo.aggregation.getParameterDefn();
            if (!$assertionsDisabled && argDefs.length != this.aggrArgs[aggrIndex].length) {
                throw new AssertionError();
            }
            try {
                int i = 0;
                while (i < argDefs.length) {
                    if (argDefs[i] || newGroup) {
                        CompiledExpression argExpr = aggrInfo.args[i];
                        this.aggrArgs[aggrIndex][i] = ExprEvaluateUtil.evaluateCompiledExpression(argExpr, this.odiResult, scope);
                    }
                    ++i;
                }
                acc.onRow(this.aggrArgs[aggrIndex]);
            }
            catch (DataException e) {
                if (this.invalidAggrMsg == null) {
                    this.invalidAggrMsg = new HashMap();
                }
                this.invalidAggrMsg.put(new Integer(aggrIndex), e);
                return false;
            }
        }
        boolean bl = isRunning = aggrInfo.aggregation.getType() == 1;
        if (isRunning && populateValue) {
            Object value = acc.getValue();
            this.aggrValues[aggrIndex].add(value);
        }
        if (endingGroupLevel <= aggrInfo.groupLevel) {
            acc.finish();
            if (!isRunning && populateValue) {
                Object value = acc.getValue();
                this.aggrValues[aggrIndex].add(value);
            }
        }
        return true;
    }

    private void prepareNextIteration(List validAggregations, boolean[] populateAggrValue, int count) {
        validAggregations.clear();
        int i = 0;
        while (i < this.aggrCount) {
            int passesNumber;
            this.accumulatorManagers[i].restart();
            IAggregation temp = this.getAggrInfo((int)i).aggregation;
            populateAggrValue[i] = false;
            if (temp instanceof Aggregation && count <= (passesNumber = ((Aggregation)temp).getNumberOfPasses())) {
                validAggregations.add(new Integer(i));
                if (count == passesNumber) {
                    populateAggrValue[i] = true;
                }
            }
            ++i;
        }
    }

    private AggrExprInfo getAggrInfo(int i) {
        return (AggrExprInfo)this.aggrExprInfoList.get(i);
    }

    Scriptable getJSAggrValueObject() {
        return new JSAggrValueObject(this.aggrExprInfoList, this.odiResult, this.aggrValues);
    }

    private class AccumulatorManager {
        private IAggregation aggregation;
        private int cursor;
        private List cachedAcc;
        private Accumulator accumulator;

        AccumulatorManager(IAggregation aggregation) {
            this.aggregation = aggregation;
            this.cursor = -1;
            int passNum = 0;
            if (aggregation instanceof Aggregation) {
                passNum = ((Aggregation)aggregation).getNumberOfPasses();
            }
            if (passNum < 2) {
                this.accumulator = aggregation.newAccumulator();
            } else {
                this.cachedAcc = new ArrayList();
            }
        }

        Accumulator getCurrentAccumulator() {
            if (this.accumulator != null) {
                return this.accumulator;
            }
            if (this.cachedAcc.size() == 0) {
                this.cachedAcc.add(this.aggregation.newAccumulator());
            }
            return (Accumulator)this.cachedAcc.get(this.cursor);
        }

        Accumulator next() {
            if (this.accumulator != null) {
                return this.accumulator;
            }
            ++this.cursor;
            if (this.cachedAcc.size() > this.cursor) {
                return (Accumulator)this.cachedAcc.get(this.cursor);
            }
            this.cachedAcc.add(this.aggregation.newAccumulator());
            return (Accumulator)this.cachedAcc.get(this.cursor);
        }

        void restart() {
            this.cursor = -1;
        }
    }
}

