/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.QueryResults;
import org.eclipse.birt.data.engine.impl.document.ResultIterator;

public class ResultIterator2
extends ResultIterator {
    private int lowestGroupLevel;
    private int currRowIndex;

    ResultIterator2(DataEngineContext context, IQueryResults queryResults, String queryResultID, int lowestGroupLevel) throws DataException {
        super(context, queryResults, queryResultID);
        this.lowestGroupLevel = lowestGroupLevel;
        this.currRowIndex = -1;
    }

    public ResultIterator2(DataEngineContext context, QueryResults queryResults, String queryResultID, String subQueryName, int currParentIndex, int lowestGroupLevel) throws DataException {
        super(context, queryResults, queryResultID, subQueryName, currParentIndex);
        this.lowestGroupLevel = lowestGroupLevel;
        this.currRowIndex = -1;
    }

    public boolean next() throws DataException {
        boolean hasNext = false;
        boolean shouldMoveForward = false;
        int index = this.exprResultSet.getCurrentIndex();
        if (this.exprResultSet.getCurrentIndex() >= 0) {
            this.exprResultSet.skipToEnd(this.lowestGroupLevel);
            if (this.exprResultSet.getCurrentIndex() != index) {
                shouldMoveForward = false;
                hasNext = this.exprResultSet.getCurrentIndex() >= 0;
            } else {
                shouldMoveForward = true;
            }
        } else {
            shouldMoveForward = true;
        }
        if (shouldMoveForward) {
            hasNext = super.next();
        }
        if (hasNext) {
            ++this.currRowIndex;
        }
        return hasNext;
    }

    public int getRowIndex() throws BirtException {
        return this.currRowIndex;
    }

    public void moveTo(int rowIndex) throws BirtException {
        if (rowIndex < 0 || rowIndex < this.currRowIndex) {
            throw new DataException("data.engine.invalidRowIndex", new Integer(rowIndex));
        }
        if (rowIndex == this.currRowIndex) {
            return;
        }
        int gapRows = rowIndex - this.currRowIndex;
        int i = 0;
        while (i < gapRows) {
            if (!this.next()) {
                throw new DataException("data.engine.invalidRowIndex", new Integer(rowIndex));
            }
            ++i;
        }
    }
}

