/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.cursor.CubeCursorImpl;
import org.eclipse.birt.data.engine.olap.driver.IResultSet;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.query.view.BirtEdgeView;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.query.view.MeasureNameManager;
import org.eclipse.birt.data.engine.olap.query.view.QueryExecutor;

public class BirtCubeView {
    private ICubeQueryDefinition queryDefn;
    private BirtEdgeView columnEdgeView;
    private BirtEdgeView rowEdgeView;
    private BirtEdgeView[] calculatedMemberView;
    private MeasureNameManager manager;
    private CubeQueryExecutor executor;
    private Map appContext;

    public BirtCubeView(CubeQueryExecutor queryExecutor, Map appContext) throws DataException {
        this.queryDefn = queryExecutor.getCubeQueryDefinition();
        this.columnEdgeView = this.createBirtEdgeView(this.queryDefn.getEdge(2));
        this.rowEdgeView = this.createBirtEdgeView(this.queryDefn.getEdge(1));
        this.executor = queryExecutor;
        this.appContext = appContext;
        CalculatedMember[] members = CubeQueryDefinitionUtil.getCalculatedMembers(this.queryDefn, queryExecutor.getSession().getSharedScope());
        if (members != null && members.length > 0) {
            HashSet<Integer> rsIDSet = new HashSet<Integer>();
            this.calculatedMemberView = new BirtEdgeView[members.length];
            int index = 0;
            int i = 0;
            while (i < members.length) {
                if (!rsIDSet.contains(new Integer(members[i].getRsID()))) {
                    this.calculatedMemberView[index] = this.createBirtEdgeView(members[i]);
                    rsIDSet.add(new Integer(members[i].getRsID()));
                    ++index;
                }
                ++i;
            }
        }
        this.manager = new MeasureNameManager(members);
    }

    public BirtCubeView(CubeQueryExecutor queryExecutor) throws DataException {
        this(queryExecutor, null);
    }

    public CubeCursor getCubeCursor() throws OLAPException, DataException {
        IResultSet result;
        Map relationMap = CubeQueryDefinitionUtil.getRelationWithMeasure(this.queryDefn);
        try {
            result = new QueryExecutor().execute(this, this.executor, this.manager);
        }
        catch (IOException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
        catch (BirtException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
        CubeCursorImpl cubeCursor = this.appContext != null && this.executor.getContext().getMode() == 3 ? new CubeCursorImpl(this, result, relationMap, this.manager, this.appContext) : new CubeCursorImpl(this, result, relationMap, this.manager);
        return cubeCursor;
    }

    public BirtEdgeView getRowEdgeView() {
        return this.rowEdgeView;
    }

    public BirtEdgeView getColumnEdgeView() {
        return this.columnEdgeView;
    }

    public BirtEdgeView[] getMeasureEdgeView() {
        return this.calculatedMemberView;
    }

    private BirtEdgeView createBirtEdgeView(IEdgeDefinition edgeDefn) {
        if (edgeDefn == null) {
            return null;
        }
        return new BirtEdgeView(this, edgeDefn);
    }

    private BirtEdgeView createBirtEdgeView(CalculatedMember calculatedMember) {
        return new BirtEdgeView(calculatedMember);
    }
}

