/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;

public class ZipBundleEntry
extends BundleEntry {
    protected ZipEntry zipEntry;
    protected BundleFile bundleFile;

    ZipBundleEntry(ZipEntry zipEntry, BundleFile bundleFile) {
        this.zipEntry = zipEntry;
        this.bundleFile = bundleFile;
    }

    public InputStream getInputStream() throws IOException {
        return ((ZipBundleFile)this.bundleFile).getZipFile().getInputStream(this.zipEntry);
    }

    public long getSize() {
        return this.zipEntry.getSize();
    }

    public String getName() {
        return this.zipEntry.getName();
    }

    public long getTime() {
        return this.zipEntry.getTime();
    }

    public URL getLocalURL() {
        try {
            return new URL("jar:file:" + this.bundleFile.basefile.getAbsolutePath() + "!/" + this.zipEntry.getName());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL getFileURL() {
        try {
            File file = this.bundleFile.getFile(this.zipEntry.getName(), false);
            if (file != null) {
                return file.toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }
}

