/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.internal.verifier.JarVerifierConstant;
import org.eclipse.osgi.internal.verifier.JarVerifierMessages;
import org.eclipse.osgi.internal.verifier.PKCS7Processor;
import org.eclipse.osgi.internal.verifier.SignedBundleHook;

public class PKCS7DateParser {
    static Date parseDate(PKCS7Processor pkcs7Processor) throws IOException {
        return PKCS7DateParser.hasTimeStamp(pkcs7Processor);
    }

    private static Date hasTimeStamp(PKCS7Processor pkcs7) throws IOException {
        byte[] timeStampConstruct;
        Map unsignedAttrs = pkcs7.getUnsignedAttrs();
        if (unsignedAttrs != null && (timeStampConstruct = PKCS7DateParser.retrieveTimeStampConstruct(unsignedAttrs)) != null) {
            try {
                PKCS7Processor timestampProcess = new PKCS7Processor(timeStampConstruct, 0, timeStampConstruct.length);
                timestampProcess.validateCerts();
                pkcs7.setTSACertificates(timestampProcess.getCertificates());
                return timestampProcess.getSigningTime();
            }
            catch (CertificateException e) {
                SignedBundleHook.log(e.getMessage(), 4, e);
                throw new IOException(JarVerifierMessages.PKCS7_Parse_Signing_Time);
            }
            catch (NoSuchAlgorithmException e) {
                SignedBundleHook.log(e.getMessage(), 4, e);
                throw new SecurityException(JarVerifierMessages.No_Such_Algorithm_Excep);
            }
            catch (InvalidKeyException e) {
                throw new IOException("InvalidKeyException occurs when verifying the certs from tsa certificates: " + e.getMessage());
            }
            catch (SignatureException signatureException) {
                throw new IOException(JarVerifierMessages.Signature_Not_Verify);
            }
        }
        return null;
    }

    private static byte[] retrieveTimeStampConstruct(Map unsignedAttrs) {
        Set objIDs = unsignedAttrs.keySet();
        Iterator iter = objIDs.iterator();
        while (iter.hasNext()) {
            int[] objID = (int[])iter.next();
            if (!Arrays.equals(JarVerifierConstant.TIMESTAMP_OID, objID)) continue;
            return (byte[])unsignedAttrs.get(objID);
        }
        return null;
    }
}

