/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.utility;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LoggingUtil {
    protected static Logger logger = Logger.getLogger(LoggingUtil.class.getName());

    public static void configureLoggers(Map map, Level level, String string) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)map.get(string2);
            Level level2 = level;
            if (string3 != null && !"".equals(string3)) {
                try {
                    string3 = string3.trim();
                    if (!"DEFAULT".equals(string3)) {
                        level2 = Level.parse(string3.trim());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.log(Level.WARNING, illegalArgumentException.getMessage(), illegalArgumentException);
                }
            }
            LoggingUtil.initFileLogger(string2, level2, string);
        }
    }

    private static void initFileLogger(String string, Level level, String string2) {
        Logger logger = Logger.getLogger(string);
        logger.setLevel(level);
        try {
            FileHandler fileHandler = new FileHandler(LoggingUtil.generateUniqueLogFileName(string, string2), true);
            fileHandler.setFormatter(new SimpleFormatter());
            fileHandler.setLevel(level);
            logger.addHandler(fileHandler);
            logger.setUseParentHandlers(false);
        }
        catch (SecurityException securityException) {
            LoggingUtil.logger.log(Level.WARNING, securityException.getMessage(), securityException);
        }
        catch (IOException iOException) {
            LoggingUtil.logger.log(Level.WARNING, iOException.getMessage(), iOException);
        }
    }

    private static String generateUniqueLogFileName(String string, String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("_yyyy_MM_dd_HH_mm_ss");
        String string3 = simpleDateFormat.format(new Date());
        if (string2 == null) {
            string2 = "";
        } else if (string2.length() > 0) {
            string2 = string2 + System.getProperty("file.separator");
        }
        return new String(string2 + string + string3 + ".log");
    }
}

