/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.IBundle;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.IPlatform;
import org.eclipse.birt.core.framework.IPlatformContext;
import org.eclipse.birt.core.framework.IPlatformPath;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.core.framework.PlatformFileContext;
import org.eclipse.birt.core.framework.osgi.OSGILauncher;

public class Platform {
    public static final String PROPERTY_RUN_UNDER_ECLIPSE = "RUN_UNDER_ECLIPSE";
    public static final String PROPERTY_BIRT_HOME = "BIRT_HOME";
    public static int UNKNOWN_PLATFORM;
    public static int ECLIPSE_PLATFORM;
    public static final int SERVER_PLATFORM = 2;
    protected static int platformType;
    protected static IPlatform platform;
    protected static Logger log;
    protected static OSGILauncher launcher;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.core.framework.Platform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        UNKNOWN_PLATFORM = 0;
        ECLIPSE_PLATFORM = 1;
        platformType = UNKNOWN_PLATFORM;
        platform = null;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.core.framework.Platform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz2.getName());
    }

    public static synchronized void startup(PlatformConfig config) throws BirtException {
        if (platform == null) {
            IPlatformContext context;
            if (config == null) {
                config = new PlatformConfig();
            }
            if ((context = config.getPlatformContext()) == null) {
                context = new PlatformFileContext(config);
                config.setProperty("PLATFORM_CONTEXT", context);
            }
            try {
                launcher = new OSGILauncher();
                launcher.startup(config);
                if (!$assertionsDisabled && platform == null) {
                    throw new AssertionError();
                }
            }
            catch (Exception ex) {
                platform = null;
                throw new BirtException("org.eclipse.birt.core", "Can't startup the OSGI framework", new Object[0], (Throwable)ex);
            }
        }
    }

    public static synchronized void shutdown() {
        if (launcher != null) {
            launcher.shutdown();
            launcher = null;
        }
        platform = null;
    }

    public static synchronized void initialize(PlatformConfig config) {
        try {
            Platform.startup(config);
        }
        catch (BirtException ex) {
            log.log(Level.SEVERE, ex.getMessage());
        }
    }

    public static void setPlatform(IPlatform platform) {
        Platform.platform = platform;
    }

    public static IExtensionRegistry getExtensionRegistry() {
        if (platform != null) {
            return platform.getExtensionRegistry();
        }
        return null;
    }

    public static IBundle getBundle(String symbolicName) {
        if (platform != null) {
            return platform.getBundle(symbolicName);
        }
        return null;
    }

    public static URL find(IBundle bundle, IPlatformPath path) {
        if (platform != null) {
            return platform.find(bundle, path);
        }
        return null;
    }

    public static int getPlatformType() {
        return platformType;
    }

    public static URL asLocalURL(URL url) throws IOException {
        if (platform != null) {
            return platform.asLocalURL(url);
        }
        return null;
    }

    public static boolean runningEclipse() {
        return platform != null;
    }

    public static void intializeTracing(String pluginName) {
        if (platform != null) {
            platform.initializeTracing(pluginName);
        }
    }

    public static String getDebugOption(String name) {
        if (platform != null) {
            return platform.getDebugOption(name);
        }
        return null;
    }

    public static Object createFactoryObject(String extensionId) {
        if (platform != null) {
            return platform.createFactoryObject(extensionId);
        }
        return null;
    }
}

