/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.i18n.JdbcResourceHandle;
import org.eclipse.birt.report.data.oda.jdbc.IConnectionFactory;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.JndiDataSource;
import org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.osgi.framework.Bundle;

public class JDBCDriverManager {
    public static final String JDBC_USER_PROP_NAME = "user";
    public static final String JDBC_PASSWORD_PROP_NAME = "password";
    public static final String DRIVER_REGISTERED = "registered";
    public static final String DRIVER_DEREGISTERED = "deregistered";
    private HashMap registeredDrivers = new HashMap();
    private HashMap cachedDriversMap = new HashMap();
    private HashMap driverExtensions = null;
    private DriverClassLoader extraDriverLoader = null;
    private JdbcResourceHandle resourceHandle = new JdbcResourceHandle(ULocale.getDefault());
    private static JDBCDriverManager instance;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    private JDBCDriverManager() {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "JDBCDriverManager", "JDBCDriverManager starts up");
    }

    public static synchronized JDBCDriverManager getInstance() {
        if (instance == null) {
            instance = new JDBCDriverManager();
        }
        return instance;
    }

    public Connection getConnection(String driverClass, String url, Properties connectionProperties, String driverClassPath) throws SQLException, OdaException {
        this.validateConnectionUrl(url, null);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Request JDBC Connection: driverClass=" + (driverClass == null ? "" : driverClass) + "; url=" + url);
        }
        return this.doConnect(driverClass, url, null, connectionProperties, driverClassPath);
    }

    public Connection getConnection(String driverClass, String url, String user, String password, String driverClassPath) throws SQLException, OdaException {
        this.validateConnectionUrl(url, null);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Request JDBC Connection: driverClass=" + (driverClass == null ? "" : driverClass) + "; url=" + url + "; user=" + (user == null ? "" : user));
        }
        Properties props = JDBCDriverManager.addUserAuthenticationProperties(null, user, password);
        return this.doConnect(driverClass, url, null, props, driverClassPath);
    }

    public Connection getConnection(String driverClass, String url, String jndiNameUrl, Properties connectionProperties, String driverClassPath) throws SQLException, OdaException {
        this.validateConnectionUrl(url, jndiNameUrl);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Request JDBC Connection: driverClass=" + driverClass + "; url=" + url + "; jndi name url=" + jndiNameUrl);
        }
        return this.doConnect(driverClass, url, jndiNameUrl, connectionProperties, driverClassPath);
    }

    private synchronized Connection doConnect(String driverClass, String url, String jndiNameUrl, Properties connectionProperties, String driverClassPath) throws SQLException, OdaException {
        if (!$assertionsDisabled && url == null) {
            throw new AssertionError();
        }
        IConnectionFactory factory = this.getDriverConnectionFactory(driverClass);
        if (factory != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Calling IConnectionFactory.getConnection. driverClass=" + driverClass + ", url=" + url);
            }
            return factory.getConnection(driverClass, url, connectionProperties);
        }
        Connection jndiDSConnection = this.getJndiDSConnection(driverClass, jndiNameUrl, connectionProperties);
        if (jndiDSConnection != null) {
            return jndiDSConnection;
        }
        this.loadAndRegisterDriver(driverClass, driverClassPath);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Calling DriverManager.getConnection. url=" + url);
        }
        try {
            return DriverManager.getConnection(url, connectionProperties);
        }
        catch (RuntimeException e) {
            throw new JDBCException("odajdbc.GetConnectionError", null, e.getMessage());
        }
    }

    private Connection getJndiDSConnection(String driverClass, String jndiNameUrl, Properties connectionProperties) {
        Connection jndiDSConnection;
        block4: {
            if (jndiNameUrl == null || jndiNameUrl.length() == 0) {
                return null;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Calling getJndiDSConnection: JNDI name url=" + jndiNameUrl);
            }
            JndiDataSource factory = new JndiDataSource();
            jndiDSConnection = null;
            try {
                jndiDSConnection = factory.getConnection(driverClass, jndiNameUrl, connectionProperties);
            }
            catch (SQLException e) {
                if (!logger.isLoggable(Level.INFO)) break block4;
                logger.info("getJndiDSConnection: Unable to get JNDI data source connection; " + e.toString());
            }
        }
        return jndiDSConnection;
    }

    static Properties addUserAuthenticationProperties(Properties connProps, String user, String password) {
        if (connProps == null) {
            connProps = new Properties();
        }
        if (user != null) {
            connProps.setProperty(JDBC_USER_PROP_NAME, user);
        }
        if (password != null) {
            connProps.setProperty(JDBC_PASSWORD_PROP_NAME, password);
        }
        return connProps;
    }

    private void validateConnectionUrl(String url, String jndiNameUrl) {
        if (this.isBlank(url) && this.isBlank(jndiNameUrl)) {
            throw new NullPointerException(this.resourceHandle.getMessage("odajdbc.missedUrlAndJndi"));
        }
    }

    private boolean isBlank(String url) {
        return url == null || url.trim().toString().length() == 0;
    }

    private IConnectionFactory getDriverConnectionFactory(String driverClass) throws OdaException {
        this.loadDriverExtensions();
        IConnectionFactory factory = null;
        Object driverInfo = null;
        if (driverClass != null) {
            driverInfo = this.driverExtensions.get(driverClass);
        }
        if (driverInfo != null) {
            if (driverInfo instanceof IConfigurationElement) {
                String factoryClass = ((IConfigurationElement)driverInfo).getAttribute("connectionFactory");
                try {
                    factory = (IConnectionFactory)((IConfigurationElement)driverInfo).createExecutableExtension("connectionFactory");
                    logger.fine("Created connection factory class " + factoryClass + " for driverClass " + driverClass);
                }
                catch (CoreException coreException) {
                    JDBCException ex = new JDBCException("odajdbc.CannotInstantiateFactory", null, new Object[]{factoryClass, driverClass});
                    logger.log(Level.WARNING, "Failed to instantiate connection factory for driverClass " + driverClass, (Throwable)((Object)ex));
                    throw ex;
                }
                if (!$assertionsDisabled && factory == null) {
                    throw new AssertionError();
                }
                this.driverExtensions.put(driverClass, factory);
            } else {
                if (!$assertionsDisabled && !(driverInfo instanceof IConnectionFactory)) {
                    throw new AssertionError();
                }
                factory = driverInfo;
            }
        }
        return factory;
    }

    private void loadDriverExtensions() {
        if (this.driverExtensions != null) {
            return;
        }
        this.driverExtensions = new HashMap();
        IExtensionRegistry extReg = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extReg.getExtensionPoint("org.eclipse.birt.report.data.oda.jdbc.driverinfo");
        if (extPoint == null) {
            return;
        }
        IExtension[] exts = extPoint.getExtensions();
        if (exts == null) {
            return;
        }
        int e = 0;
        while (e < exts.length) {
            IConfigurationElement[] configElems = exts[e].getConfigurationElements();
            if (configElems != null) {
                int i = 0;
                while (i < configElems.length) {
                    if (configElems[i].getName().equals("jdbcDriver")) {
                        String driverClass = configElems[i].getAttribute("driverClass");
                        String connectionFactory = configElems[i].getAttribute("connectionFactory");
                        logger.info("Found JDBC driverinfo extension: driverClass=" + driverClass + ", connectionFactory=" + connectionFactory);
                        if (driverClass != null && driverClass.length() > 0 && connectionFactory != null && connectionFactory.length() > 0) {
                            this.driverExtensions.put(driverClass, configElems[i]);
                        }
                    }
                    ++i;
                }
            }
            ++e;
        }
    }

    public boolean testConnection(String driverClassName, String connectionString, String userId, String password) throws OdaException {
        return this.testConnection(driverClassName, connectionString, null, userId, password);
    }

    public boolean testConnection(String driverClassName, String connectionString, String jndiNameUrl, String userId, String password) throws OdaException {
        boolean canConnect;
        block11: {
            Connection jndiDSConnection;
            block10: {
                canConnect = false;
                if (this.getDriverConnectionFactory(driverClassName) == null) break block10;
                this.tryCreateConnection(driverClassName, connectionString, userId, password);
                return true;
            }
            if (jndiNameUrl == null || (jndiDSConnection = this.getJndiDSConnection(driverClassName, jndiNameUrl, JDBCDriverManager.addUserAuthenticationProperties(null, userId, password))) == null) break block11;
            this.closeConnection(jndiDSConnection);
            return true;
        }
        try {
            this.loadAndRegisterDriver(driverClassName, null);
            if (this.cachedDriversMap.get(driverClassName) == null) {
                Enumeration<Driver> enumeration = DriverManager.getDrivers();
                while (enumeration.hasMoreElements()) {
                    Driver driver = enumeration.nextElement();
                    if (!this.isExpectedDriver(driver, driverClassName) || !driver.acceptsURL(connectionString)) continue;
                    this.cachedDriversMap.put(driverClassName, driver);
                    this.tryCreateConnection(driverClassName, connectionString, userId, password);
                    canConnect = true;
                    break;
                }
                if (!canConnect) {
                    throw new JDBCException("odajdbc.CannotParseURL", null);
                }
            } else if (((Driver)this.cachedDriversMap.get(driverClassName)).acceptsURL(connectionString)) {
                this.tryCreateConnection(driverClassName, connectionString, userId, password);
                canConnect = true;
            }
        }
        catch (SQLException e) {
            throw new JDBCException(e.getLocalizedMessage(), null);
        }
        if (!canConnect) {
            throw new JDBCException("odajdbc.NoSuitableDriver", null);
        }
        return true;
    }

    private void closeConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException sQLException) {}
    }

    private boolean isExpectedDriver(Driver driver, String className) {
        String actual = driver instanceof WrappedDriver ? driver.toString() : driver.getClass().getName();
        return this.isExpectedDriverClass(actual, className);
    }

    private boolean isExpectedDriverClass(String actual, String expected) {
        String actualPkg = actual.substring(0, actual.lastIndexOf(46));
        String expectedPkg = expected.substring(0, expected.lastIndexOf(46));
        return actualPkg.equals(expectedPkg);
    }

    private void tryCreateConnection(String driverClassName, String connectionString, String userId, String password) throws SQLException, OdaException {
        Connection testConn = this.getConnection(driverClassName, connectionString, userId, password, null);
        if (!$assertionsDisabled && testConn == null) {
            throw new AssertionError();
        }
        this.closeConnection(testConn);
    }

    private Driver findDriver(String className, String driverClassPath) throws OdaException {
        Class driverClass;
        block5: {
            driverClass = null;
            try {
                driverClass = Class.forName(className);
                logger.info("Loaded JDBC driver class in class path: " + className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.info("Driver class not in class path: " + className + ". Trying to locate driver in drivers directory");
                }
                if ((driverClass = this.loadExtraDriver(className, true, driverClassPath)) != null) break block5;
                logger.warning("Failed to load JDBC driver class: " + className);
                throw new JDBCException("odajdbc.CannotLoadDriverClass", null, className);
            }
        }
        Driver driver = null;
        try {
            driver = (Driver)driverClass.newInstance();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create new instance of JDBC driver:" + className, e);
            throw new JDBCException("odajdbc.CannotInstantiateDriverClass", null, className);
        }
        return driver;
    }

    public boolean deregisterDriver(String className) throws OdaException {
        if (className == null || className.length() == 0) {
            return false;
        }
        if (this.isDeregistered(className)) {
            return true;
        }
        Driver driver = this.findDriver(className, null);
        if (driver != null) {
            try {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Registering with DriverManager: wrapped driver for " + className);
                }
                if (this.registeredDrivers.containsKey(className)) {
                    DriverManager.deregisterDriver(new WrappedDriver(driver, className));
                    this.registeredDrivers.remove(className);
                }
                this.registeredDrivers.put(className, DRIVER_DEREGISTERED);
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "Failed to deRegister wrapped driver instance.", e);
            }
        }
        return true;
    }

    public void updateStatus(String className) {
        if (this.isDeregistered(className)) {
            this.registeredDrivers.remove(className);
        }
    }

    private boolean isDeregistered(String className) {
        return this.registeredDrivers.containsKey(className) && this.registeredDrivers.get(className).equals(DRIVER_DEREGISTERED);
    }

    private void loadAndRegisterDriver(String className, String driverClassPath) throws OdaException {
        Driver driver;
        if (className == null || className.length() == 0) {
            return;
        }
        if (this.isDeregistered(className)) {
            throw new JDBCException("odajdbc.CannotLoadDriverClass", null, className);
        }
        if (this.registeredDrivers.containsKey(className)) {
            return;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Loading JDBC driver class: " + className);
        }
        if ((driver = this.findDriver(className, driverClassPath)) != null) {
            try {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Registering with DriverManager: wrapped driver for " + className);
                }
                DriverManager.registerDriver(new WrappedDriver(driver, className));
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "Failed to register wrapped driver instance.", e);
            }
        }
        this.registeredDrivers.put(className, DRIVER_REGISTERED);
    }

    private Class loadExtraDriver(String className, boolean refreshUrlsWhenFail, String driverClassPath) throws OdaException {
        if (!$assertionsDisabled && className == null) {
            throw new AssertionError();
        }
        if (this.extraDriverLoader == null) {
            this.extraDriverLoader = new DriverClassLoader(driverClassPath);
        }
        try {
            return this.extraDriverLoader.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (refreshUrlsWhenFail && this.extraDriverLoader.refreshURLs()) {
                return this.loadExtraDriver(className, false, driverClassPath);
            }
            logger.log(Level.FINER, "Driver class not found in drivers directory: " + className);
            return null;
        }
    }

    private static class DriverClassLoader
    extends URLClassLoader {
        private Bundle bundle;
        private HashSet fileSet;
        private String driverClassPath;

        public DriverClassLoader(String driverClassPath) throws OdaException {
            URL[] uRLArray = new URL[]{};
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager$DriverClassLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            super(uRLArray, clazz.getClassLoader());
            this.fileSet = new HashSet();
            Logger logger = logger;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager$DriverClassLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.entering(clazz2.getName(), "constructor()");
            this.driverClassPath = driverClassPath;
            this.bundle = Platform.getBundle((String)"org.eclipse.birt.report.data.oda.jdbc");
            if (this.bundle == null) {
                logger.severe("Failed to get Bundle object");
            } else {
                this.refreshURLs();
            }
        }

        public boolean refreshURLs() throws OdaException {
            if (this.bundle == null) {
                return false;
            }
            boolean foundNew = false;
            if (this.driverClassPath != null) {
                try {
                    File driverClassFile = new File(this.driverClassPath);
                    if (driverClassFile.exists()) {
                        this.addURL(driverClassFile.toURI().toURL());
                        if (driverClassFile.isDirectory()) {
                            File[] driverFiles = driverClassFile.listFiles(new FileFilter(this){
                                final /* synthetic */ DriverClassLoader this$1;
                                {
                                    this.this$1 = driverClassLoader;
                                }

                                public boolean accept(File pathname) {
                                    return pathname.isFile() && OdaJdbcDriver.isDriverFile(pathname.getName());
                                }
                            });
                            int i = 0;
                            while (i < driverFiles.length) {
                                if (!this.fileSet.contains(driverFiles[i].getName())) {
                                    foundNew = true;
                                    this.fileSet.add(driverFiles[i].getName());
                                    this.addURL(driverFiles[i].toURI().toURL());
                                    logger.info("JDBCDriverManager: found JAR file " + driverFiles[i].getName() + ". URL=" + driverFiles[i].toURI().toURL());
                                }
                                ++i;
                            }
                        }
                    }
                }
                catch (MalformedURLException e) {
                    throw new OdaException((Throwable)e);
                }
            }
            Enumeration files = this.bundle.getEntryPaths("drivers");
            while (files.hasMoreElements()) {
                String fileName = (String)files.nextElement();
                if (!OdaJdbcDriver.isDriverFile(fileName) || this.fileSet.contains(fileName)) continue;
                foundNew = true;
                this.fileSet.add(fileName);
                URL fileURL = this.bundle.getEntry(fileName);
                this.addURL(fileURL);
                logger.info("JDBCDriverManager: found JAR file " + fileName + ". URL=" + fileURL);
            }
            return foundNew;
        }
    }

    private static class WrappedDriver
    implements Driver {
        private Driver driver;
        private String driverClass;

        WrappedDriver(Driver d, String driverClass) {
            Logger logger = logger;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager$WrappedDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.entering(clazz.getName(), "WrappedDriver", driverClass);
            this.driver = d;
            this.driverClass = driverClass;
        }

        public boolean acceptsURL(String u) throws SQLException {
            boolean res = this.driver.acceptsURL(u);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "WrappedDriver(" + this.driverClass + ").acceptsURL(" + u + ")returns: " + res);
            }
            return res;
        }

        public Connection connect(String u, Properties p) throws SQLException {
            Logger logger = logger;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager$WrappedDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.entering(String.valueOf(clazz.getName()) + ":" + this.driverClass, "connect", u);
            try {
                return this.driver.connect(u, p);
            }
            catch (RuntimeException e) {
                throw new SQLException(e.getMessage());
            }
        }

        public int getMajorVersion() {
            return this.driver.getMajorVersion();
        }

        public int getMinorVersion() {
            return this.driver.getMinorVersion();
        }

        public DriverPropertyInfo[] getPropertyInfo(String u, Properties p) throws SQLException {
            return this.driver.getPropertyInfo(u, p);
        }

        public boolean jdbcCompliant() {
            return this.driver.jdbcCompliant();
        }

        public String toString() {
            return this.driverClass;
        }
    }
}

