/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.PropertyChoice;

public class Property {
    private static final String VISIBILITY_LOCK = "lock";
    private static final String VISIBILITY_CHANGE = "change";
    private static final String VISIBILITY_HIDE = "hide";
    private static final String LITERAL_TRUE = "true";
    private static final String LITERAL_FALSE = "false";
    private static final String NAME_ATTR = "name";
    private static final String TYPE_ATTR = "type";
    private static final String DEFAULT_VALUE_ATTR = "defaultValue";
    private static final String ENCRYPTABLE_ATTR = "isEncryptable";
    private static final String CAN_INHERIT_ATTR = "canInherit";
    private static final String EMPTY_VALUE_TYPE_ATTR = "allowsEmptyValueAsNull";
    private static final String CHOICE_ELEMENT = "choice";
    private String m_name;
    private String m_displayName;
    private String m_groupName;
    private String m_groupDisplayName;
    private String m_type = "string";
    private boolean m_canInherit = true;
    private String m_defaultValue;
    private boolean m_isEncryptable = false;
    private PropertyChoice[] m_choices = null;
    private boolean m_allowsEmptyValueAsNull = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    Property(IConfigurationElement propertyElement) {
        this.setAttributes(propertyElement, null, null);
    }

    Property(IConfigurationElement propertyElement, String groupName, String groupDisplayName) {
        this.setAttributes(propertyElement, groupName, groupDisplayName);
    }

    Property(String name, String displayName, String groupName, String groupDisplayName) {
        if (!($assertionsDisabled || name != null && name.length() > 0)) {
            throw new AssertionError();
        }
        this.m_name = name;
        this.m_displayName = displayName;
        this.m_groupName = groupName;
        this.m_groupDisplayName = groupDisplayName;
    }

    private void setAttributes(IConfigurationElement propertyElement, String groupName, String groupDisplayName) {
        IConfigurationElement[] choiceElements;
        int numChoices;
        this.m_name = propertyElement.getAttribute(NAME_ATTR);
        this.m_displayName = ManifestExplorer.getElementDisplayName(propertyElement);
        this.m_groupName = groupName;
        this.m_groupDisplayName = groupDisplayName;
        String propType = propertyElement.getAttribute(TYPE_ATTR);
        if (propType != null && propType.length() >= 0) {
            this.m_type = propType;
        }
        this.m_defaultValue = propertyElement.getAttribute(DEFAULT_VALUE_ATTR);
        Boolean boolValue = this.convertBooleanValue(propertyElement.getAttribute(ENCRYPTABLE_ATTR));
        if (boolValue != null) {
            this.m_isEncryptable = boolValue;
        }
        if ((boolValue = this.convertBooleanValue(propertyElement.getAttribute(CAN_INHERIT_ATTR))) != null) {
            this.m_canInherit = boolValue;
        }
        if ((boolValue = this.convertBooleanValue(propertyElement.getAttribute(EMPTY_VALUE_TYPE_ATTR))) != null) {
            this.m_allowsEmptyValueAsNull = boolValue;
        }
        if ((numChoices = (choiceElements = propertyElement.getChildren(CHOICE_ELEMENT)).length) <= 0) {
            return;
        }
        ArrayList<PropertyChoice> choices = new ArrayList<PropertyChoice>(numChoices);
        for (int i = 0; i < numChoices; ++i) {
            IConfigurationElement choiceElement = choiceElements[i];
            choices.add(new PropertyChoice(choiceElement));
        }
        this.m_choices = choices.toArray(new PropertyChoice[numChoices]);
    }

    private Boolean convertBooleanValue(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        if (value.equalsIgnoreCase(LITERAL_TRUE) || value.equalsIgnoreCase(LITERAL_FALSE)) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    public String getGroupDisplayName() {
        return this.m_groupDisplayName;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean canInherit() {
        return this.m_canInherit;
    }

    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    public boolean isEncryptable() {
        return this.m_isEncryptable;
    }

    public boolean allowsEmptyValueAsNull() {
        return this.m_allowsEmptyValueAsNull;
    }

    public PropertyChoice[] getChoices() {
        if (this.m_choices == null) {
            this.m_choices = new PropertyChoice[0];
        }
        return this.m_choices;
    }

    public boolean isVisible(Properties propertiesVisibility) {
        String visibility = this.getVisibility(this.getName(), propertiesVisibility);
        return !visibility.equalsIgnoreCase(VISIBILITY_HIDE);
    }

    public boolean isEditable(Properties propertiesVisibility) {
        String visibility = this.getVisibility(this.getName(), propertiesVisibility);
        return !visibility.equalsIgnoreCase(VISIBILITY_HIDE) && !visibility.equalsIgnoreCase(VISIBILITY_LOCK);
    }

    private String getVisibility(String propName, Properties propertiesVisibility) {
        if (propertiesVisibility == null || propertiesVisibility.size() == 0) {
            return VISIBILITY_CHANGE;
        }
        if (!$assertionsDisabled && propName == null) {
            throw new AssertionError();
        }
        return propertiesVisibility.getProperty(propName, VISIBILITY_CHANGE);
    }

    static {
        $assertionsDisabled = !Property.class.desiredAssertionStatus();
    }
}

