/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.markup;

import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.SimpleCell;
import com.lowagie.text.SimpleTable;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class MarkupParser
extends HashMap {
    private static final long serialVersionUID = 3724008022202507040L;
    protected HashMap stylecache = new HashMap();
    protected HashMap fontcache = new HashMap();
    public static HashMap colorTable = new HashMap();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MarkupParser(String string) {
        BufferedReader bufferedReader = null;
        try {
            try {
                String string2;
                FileReader fileReader = new FileReader(string);
                bufferedReader = new BufferedReader(fileReader);
                StringBuffer stringBuffer = new StringBuffer();
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2.trim());
                }
                String string3 = stringBuffer.toString();
                string3 = MarkupParser.removeComment(string3, "/*", "*/");
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "}");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    int n = string4.indexOf(123);
                    if (n <= 0) continue;
                    String string5 = string4.substring(0, n).trim();
                    String string6 = string4.substring(n + 1).trim();
                    if (string6.endsWith("}")) {
                        string6 = string6.substring(0, string6.length() - 1);
                    }
                    this.put(string5, MarkupParser.parseAttributes(string6));
                }
                Object var13_13 = null;
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                if (bufferedReader == null) throw throwable;
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (bufferedReader == null) return;
        bufferedReader.close();
        return;
    }

    public static String removeComment(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string3.length();
        int n3 = string.indexOf(string2, n);
        while (n3 > -1) {
            stringBuffer.append(string.substring(n, n3));
            n = string.indexOf(string3, n3) + n2;
            n3 = string.indexOf(string2, n);
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static Properties parseAttributes(String string) {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string2 = stringTokenizer2.nextToken().trim();
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string3 = stringTokenizer2.nextToken().trim();
            if (string3.startsWith("\"")) {
                string3 = string3.substring(1);
            }
            if (string3.endsWith("\"")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            properties.setProperty(string2.toLowerCase(), string3);
        }
        return properties;
    }

    public static float parseLength(String string) {
        int n = 0;
        int n2 = string.length();
        boolean bl = true;
        block3: while (bl && n < n2) {
            switch (string.charAt(n)) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ++n;
                    continue block3;
                }
            }
            bl = false;
        }
        if (n == 0) {
            return 0.0f;
        }
        if (n == n2) {
            return Float.parseFloat(string + "f");
        }
        float f = Float.parseFloat(string.substring(0, n) + "f");
        if ((string = string.substring(n)).startsWith("in")) {
            return f * 72.0f;
        }
        if (string.startsWith("cm")) {
            return f / 2.54f * 72.0f;
        }
        if (string.startsWith("mm")) {
            return f / 25.4f * 72.0f;
        }
        if (string.startsWith("pc")) {
            return f * 12.0f;
        }
        return f;
    }

    public static Color decodeColor(String string) {
        if (string == null) {
            return null;
        }
        Color color = (Color)colorTable.get(string = string.toLowerCase().trim());
        if (color != null) {
            return color;
        }
        try {
            if (string.startsWith("#")) {
                if (string.length() == 4) {
                    string = "#" + string.substring(1, 2) + string.substring(1, 2) + string.substring(2, 3) + string.substring(2, 3) + string.substring(3, 4) + string.substring(3, 4);
                }
                if (string.length() == 7) {
                    return new Color(Integer.parseInt(string.substring(1), 16));
                }
            } else if (string.startsWith("rgb")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(3), " \t\r\n\f(),");
                int[] nArray = new int[3];
                for (int i = 0; i < 3; ++i) {
                    float f;
                    if (!stringTokenizer.hasMoreTokens()) {
                        return null;
                    }
                    String string2 = stringTokenizer.nextToken();
                    if (string2.endsWith("%")) {
                        f = Float.parseFloat(string2.substring(0, string2.length() - 1));
                        f = f * 255.0f / 100.0f;
                    } else {
                        f = Float.parseFloat(string2);
                    }
                    int n = (int)f;
                    if (n > 255) {
                        n = 255;
                    } else if (n < 0) {
                        n = 0;
                    }
                    nArray[i] = n;
                }
                return new Color(nArray[0], nArray[1], nArray[2]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getKey(Properties properties) {
        String string = properties.getProperty("tag");
        String string2 = properties.getProperty("id");
        String string3 = properties.getProperty("class");
        string2 = string2 == null ? "" : "#" + string2;
        string3 = string3 == null ? "" : "." + string3;
        String string4 = string + string2 + string3;
        if (!this.stylecache.containsKey(string4) && string4.length() > 0) {
            Properties properties2 = new Properties();
            Properties properties3 = (Properties)this.get(string);
            Properties properties4 = (Properties)this.get(string2);
            Properties properties5 = (Properties)this.get(string3);
            Properties properties6 = (Properties)this.get(string + string2);
            Properties properties7 = (Properties)this.get(string + string3);
            if (properties3 != null) {
                properties2.putAll((Map<?, ?>)properties3);
            }
            if (properties4 != null) {
                properties2.putAll((Map<?, ?>)properties4);
            }
            if (properties5 != null) {
                properties2.putAll((Map<?, ?>)properties5);
            }
            if (properties6 != null) {
                properties2.putAll((Map<?, ?>)properties6);
            }
            if (properties7 != null) {
                properties2.putAll((Map<?, ?>)properties7);
            }
            this.stylecache.put(string4, properties2);
        }
        return string4;
    }

    public boolean getPageBreakBefore(Properties properties) {
        String string = this.getKey(properties);
        Properties properties2 = (Properties)this.stylecache.get(string);
        return properties2 != null && "always".equals(properties2.getProperty("page-break-before"));
    }

    public boolean getPageBreakAfter(Properties properties) {
        String string = this.getKey(properties);
        Properties properties2 = (Properties)this.stylecache.get(string);
        return properties2 != null && "always".equals(properties2.getProperty("page-break-after"));
    }

    public Element getObject(Properties properties) {
        String string = this.getKey(properties);
        Properties properties2 = (Properties)this.stylecache.get(string);
        if (properties2 == null) {
            return null;
        }
        if ("hidden".equals(properties2.get("visibility"))) {
            return null;
        }
        String string2 = properties2.getProperty("display");
        Element element = null;
        if ("inline".equals(string2)) {
            element = this.retrievePhrase(this.getFont(properties), properties2);
        } else if ("block".equals(string2)) {
            element = this.retrieveParagraph(this.getFont(properties), properties2);
        } else if ("list-item".equals(string2)) {
            element = this.retrieveListItem(this.getFont(properties), properties2);
        } else if ("table-cell".equals(string2)) {
            element = this.retrieveTableCell(properties, properties2);
        } else if ("table-row".equals(string2)) {
            element = this.retrieveTableRow(properties, properties2);
        } else if ("table".equals(string2)) {
            element = this.retrieveTable(properties, properties2);
        }
        return element;
    }

    public Font getFont(Properties properties) {
        String string = this.getKey(properties);
        Font font = (Font)this.fontcache.get(string);
        if (font != null) {
            return font;
        }
        Properties properties2 = (Properties)this.stylecache.get(string);
        font = this.retrieveFont(properties2);
        this.fontcache.put(string, font);
        return font;
    }

    public Rectangle getRectangle(Properties properties) {
        String string = null;
        String string2 = null;
        String string3 = this.getKey(properties);
        Properties properties2 = (Properties)this.stylecache.get(string3);
        if (properties2 != null) {
            string = properties2.getProperty("width");
            string2 = properties2.getProperty("height");
        }
        if (string == null) {
            string = properties.getProperty("width");
        }
        if (string2 == null) {
            string2 = properties.getProperty("height");
        }
        if (string == null || string2 == null) {
            return null;
        }
        return new Rectangle(MarkupParser.parseLength(string), MarkupParser.parseLength(string2));
    }

    public Element retrievePhrase(Font font, Properties properties) {
        Phrase phrase = new Phrase("", font);
        if (properties == null) {
            return phrase;
        }
        String string = properties.getProperty("line-height");
        if (string != null) {
            if (string.endsWith("%")) {
                phrase.setLeading(phrase.font().size() * (MarkupParser.parseLength(string) / 100.0f));
            } else {
                phrase.setLeading(MarkupParser.parseLength(string));
            }
        }
        return phrase;
    }

    public Element retrieveParagraph(Font font, Properties properties) {
        String string;
        float f;
        Paragraph paragraph = new Paragraph((Phrase)this.retrievePhrase(font, properties));
        if (properties == null) {
            return paragraph;
        }
        String string2 = properties.getProperty("margin");
        if (string2 != null) {
            f = MarkupParser.parseLength(string2);
            paragraph.setIndentationLeft(f);
            paragraph.setIndentationRight(f);
            paragraph.setSpacingBefore(f);
            paragraph.setSpacingAfter(f);
        }
        if ((string2 = properties.getProperty("margin-left")) != null) {
            f = MarkupParser.parseLength(string2);
            paragraph.setIndentationLeft(f);
        }
        if ((string2 = properties.getProperty("margin-right")) != null) {
            f = MarkupParser.parseLength(string2);
            paragraph.setIndentationRight(f);
        }
        if ((string2 = properties.getProperty("margin-top")) != null) {
            f = MarkupParser.parseLength(string2);
            paragraph.setSpacingBefore(f);
        }
        if ((string2 = properties.getProperty("margin-bottom")) != null) {
            f = MarkupParser.parseLength(string2);
            paragraph.setSpacingAfter(f);
        }
        if ("left".equals(string = properties.getProperty("text-align"))) {
            paragraph.setAlignment(0);
        } else if ("right".equals(string)) {
            paragraph.setAlignment(2);
        } else if ("center".equals(string)) {
            paragraph.setAlignment(1);
        } else if ("justify".equals(string)) {
            paragraph.setAlignment(3);
        }
        return paragraph;
    }

    private Element retrieveTable(Properties properties, Properties properties2) {
        SimpleTable simpleTable = new SimpleTable();
        this.applyBordersColors(simpleTable, properties, properties2);
        return simpleTable;
    }

    private Element retrieveTableRow(Properties properties, Properties properties2) {
        String string;
        float f;
        String string2;
        SimpleCell simpleCell = new SimpleCell(true);
        this.applyBordersColors(simpleCell, properties, properties2);
        String string3 = null;
        if (properties != null) {
            string3 = properties.getProperty("width");
        }
        if (string3 == null) {
            string3 = properties2.getProperty("width");
        }
        if (string3 != null) {
            if (string3.endsWith("%")) {
                simpleCell.setWidthpercentage(MarkupParser.parseLength(string3));
            } else {
                simpleCell.setWidth(MarkupParser.parseLength(string3));
            }
        }
        if ((string2 = properties2.getProperty("margin")) != null) {
            f = MarkupParser.parseLength(string2);
            simpleCell.setSpacing(f);
        }
        if ((string2 = properties2.getProperty("margin-left")) != null) {
            f = MarkupParser.parseLength(string2);
            simpleCell.setSpacing_left(f);
        }
        if ((string2 = properties2.getProperty("margin-right")) != null) {
            f = MarkupParser.parseLength(string2);
            simpleCell.setSpacing_right(f);
        }
        if ((string2 = properties2.getProperty("margin-top")) != null) {
            f = MarkupParser.parseLength(string2);
            simpleCell.setSpacing_top(f);
        }
        if ((string2 = properties2.getProperty("margin-bottom")) != null) {
            f = MarkupParser.parseLength(string2);
            simpleCell.setSpacing_bottom(f);
        }
        if ((string = properties2.getProperty("padding")) != null) {
            f = MarkupParser.parseLength(string);
            simpleCell.setPadding(f);
        }
        if ((string = properties2.getProperty("padding-left")) != null) {
            f = MarkupParser.parseLength(string);
            simpleCell.setSpacing_left(f);
        }
        if ((string = properties2.getProperty("padding-right")) != null) {
            f = MarkupParser.parseLength(string);
            simpleCell.setSpacing_right(f);
        }
        if ((string = properties2.getProperty("padding-top")) != null) {
            f = MarkupParser.parseLength(string);
            simpleCell.setSpacing_top(f);
        }
        if ((string = properties2.getProperty("padding-bottom")) != null) {
            f = MarkupParser.parseLength(string);
            simpleCell.setSpacing_bottom(f);
        }
        return simpleCell;
    }

    private Element retrieveTableCell(Properties properties, Properties properties2) {
        SimpleCell simpleCell = (SimpleCell)this.retrieveTableRow(properties, properties2);
        simpleCell.setCellgroup(false);
        return simpleCell;
    }

    private Element retrieveListItem(Font font, Properties properties) {
        ListItem listItem = new ListItem();
        return listItem;
    }

    private void applyBordersColors(Rectangle rectangle, Properties properties, Properties properties2) {
        float f;
        String string = properties2.getProperty("border-width");
        if (string != null) {
            f = MarkupParser.parseLength(string);
            rectangle.setBorderWidth(f);
        }
        if ((string = properties2.getProperty("border-left-width")) != null) {
            f = MarkupParser.parseLength(string);
            rectangle.setBorderWidthLeft(f);
        }
        if ((string = properties2.getProperty("border-right-width")) != null) {
            f = MarkupParser.parseLength(string);
            rectangle.setBorderWidthRight(f);
        }
        if ((string = properties2.getProperty("border-top-width")) != null) {
            f = MarkupParser.parseLength(string);
            rectangle.setBorderWidthTop(f);
        }
        if ((string = properties2.getProperty("border-bottom-width")) != null) {
            f = MarkupParser.parseLength(string);
            rectangle.setBorderWidthBottom(f);
        }
        if ((string = properties2.getProperty("border-color")) != null) {
            rectangle.setBorderColor(MarkupParser.decodeColor(string));
        }
    }

    public Font retrieveFont(Properties properties) {
        String string = null;
        String string2 = FontFactory.defaultEncoding;
        boolean bl = FontFactory.defaultEmbedding;
        float f = -1.0f;
        int n = 0;
        Color color = null;
        String string3 = (String)properties.get("font-family");
        if (string3 != null) {
            if (string3.indexOf(44) == -1) {
                string = string3.trim();
            } else {
                while (string3.indexOf(44) != -1) {
                    String string4 = string3.substring(0, string3.indexOf(44)).trim();
                    if (FontFactory.isRegistered(string4)) {
                        string = string4;
                        break;
                    }
                    string3 = string3.substring(string3.indexOf(44) + 1);
                }
            }
        }
        if ((string3 = (String)properties.get("font-size")) != null) {
            f = MarkupParser.parseLength(string3);
        }
        if ((string3 = (String)properties.get("font-weight")) != null) {
            n |= Font.getStyleValue(string3);
        }
        if ((string3 = (String)properties.get("font-style")) != null) {
            n |= Font.getStyleValue(string3);
        }
        if ((string3 = (String)properties.get("color")) != null) {
            color = MarkupParser.decodeColor(string3);
        }
        return FontFactory.getFont(string, string2, bl, f, n, color);
    }

    static {
        colorTable.put("black", new Color(0));
        colorTable.put("green", new Color(32768));
        colorTable.put("silver", new Color(0xC0C0C0));
        colorTable.put("lime", new Color(65280));
        colorTable.put("gray", new Color(0x808080));
        colorTable.put("olive", new Color(0x808000));
        colorTable.put("white", new Color(0xFFFFFF));
        colorTable.put("yellow", new Color(0xFFFF00));
        colorTable.put("maroon", new Color(0x800000));
        colorTable.put("navy", new Color(128));
        colorTable.put("red", new Color(0xFF0000));
        colorTable.put("blue", new Color(255));
        colorTable.put("purple", new Color(0x800080));
        colorTable.put("teal", new Color(32896));
        colorTable.put("fuchsia", new Color(0xFF00FF));
        colorTable.put("aqua", new Color(65535));
    }
}

