/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.util.CECalendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.Locale;

public final class EthiopicCalendar
extends CECalendar {
    private static final long serialVersionUID = -2438495771339315608L;
    public static final int MESKEREM = 0;
    public static final int TEKEMT = 1;
    public static final int HEDAR = 2;
    public static final int TAHSAS = 3;
    public static final int TER = 4;
    public static final int YEKATIT = 5;
    public static final int MEGABIT = 6;
    public static final int MIAZIA = 7;
    public static final int GENBOT = 8;
    public static final int SENE = 9;
    public static final int HAMLE = 10;
    public static final int NEHASSE = 11;
    public static final int PAGUMEN = 12;
    private static final int JD_EPOCH_OFFSET_AMETE_ALEM = -285019;
    private static final int JD_EPOCH_OFFSET_AMETE_MIHRET = 1723856;

    public EthiopicCalendar() {
        this.jdEpochOffset = 1723856;
    }

    public EthiopicCalendar(TimeZone zone) {
        super(zone);
        this.jdEpochOffset = 1723856;
    }

    public EthiopicCalendar(Locale aLocale) {
        super(aLocale);
        this.jdEpochOffset = 1723856;
    }

    public EthiopicCalendar(ULocale locale) {
        super(locale);
        this.jdEpochOffset = 1723856;
    }

    public EthiopicCalendar(TimeZone zone, Locale aLocale) {
        super(zone, aLocale);
        this.jdEpochOffset = 1723856;
    }

    public EthiopicCalendar(TimeZone zone, ULocale locale) {
        super(zone, locale);
        this.jdEpochOffset = 1723856;
    }

    public EthiopicCalendar(int year, int month, int date) {
        super(year, month, date);
        this.jdEpochOffset = 1723856;
    }

    public EthiopicCalendar(Date date) {
        super(date);
        this.jdEpochOffset = 1723856;
    }

    public EthiopicCalendar(int year, int month, int date, int hour, int minute, int second) {
        super(year, month, date, hour, minute, second);
        this.jdEpochOffset = 1723856;
    }

    public static int EthiopicToJD(long year, int month, int date) {
        return CECalendar.ceToJD(year, month, date, 1723856);
    }

    public static Integer[] getDateFromJD(int julianDay) {
        return CECalendar.getDateFromJD(julianDay, 1723856);
    }

    public void setAmeteAlemEra(boolean onOff) {
        this.jdEpochOffset = onOff ? -285019 : 1723856;
    }

    public boolean isAmeteAlemEra() {
        return this.jdEpochOffset == -285019;
    }

    public String getType() {
        return "ethiopic";
    }
}

